/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film.replays;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.settings.values.base.BaseKeyframeFactoryValue;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;

public class FormProperties
extends ValueGroup {
    public final Map<String, KeyframeChannel> properties = new HashMap<String, KeyframeChannel>();

    public FormProperties(String id) {
        super(id);
    }

    public void shift(float tick) {
        for (KeyframeChannel value : this.properties.values()) {
            for (Keyframe keyframe : value.getKeyframes()) {
                keyframe.setTick(keyframe.getTick() + tick);
            }
        }
    }

    public KeyframeChannel getOrCreate(Form form, String key) {
        BaseValue value = this.get(key);
        BaseValueBasic property = FormUtils.getProperty(form, key);
        if (value instanceof KeyframeChannel) {
            KeyframeChannel channel = (KeyframeChannel)value;
            return channel;
        }
        return property != null ? this.create(property) : null;
    }

    public KeyframeChannel create(BaseValue property) {
        if (property.isVisible() && property instanceof BaseKeyframeFactoryValue) {
            BaseKeyframeFactoryValue keyframeFactoryValue = (BaseKeyframeFactoryValue)property;
            String key = FormUtils.getPropertyPath(property);
            KeyframeChannel channel = new KeyframeChannel(key, keyframeFactoryValue.getFactory());
            this.properties.put(key, channel);
            this.add(channel);
            return channel;
        }
        return null;
    }

    @Override
    public void fromData(BaseType data) {
        super.fromData(data);
        this.properties.clear();
        if (!data.isMap()) {
            return;
        }
        MapType map = data.asMap();
        for (String key : map.keys()) {
            MapType mapType = map.getMap(key);
            if (mapType.isEmpty()) continue;
            KeyframeChannel<Object> property = new KeyframeChannel(key, null);
            property.fromData(mapType);
            if (key.endsWith("lighting") && property.getFactory() == KeyframeFactories.BOOLEAN) {
                KeyframeChannel<Float> newProperty = new KeyframeChannel<Float>(key, KeyframeFactories.FLOAT);
                Iterator iterator = property.getKeyframes().iterator();
                while (iterator.hasNext()) {
                    Keyframe keyframe;
                    Keyframe kf = keyframe = iterator.next();
                    Boolean v = (Boolean)kf.getValue();
                    newProperty.insert(kf.getTick(), Float.valueOf(v != false ? 1.0f : 0.0f));
                }
                property = newProperty;
            }
            if (property.getFactory() == null) continue;
            this.properties.put(key, property);
            this.add(property);
        }
    }
}

