/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film.replays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import org.joml.Vector2d;

public class ReplayKeyframes
extends ValueGroup {
    public static final String GROUP_POSITION = "position";
    public static final String GROUP_ROTATION = "rotation";
    public static final String GROUP_LEFT_STICK = "lstick";
    public static final String GROUP_RIGHT_STICK = "rstick";
    public static final String GROUP_TRIGGERS = "triggers";
    public static final String GROUP_EXTRA1 = "extra1";
    public static final String GROUP_EXTRA2 = "extra2";
    public static final List<String> CURATED_CHANNELS = Arrays.asList("x", "y", "z", "pitch", "yaw", "headYaw", "bodyYaw", "sneaking", "sprinting", "item_main_hand", "item_off_hand", "item_head", "item_chest", "item_legs", "item_feet", "selected_slot", "stick_lx", "stick_ly", "stick_rx", "stick_ry", "trigger_l", "trigger_r", "extra1_x", "extra1_y", "extra2_x", "extra2_y", "grounded", "damage", "vX", "vY", "vZ");
    public final KeyframeChannel<Double> x = new KeyframeChannel<Double>("x", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> y = new KeyframeChannel<Double>("y", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> z = new KeyframeChannel<Double>("z", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> vX = new KeyframeChannel<Double>("vX", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> vY = new KeyframeChannel<Double>("vY", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> vZ = new KeyframeChannel<Double>("vZ", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> yaw = new KeyframeChannel<Double>("yaw", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> pitch = new KeyframeChannel<Double>("pitch", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> headYaw = new KeyframeChannel<Double>("headYaw", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> bodyYaw = new KeyframeChannel<Double>("bodyYaw", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> sneaking = new KeyframeChannel<Double>("sneaking", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> sprinting = new KeyframeChannel<Double>("sprinting", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> grounded = new KeyframeChannel<Double>("grounded", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> fall = new KeyframeChannel<Double>("fall", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> damage = new KeyframeChannel<Double>("damage", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> stickLeftX = new KeyframeChannel<Double>("stick_lx", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> stickLeftY = new KeyframeChannel<Double>("stick_ly", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> stickRightX = new KeyframeChannel<Double>("stick_rx", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> stickRightY = new KeyframeChannel<Double>("stick_ry", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> triggerLeft = new KeyframeChannel<Double>("trigger_l", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> triggerRight = new KeyframeChannel<Double>("trigger_r", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> extra1X = new KeyframeChannel<Double>("extra1_x", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> extra1Y = new KeyframeChannel<Double>("extra1_y", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> extra2X = new KeyframeChannel<Double>("extra2_x", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<Double> extra2Y = new KeyframeChannel<Double>("extra2_y", KeyframeFactories.DOUBLE);
    public final KeyframeChannel<class_1799> mainHand = new KeyframeChannel<class_1799>("item_main_hand", KeyframeFactories.ITEM_STACK);
    public final KeyframeChannel<class_1799> offHand = new KeyframeChannel<class_1799>("item_off_hand", KeyframeFactories.ITEM_STACK);
    public final KeyframeChannel<class_1799> armorHead = new KeyframeChannel<class_1799>("item_head", KeyframeFactories.ITEM_STACK);
    public final KeyframeChannel<class_1799> armorChest = new KeyframeChannel<class_1799>("item_chest", KeyframeFactories.ITEM_STACK);
    public final KeyframeChannel<class_1799> armorLegs = new KeyframeChannel<class_1799>("item_legs", KeyframeFactories.ITEM_STACK);
    public final KeyframeChannel<class_1799> armorFeet = new KeyframeChannel<class_1799>("item_feet", KeyframeFactories.ITEM_STACK);
    public final KeyframeChannel<Integer> selectedSlot = new KeyframeChannel<Integer>("selected_slot", KeyframeFactories.INTEGER);

    public ReplayKeyframes(String id) {
        super(id);
        this.add(this.x);
        this.add(this.y);
        this.add(this.z);
        this.add(this.vX);
        this.add(this.vY);
        this.add(this.vZ);
        this.add(this.yaw);
        this.add(this.pitch);
        this.add(this.headYaw);
        this.add(this.bodyYaw);
        this.add(this.sneaking);
        this.add(this.sprinting);
        this.add(this.grounded);
        this.add(this.fall);
        this.add(this.damage);
        this.add(this.stickLeftX);
        this.add(this.stickLeftY);
        this.add(this.stickRightX);
        this.add(this.stickRightY);
        this.add(this.triggerLeft);
        this.add(this.triggerRight);
        this.add(this.extra1X);
        this.add(this.extra1Y);
        this.add(this.extra2X);
        this.add(this.extra2Y);
        this.add(this.mainHand);
        this.add(this.offHand);
        this.add(this.armorHead);
        this.add(this.armorChest);
        this.add(this.armorLegs);
        this.add(this.armorFeet);
        this.add(this.selectedSlot);
    }

    public List<KeyframeChannel<?>> getChannels() {
        ArrayList channels = new ArrayList();
        for (BaseValue baseValue : this.getAll()) {
            if (!(baseValue instanceof KeyframeChannel)) continue;
            KeyframeChannel channel = (KeyframeChannel)baseValue;
            channels.add(channel);
        }
        return channels;
    }

    public void shift(float tick) {
        for (KeyframeChannel<?> channel : this.getChannels()) {
            for (Keyframe<?> keyframe : channel.getKeyframes()) {
                keyframe.setTick(keyframe.getTick() + tick);
            }
        }
    }

    public void copyOver(ReplayKeyframes keyframes, int tick) {
        for (KeyframeChannel<?> channel : this.getChannels()) {
            BaseValue keyframe = keyframes.get(channel.getId());
            if (!(keyframe instanceof KeyframeChannel)) continue;
            KeyframeChannel keyframeChannel = (KeyframeChannel)keyframe;
            channel.copyOver(keyframeChannel, tick);
        }
    }

    public void record(int tick, IEntity entity, List<String> groups) {
        boolean extra2;
        boolean empty = groups == null || groups.isEmpty();
        boolean position = empty || groups.contains(GROUP_POSITION);
        boolean rotation = empty || groups.contains(GROUP_ROTATION);
        boolean leftStick = empty || groups.contains(GROUP_LEFT_STICK);
        boolean rightStick = empty || groups.contains(GROUP_RIGHT_STICK);
        boolean triggers = empty || groups.contains(GROUP_TRIGGERS);
        boolean extra1 = empty || groups.contains(GROUP_EXTRA1);
        boolean bl = extra2 = empty || groups.contains(GROUP_EXTRA2);
        if (position) {
            this.x.insert(tick, entity.getX());
            this.y.insert(tick, entity.getY());
            this.z.insert(tick, entity.getZ());
            this.vX.insert(tick, entity.getVelocity().field_1352);
            this.vY.insert(tick, entity.getVelocity().field_1351);
            this.vZ.insert(tick, entity.getVelocity().field_1350);
            this.fall.insert(tick, Double.valueOf(entity.getFallDistance()));
        }
        this.sneaking.insert(tick, entity.isSneaking() ? 1.0 : 0.0);
        this.sprinting.insert(tick, entity.isSprinting() ? 1.0 : 0.0);
        this.grounded.insert(tick, entity.isOnGround() ? 1.0 : 0.0);
        this.damage.insert(tick, Double.valueOf(entity.getHurtTimer()));
        if (rotation) {
            this.yaw.insert(tick, Double.valueOf(entity.getYaw()));
            this.pitch.insert(tick, Double.valueOf(entity.getPitch()));
            this.headYaw.insert(tick, Double.valueOf(entity.getHeadYaw()));
            this.bodyYaw.insert(tick, Double.valueOf(entity.getBodyYaw()));
        }
        float[] sticks = entity.getExtraVariables();
        if (leftStick) {
            this.stickLeftX.insert(tick, Double.valueOf(sticks[0]));
            this.stickLeftY.insert(tick, Double.valueOf(sticks[1]));
        }
        if (rightStick) {
            this.stickRightX.insert(tick, Double.valueOf(sticks[2]));
            this.stickRightY.insert(tick, Double.valueOf(sticks[3]));
        }
        if (triggers) {
            this.triggerLeft.insert(tick, Double.valueOf(sticks[4]));
            this.triggerRight.insert(tick, Double.valueOf(sticks[5]));
        }
        if (extra1) {
            this.extra1X.insert(tick, Double.valueOf(sticks[6]));
            this.extra1Y.insert(tick, Double.valueOf(sticks[7]));
        }
        if (extra2) {
            this.extra2X.insert(tick, Double.valueOf(sticks[8]));
            this.extra2Y.insert(tick, Double.valueOf(sticks[9]));
        }
        if (empty) {
            this.mainHand.insert(tick, entity.getEquipmentStack(class_1304.field_6173).method_7972());
            this.offHand.insert(tick, entity.getEquipmentStack(class_1304.field_6171).method_7972());
            this.armorHead.insert(tick, entity.getEquipmentStack(class_1304.field_6169).method_7972());
            this.armorChest.insert(tick, entity.getEquipmentStack(class_1304.field_6174).method_7972());
            this.armorLegs.insert(tick, entity.getEquipmentStack(class_1304.field_6172).method_7972());
            this.armorFeet.insert(tick, entity.getEquipmentStack(class_1304.field_6166).method_7972());
            this.selectedSlot.insert(tick, entity.getSelectedSlot());
        }
    }

    public void apply(int tick, IEntity entity, List<String> groups) {
        boolean extra2;
        boolean empty = groups == null || groups.isEmpty();
        boolean position = empty || !groups.contains(GROUP_POSITION);
        boolean rotation = empty || !groups.contains(GROUP_ROTATION);
        boolean leftStick = empty || !groups.contains(GROUP_LEFT_STICK);
        boolean rightStick = empty || !groups.contains(GROUP_RIGHT_STICK);
        boolean triggers = empty || !groups.contains(GROUP_TRIGGERS);
        boolean extra1 = empty || !groups.contains(GROUP_EXTRA1);
        boolean bl = extra2 = empty || !groups.contains(GROUP_EXTRA2);
        if (position) {
            entity.setVelocity(this.vX.interpolate(tick).floatValue(), this.vY.interpolate(tick).floatValue(), this.vZ.interpolate(tick).floatValue());
            entity.setFallDistance(this.fall.interpolate(tick).floatValue());
            KeyframeSegment<Double> x = this.x.findSegment(tick);
            Vector2d xx = this.getPrev(x, this.x.interpolate(tick - 1), tick);
            KeyframeSegment<Double> y = this.y.findSegment(tick);
            Vector2d yy = this.getPrev(y, this.y.interpolate(tick - 1), tick);
            KeyframeSegment<Double> z = this.z.findSegment(tick);
            Vector2d zz = this.getPrev(z, this.z.interpolate(tick - 1), tick);
            entity.setPosition(xx.x, yy.x, zz.x);
            entity.setPrevX(xx.y);
            entity.setPrevY(yy.y);
            entity.setPrevZ(zz.y);
        }
        if (rotation) {
            KeyframeSegment<Double> yaw = this.yaw.findSegment(tick);
            Vector2d yyaw = this.getPrev(yaw, this.yaw.interpolate(tick - 1), tick);
            KeyframeSegment<Double> pitch = this.pitch.findSegment(tick);
            Vector2d ppitch = this.getPrev(pitch, this.pitch.interpolate(tick - 1), tick);
            KeyframeSegment<Double> headYaw = this.headYaw.findSegment(tick);
            Vector2d hheadYaw = this.getPrev(headYaw, this.headYaw.interpolate(tick - 1), tick);
            KeyframeSegment<Double> bodyYaw = this.bodyYaw.findSegment(tick);
            Vector2d bbodyYaw = this.getPrev(bodyYaw, this.bodyYaw.interpolate(tick - 1), tick);
            entity.setYaw((float)yyaw.x);
            entity.setPitch((float)ppitch.x);
            entity.setHeadYaw((float)hheadYaw.x);
            entity.setBodyYaw((float)bbodyYaw.x);
            entity.setPrevYaw((float)yyaw.y);
            entity.setPrevPitch((float)ppitch.y);
            entity.setPrevHeadYaw((float)hheadYaw.y);
            entity.setPrevBodyYaw((float)bbodyYaw.y);
        }
        entity.setSneaking(this.sneaking.interpolate(tick) != 0.0);
        entity.setSprinting(this.sprinting.interpolate(tick) != 0.0);
        entity.setOnGround(this.grounded.interpolate(tick) != 0.0);
        entity.setHurtTimer(this.damage.interpolate(tick).intValue());
        float[] sticks = entity.getExtraVariables();
        if (leftStick) {
            sticks[0] = this.stickLeftX.interpolate(tick).floatValue();
            sticks[1] = this.stickLeftY.interpolate(tick).floatValue();
        }
        if (rightStick) {
            sticks[2] = this.stickRightX.interpolate(tick).floatValue();
            sticks[3] = this.stickRightY.interpolate(tick).floatValue();
        }
        if (triggers) {
            sticks[4] = this.triggerLeft.interpolate(tick).floatValue();
            sticks[5] = this.triggerRight.interpolate(tick).floatValue();
        }
        if (extra1) {
            sticks[6] = this.extra1X.interpolate(tick).floatValue();
            sticks[7] = this.extra1Y.interpolate(tick).floatValue();
        }
        if (extra2) {
            sticks[8] = this.extra2X.interpolate(tick).floatValue();
            sticks[9] = this.extra2Y.interpolate(tick).floatValue();
        }
        entity.setEquipmentStack(class_1304.field_6173, this.mainHand.interpolate(tick));
        entity.setEquipmentStack(class_1304.field_6171, this.offHand.interpolate(tick));
        entity.setEquipmentStack(class_1304.field_6169, this.armorHead.interpolate(tick));
        entity.setEquipmentStack(class_1304.field_6174, this.armorChest.interpolate(tick));
        entity.setEquipmentStack(class_1304.field_6172, this.armorLegs.interpolate(tick));
        entity.setEquipmentStack(class_1304.field_6166, this.armorFeet.interpolate(tick));
    }

    private Vector2d getPrev(KeyframeSegment<Double> frame, double prev, int tick) {
        if (frame == null) {
            return new Vector2d(prev, prev);
        }
        IInterp interp = frame.a.getInterpolation().getInterp();
        Double interpolated = frame.createInterpolated();
        if (interp == Interpolations.CONST || interp == Interpolations.STEP) {
            if (interpolated != null) {
                prev = interpolated;
            }
            return new Vector2d(prev, prev);
        }
        if (frame.preA != frame.a && frame.a.getTick() == (float)tick && (frame.preA.getInterpolation().getInterp() == Interpolations.CONST || frame.preA.getInterpolation().getInterp() == Interpolations.STEP)) {
            if (interpolated != null) {
                prev = interpolated;
            }
            return new Vector2d(prev, prev);
        }
        return new Vector2d(interpolated == null ? prev : interpolated, prev);
    }
}

