/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.forms.BodyPart;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.settings.values.IValueNotifier;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.StringUtils;

public class FormUtils {
    public static final String PATH_SEPARATOR = "/";
    private static final List<String> path = new ArrayList<String>();

    public static Form fromData(BaseType data) {
        if (data instanceof MapType) {
            MapType map = (MapType)data;
            return FormUtils.fromData(map);
        }
        return null;
    }

    public static Form fromData(MapType data) {
        try {
            return data == null ? null : (Form)BBSMod.getForms().fromData(data);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static MapType toData(Form form) {
        return form == null ? null : BBSMod.getForms().toData(form);
    }

    public static Form copy(Form form) {
        return form == null ? null : form.copy();
    }

    public static Form getRoot(Form form) {
        while (form.getParent() != null) {
            form = form.getParent();
        }
        return form;
    }

    public static Form getForm(BaseValue property) {
        IValueNotifier iValueNotifier = property.getParent();
        if (iValueNotifier instanceof Form) {
            Form form = (Form)iValueNotifier;
            return form;
        }
        return null;
    }

    public static Form getForm(Form form, String path) {
        String[] split;
        for (String s : split = path.split(PATH_SEPARATOR)) {
            try {
                int index = Integer.parseInt(s);
                BodyPart safe = CollectionUtils.getSafe(form.parts.getAll(), index);
                if (safe == null) break;
                form = safe.getForm();
            }
            catch (Exception e) {
                break;
            }
        }
        return form;
    }

    public static String getPath(Form form) {
        if (form.getParent() == null) {
            return "";
        }
        path.clear();
        while (form != null) {
            Form parent = form.getParent();
            if (parent != null) {
                int i = 0;
                for (BodyPart part : parent.parts.getAll()) {
                    if (part.getForm() == form) {
                        path.add(String.valueOf(i));
                    }
                    ++i;
                }
            }
            form = parent;
        }
        Collections.reverse(path);
        return String.join((CharSequence)PATH_SEPARATOR, path);
    }

    public static String getPropertyPath(BaseValue property) {
        path.clear();
        path.add(property.getId());
        Form form = FormUtils.getForm(property);
        while (form != null) {
            Form parent = form.getParent();
            if (parent != null) {
                int i = 0;
                for (BodyPart part : parent.parts.getAll()) {
                    if (part.getForm() == form) {
                        path.add(String.valueOf(i));
                    }
                    ++i;
                }
            }
            form = parent;
        }
        Collections.reverse(path);
        return String.join((CharSequence)PATH_SEPARATOR, path);
    }

    public static List<String> collectPropertyPaths(Form form) {
        ArrayList<String> properties = new ArrayList<String>();
        FormUtils.collectPropertyPaths(form, properties, "");
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).endsWith("/anchor")) continue;
            it.remove();
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    public static void collectPropertyPaths(Form form, List<String> properties, String prefix) {
        void var4_6;
        if (form == null || !((Boolean)form.animatable.get()).booleanValue()) {
            return;
        }
        for (BaseValue baseValue : form.getProperties().values()) {
            if (!baseValue.isVisible()) continue;
            properties.add(StringUtils.combinePaths(prefix, baseValue.getId()));
        }
        List<BodyPart> all = form.parts.getAll();
        boolean bl = false;
        while (var4_6 < all.size()) {
            String newPrefix = StringUtils.combinePaths(prefix, String.valueOf((int)var4_6));
            FormUtils.collectPropertyPaths(all.get((int)var4_6).getForm(), properties, newPrefix);
            ++var4_6;
        }
    }

    public static BaseValueBasic getProperty(Form form, String path) {
        if (form == null) {
            return null;
        }
        if (!path.contains(PATH_SEPARATOR)) {
            return form.getProperties().get(path);
        }
        String[] segments = path.split(PATH_SEPARATOR);
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            BaseValueBasic property = form.getProperties().get(segment);
            if (property == null) {
                try {
                    int index = Integer.parseInt(segment);
                    if (CollectionUtils.inRange(form.parts.getAll(), index)) {
                        form = form.parts.getAll().get(index).getForm();
                        if (form != null) continue;
                        return null;
                    }
                    return null;
                }
                catch (Exception exception) {}
                continue;
            }
            return property;
        }
        return null;
    }
}

