/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.Stack;
import mchorse.bbs_mod.forms.CustomVertexConsumerProvider;
import mchorse.bbs_mod.forms.forms.AnchorForm;
import mchorse.bbs_mod.forms.forms.BillboardForm;
import mchorse.bbs_mod.forms.forms.BlockForm;
import mchorse.bbs_mod.forms.forms.ExtrudedForm;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.FramebufferForm;
import mchorse.bbs_mod.forms.forms.ItemForm;
import mchorse.bbs_mod.forms.forms.LabelForm;
import mchorse.bbs_mod.forms.forms.MobForm;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.forms.ParticleForm;
import mchorse.bbs_mod.forms.forms.TrailForm;
import mchorse.bbs_mod.forms.forms.VanillaParticleForm;
import mchorse.bbs_mod.forms.renderers.AnchorFormRenderer;
import mchorse.bbs_mod.forms.renderers.BillboardFormRenderer;
import mchorse.bbs_mod.forms.renderers.BlockFormRenderer;
import mchorse.bbs_mod.forms.renderers.ExtrudedFormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderer;
import mchorse.bbs_mod.forms.renderers.FormRenderingContext;
import mchorse.bbs_mod.forms.renderers.FramebufferFormRenderer;
import mchorse.bbs_mod.forms.renderers.ItemFormRenderer;
import mchorse.bbs_mod.forms.renderers.LabelFormRenderer;
import mchorse.bbs_mod.forms.renderers.MobFormRenderer;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.forms.renderers.ParticleFormRenderer;
import mchorse.bbs_mod.forms.renderers.TrailFormRenderer;
import mchorse.bbs_mod.forms.renderers.VanillaParticleFormRenderer;
import mchorse.bbs_mod.ui.framework.UIContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1088;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4722;
import net.minecraft.class_750;

@Environment(value=EnvType.CLIENT)
public class FormUtilsClient {
    private static Map<Class, IFormRendererFactory> map = new HashMap<Class, IFormRendererFactory>();
    private static CustomVertexConsumerProvider customVertexConsumerProvider;
    private static Stack<Form> currentForm;

    private static void assignBufferBuilder(Object2ObjectLinkedOpenHashMap<class_1921, class_287> builderStorage, class_1921 layer) {
        builderStorage.put((Object)layer, (Object)new class_287(layer.method_22722()));
    }

    public static CustomVertexConsumerProvider getProvider() {
        return customVertexConsumerProvider;
    }

    private static <T extends Form> void register(Class<T> clazz, IFormRendererFactory<T> function) {
        map.put(clazz, function);
    }

    public static Form getCurrentForm() {
        return currentForm.isEmpty() ? null : currentForm.peek();
    }

    public static FormRenderer getRenderer(Form form) {
        if (form == null) {
            return null;
        }
        Object object = form.getRenderer();
        if (object instanceof FormRenderer) {
            FormRenderer renderer = (FormRenderer)object;
            return renderer;
        }
        IFormRendererFactory factory = map.get(form.getClass());
        if (factory != null) {
            FormRenderer<Form> formRenderer = factory.create(form);
            form.setRenderer(formRenderer);
            return formRenderer;
        }
        return null;
    }

    public static void renderUI(Form form, UIContext context, int x1, int y1, int x2, int y2) {
        FormRenderer renderer = FormUtilsClient.getRenderer(form);
        if (renderer != null) {
            renderer.renderUI(context, x1, y1, x2, y2);
        }
    }

    public static void render(Form form, FormRenderingContext context) {
        FormRenderer renderer = FormUtilsClient.getRenderer(form);
        if (renderer != null) {
            currentForm.push(form);
            try {
                renderer.render(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentForm.pop();
        }
    }

    public static List<String> getBones(Form form) {
        FormRenderer renderer = FormUtilsClient.getRenderer(form);
        if (renderer != null) {
            return renderer.getBones();
        }
        return Collections.emptyList();
    }

    static {
        currentForm = new Stack();
        class_750 storage = new class_750();
        SortedMap sortedMap = (SortedMap)class_156.method_654((Object)new Object2ObjectLinkedOpenHashMap(), map -> {
            map.put((Object)class_4722.method_24073(), (Object)storage.method_3154(class_1921.method_23577()));
            map.put((Object)class_4722.method_24074(), (Object)storage.method_3154(class_1921.method_23581()));
            map.put((Object)class_4722.method_24059(), (Object)storage.method_3154(class_1921.method_23579()));
            map.put((Object)class_4722.method_24076(), (Object)storage.method_3154(class_1921.method_23583()));
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_4722.method_24067());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_4722.method_24069());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_4722.method_24070());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_4722.method_24071());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_4722.method_45783());
            map.put((Object)class_4722.method_24072(), (Object)new class_287(786432));
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_27948());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_27949());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_23590());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_29706());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_30676());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_23591());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_29707());
            FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, class_1921.method_23589());
            class_1088.field_21772.forEach(renderLayer -> FormUtilsClient.assignBufferBuilder((Object2ObjectLinkedOpenHashMap<class_1921, class_287>)map, renderLayer));
        });
        customVertexConsumerProvider = new CustomVertexConsumerProvider(new class_287(1536), sortedMap);
        FormUtilsClient.register(BillboardForm.class, BillboardFormRenderer::new);
        FormUtilsClient.register(ExtrudedForm.class, ExtrudedFormRenderer::new);
        FormUtilsClient.register(LabelForm.class, LabelFormRenderer::new);
        FormUtilsClient.register(ModelForm.class, ModelFormRenderer::new);
        FormUtilsClient.register(ParticleForm.class, ParticleFormRenderer::new);
        FormUtilsClient.register(BlockForm.class, BlockFormRenderer::new);
        FormUtilsClient.register(ItemForm.class, ItemFormRenderer::new);
        FormUtilsClient.register(AnchorForm.class, AnchorFormRenderer::new);
        FormUtilsClient.register(MobForm.class, MobFormRenderer::new);
        FormUtilsClient.register(VanillaParticleForm.class, VanillaParticleFormRenderer::new);
        FormUtilsClient.register(TrailForm.class, TrailFormRenderer::new);
        FormUtilsClient.register(FramebufferForm.class, FramebufferFormRenderer::new);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface IFormRendererFactory<T extends Form> {
        public FormRenderer<T> create(T var1);
    }
}

