/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.IMapSerializable;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormArchitect;
import mchorse.bbs_mod.forms.ITickable;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.BodyPartManager;
import mchorse.bbs_mod.forms.forms.utils.Anchor;
import mchorse.bbs_mod.forms.states.AnimationStates;
import mchorse.bbs_mod.forms.values.ValueAnchor;
import mchorse.bbs_mod.settings.values.IValueNotifier;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.settings.values.core.ValueTransform;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.pose.Transform;
import net.minecraft.class_1309;
import net.minecraft.class_5134;

public abstract class Form
implements IMapSerializable,
IValueNotifier {
    private Form parent;
    public final ValueBoolean visible = new ValueBoolean("visible", true);
    public final ValueBoolean animatable = new ValueBoolean("animatable", true);
    public final ValueString trackName = new ValueString("track_name", "");
    public final ValueFloat lighting = new ValueFloat("lighting", Float.valueOf(1.0f));
    public final ValueString name = new ValueString("name", "");
    public final ValueTransform transform = new ValueTransform("transform", new Transform());
    public final ValueTransform transformOverlay = new ValueTransform("transform_overlay", new Transform());
    public final ValueFloat uiScale = new ValueFloat("uiScale", Float.valueOf(1.0f));
    public final ValueAnchor anchor = new ValueAnchor("anchor", new Anchor());
    public final ValueBoolean shaderShadow = new ValueBoolean("shaderShadow", true);
    public final List<ValueTransform> additionalTransforms = new ArrayList<ValueTransform>();
    public final ValueBoolean hitbox = new ValueBoolean("hitbox", false);
    public final ValueFloat hitboxWidth = new ValueFloat("hitboxWidth", Float.valueOf(0.5f));
    public final ValueFloat hitboxHeight = new ValueFloat("hitboxHeight", Float.valueOf(1.8f));
    public final ValueFloat hitboxSneakMultiplier = new ValueFloat("hitboxSneakMultiplier", Float.valueOf(0.9f));
    public final ValueFloat hitboxEyeHeight = new ValueFloat("hitboxEyeHeight", Float.valueOf(0.9f));
    public final ValueFloat hp = new ValueFloat("hp", Float.valueOf(20.0f));
    public final ValueFloat speed = new ValueFloat("movement_speed", Float.valueOf(0.1f));
    public final ValueFloat stepHeight = new ValueFloat("step_height", Float.valueOf(0.5f));
    public final ValueInt hotkey = new ValueInt("keybind", 0);
    public final BodyPartManager parts = new BodyPartManager(this);
    public final AnimationStates states = new AnimationStates("states");
    protected Object renderer;
    protected String cachedID;
    protected final Map<String, BaseValueBasic> properties = new LinkedHashMap<String, BaseValueBasic>();

    public Form() {
        this.animatable.invisible();
        this.trackName.invisible();
        this.name.invisible();
        this.uiScale.invisible();
        this.shaderShadow.invisible();
        this.register(this.visible);
        this.register(this.animatable);
        this.register(this.trackName);
        this.register(this.lighting);
        this.register(this.name);
        this.register(this.transform);
        this.register(this.transformOverlay);
        for (int i = 0; i < (Integer)BBSSettings.recordingPoseTransformOverlays.get(); ++i) {
            ValueTransform valueTransform = new ValueTransform("transform_overlay" + i, new Transform());
            this.additionalTransforms.add(valueTransform);
            this.register(valueTransform);
        }
        this.register(this.uiScale);
        this.register(this.anchor);
        this.register(this.shaderShadow);
        this.hitbox.invisible();
        this.hitboxWidth.invisible();
        this.hitboxHeight.invisible();
        this.hitboxSneakMultiplier.invisible();
        this.hitboxEyeHeight.invisible();
        this.register(this.hitbox);
        this.register(this.hitboxWidth);
        this.register(this.hitboxHeight);
        this.register(this.hitboxSneakMultiplier);
        this.register(this.hitboxEyeHeight);
        this.hp.invisible();
        this.speed.invisible();
        this.stepHeight.invisible();
        this.register(this.hp);
        this.register(this.speed);
        this.register(this.stepHeight);
        this.hotkey.invisible();
        this.register(this.hotkey);
    }

    public Object getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Object renderer) {
        this.renderer = renderer;
    }

    protected void register(BaseValueBasic property) {
        if (this.properties.containsKey(property.getId())) {
            throw new IllegalStateException("Property " + property.getId() + " was already registered for form by ID " + this.getId() + "!");
        }
        this.properties.put(property.getId(), property);
        property.setParent(this);
    }

    public Map<String, BaseValueBasic> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    void setParent(Form parent) {
        this.parent = parent;
    }

    @Override
    public Form getParent() {
        return this.parent;
    }

    public void onMorph(class_1309 entity) {
        float hp = ((Float)this.hp.get()).floatValue();
        float speed = ((Float)this.speed.get()).floatValue();
        float stepHeight = ((Float)this.stepHeight.get()).floatValue();
        if (hp != 20.0f) {
            entity.method_5996(class_5134.field_23716).method_6192((double)hp);
            entity.method_6033(hp);
        }
        if (speed != 0.1f) {
            entity.method_5996(class_5134.field_23719).method_6192((double)speed);
        }
        if (stepHeight != 0.5f) {
            entity.method_49477(stepHeight);
        }
    }

    public void onDemorph(class_1309 entity) {
        entity.method_5996(class_5134.field_23716).method_6192(20.0);
        entity.method_6033(20.0f);
        entity.method_5996(class_5134.field_23719).method_6192((double)0.1f);
        entity.method_49477(0.5f);
    }

    public String getId() {
        if (this.cachedID == null) {
            this.cachedID = BBSMod.getForms().getType(this).toString();
        }
        return this.cachedID;
    }

    public String getIdOrName() {
        String name = (String)this.name.get();
        return name.isEmpty() ? this.getId() : name;
    }

    public final String getDisplayName() {
        String name = (String)this.name.get();
        if (!name.isEmpty()) {
            return name;
        }
        return this.getDefaultDisplayName();
    }

    protected String getDefaultDisplayName() {
        return this.getId();
    }

    public String getTrackName(String property) {
        String s = (String)this.trackName.get();
        if (!s.isEmpty()) {
            if (property.isEmpty()) {
                return s;
            }
            int slash = property.lastIndexOf(47);
            String last = slash == -1 ? property : property.substring(slash + 1);
            return s + (String)(StringUtils.isInteger(last) ? "" : "/" + last);
        }
        return property;
    }

    public void update(IEntity entity) {
        this.parts.update(entity);
        if (this.renderer instanceof ITickable) {
            ((ITickable)this.renderer).tick(entity);
        }
    }

    public final Form copy() {
        FormArchitect forms = BBSMod.getForms();
        return (Form)forms.fromData(forms.toData(this));
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Form) {
            Form form = (Form)obj;
            if (!this.parts.equals(form.parts)) {
                return false;
            }
            if (this.properties.size() != form.properties.size()) {
                return false;
            }
            for (String key : this.properties.keySet()) {
                if (this.properties.get(key).equals(form.properties.get(key))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void preNotify(int flag) {
    }

    @Override
    public void postNotify(int flag) {
    }

    @Override
    public void toData(MapType data) {
        data.put("bodyParts", this.parts.toData());
        data.put("states", this.states.toData());
        for (BaseValue baseValue : this.properties.values()) {
            data.put(baseValue.getId(), (BaseType)baseValue.toData());
        }
    }

    @Override
    public void fromData(MapType data) {
        this.parts.fromData(data.getMap("bodyParts"));
        this.states.fromData(data.getMap("states"));
        for (BaseValue baseValue : this.properties.values()) {
            BaseType type = data.get(baseValue.getId());
            if (type == null) continue;
            baseValue.fromData(type);
        }
    }
}

