/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics.window;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class Window {
    private static int verticalScroll;
    private static long lastScroll;

    public static long getWindow() {
        return class_310.method_1551().method_22683().method_4490();
    }

    public static void setVerticalScroll(int scroll) {
        verticalScroll = scroll;
        lastScroll = System.currentTimeMillis();
    }

    public static int getVerticalScroll() {
        if (lastScroll + 5L < System.currentTimeMillis()) {
            return 0;
        }
        return verticalScroll;
    }

    public static boolean isMouseButtonPressed(int mouse) {
        return GLFW.glfwGetMouseButton((long)Window.getWindow(), (int)mouse) == 1;
    }

    public static boolean isCtrlPressed() {
        return class_437.method_25441();
    }

    public static boolean isShiftPressed() {
        return class_437.method_25442();
    }

    public static boolean isAltPressed() {
        return class_437.method_25443();
    }

    public static boolean isKeyPressed(int key) {
        return class_3675.method_15987((long)Window.getWindow(), (int)key);
    }

    public static String getClipboard() {
        try {
            String string = GLFW.glfwGetClipboardString((long)Window.getWindow());
            return string == null ? "" : string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static MapType getClipboardMap() {
        return DataToString.mapFromString(Window.getClipboard());
    }

    public static MapType getClipboardMap(String verificationKey) {
        MapType data = DataToString.mapFromString(Window.getClipboard());
        return data != null && data.getBool(verificationKey) ? data : null;
    }

    public static ListType getClipboardList() {
        return DataToString.listFromString(Window.getClipboard());
    }

    public static void setClipboard(String string) {
        if (string.length() > 1024) {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            ByteBuffer buffer = MemoryUtil.memAlloc((int)(bytes.length + 1));
            buffer.put(bytes);
            buffer.put((byte)0);
            buffer.flip();
            GLFW.glfwSetClipboardString((long)Window.getWindow(), (ByteBuffer)buffer);
            MemoryUtil.memFree((Buffer)buffer);
        } else {
            GLFW.glfwSetClipboardString((long)Window.getWindow(), (CharSequence)string);
        }
    }

    public static void setClipboard(BaseType data) {
        if (data != null) {
            Window.setClipboard(DataToString.toString(data, true));
        }
    }

    public static void setClipboard(MapType data, String verificationKey) {
        if (data != null) {
            data.putBool(verificationKey, true);
        }
        Window.setClipboard(data);
    }

    public static void moveCursor(int x, int y) {
        GLFW.glfwSetCursorPos((long)Window.getWindow(), (double)x, (double)y);
    }
}

