/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.math.functions;

import mchorse.bbs_mod.math.Constant;
import mchorse.bbs_mod.math.IExpression;
import mchorse.bbs_mod.math.MathBuilder;

public abstract class Function
implements IExpression {
    protected MathBuilder builder;
    protected IExpression[] args;
    protected String name;
    protected IExpression result = new Constant(0.0);

    public Function(MathBuilder builder, IExpression[] expressions, String name) throws Exception {
        this.builder = builder;
        this.args = expressions;
        this.name = name;
        if (expressions.length < this.getRequiredArguments()) {
            String message = String.format("Function '%s' requires at least %s arguments. %s are given!", this.getName(), this.getRequiredArguments(), expressions.length);
            throw new Exception(message);
        }
        for (int i = 0; i < expressions.length; ++i) {
            this.verifyArgument(i, expressions[i]);
        }
    }

    protected void verifyArgument(int index, IExpression expression) {
    }

    @Override
    public void set(double value) {
    }

    @Override
    public void set(String value) {
    }

    public IExpression getArg(int index) {
        if (index < 0 || index >= this.args.length) {
            throw new IllegalStateException("Index should be within the argument's length range! Given " + index + ", arguments length: " + this.args.length);
        }
        return this.args[index].get();
    }

    public String toString() {
        Object args = "";
        for (int i = 0; i < this.args.length; ++i) {
            args = (String)args + this.args[i].toString();
            if (i >= this.args.length - 1) continue;
            args = (String)args + ", ";
        }
        return this.getName() + "(" + (String)args + ")";
    }

    public String getName() {
        return this.name;
    }

    public int getRequiredArguments() {
        return 0;
    }
}

