/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.mixin.client;

import java.util.Map;
import mchorse.bbs_mod.forms.renderers.MobFormRenderer;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.pose.PoseTransform;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_922;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_922.class})
public abstract class LivingEntityRendererMixin {
    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;setAngles(Lnet/minecraft/entity/Entity;FFFFF)V", ordinal=0, shift=At.Shift.AFTER)})
    public void onSetAngles(class_1309 livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo info) {
        Pose pose = MobFormRenderer.getCurrentPose();
        Pose poseOverlay = MobFormRenderer.getCurrentPoseOverlay();
        if (pose != null) {
            pose = pose.copy();
            for (Map.Entry<String, PoseTransform> transformEntry : poseOverlay.transforms.entrySet()) {
                PoseTransform poseTransform = pose.get(transformEntry.getKey());
                PoseTransform value = transformEntry.getValue();
                if (value.fix != 0.0f) {
                    poseTransform.translate.lerp((Vector3fc)value.translate, value.fix);
                    poseTransform.scale.lerp((Vector3fc)value.scale, value.fix);
                    poseTransform.rotate.lerp((Vector3fc)value.rotate, value.fix);
                    poseTransform.rotate2.lerp((Vector3fc)value.rotate2, value.fix);
                    continue;
                }
                poseTransform.translate.add((Vector3fc)value.translate);
                poseTransform.scale.add((Vector3fc)value.scale).sub(1.0f, 1.0f, 1.0f);
                poseTransform.rotate.add((Vector3fc)value.rotate);
                poseTransform.rotate2.add((Vector3fc)value.rotate2);
            }
            Map<String, class_630> parts = MobFormRenderer.getParts().get(livingEntity.getClass());
            if (parts != null) {
                for (Map.Entry<String, class_630> entry : parts.entrySet()) {
                    String key = entry.getKey();
                    class_630 value = entry.getValue();
                    PoseTransform poseTransform = pose.transforms.get(key);
                    if (poseTransform == null) continue;
                    Transform transform = new Transform();
                    transform.translate.x = value.field_3657;
                    transform.translate.y = value.field_3656;
                    transform.translate.z = value.field_3655;
                    transform.rotate.x = value.field_3654;
                    transform.rotate.y = value.field_3675;
                    transform.rotate.z = value.field_3674;
                    transform.scale.x = value.field_37938;
                    transform.scale.y = value.field_37939;
                    transform.scale.z = value.field_37940;
                    value.field_3657 += poseTransform.translate.x;
                    value.field_3656 += poseTransform.translate.y;
                    value.field_3655 += poseTransform.translate.z;
                    value.field_3654 += poseTransform.rotate.x;
                    value.field_3675 += poseTransform.rotate.y;
                    value.field_3674 += poseTransform.rotate.z;
                    value.field_37938 += poseTransform.scale.x - 1.0f;
                    value.field_37939 += poseTransform.scale.y - 1.0f;
                    value.field_37940 += poseTransform.scale.z - 1.0f;
                    MobFormRenderer.getCache().put(value, transform);
                }
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void onRenderEnd(class_1309 livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo info) {
        for (Map.Entry<class_630, Transform> entry : MobFormRenderer.getCache().entrySet()) {
            Transform transform = entry.getValue();
            class_630 value = entry.getKey();
            value.field_3657 = transform.translate.x;
            value.field_3656 = transform.translate.y;
            value.field_3655 = transform.translate.z;
            value.field_3654 = transform.rotate.x;
            value.field_3675 = transform.rotate.y;
            value.field_3674 = transform.rotate.z;
            value.field_37938 = transform.scale.x;
            value.field_37939 = transform.scale.y;
            value.field_37940 = transform.scale.z;
        }
        MobFormRenderer.getCache().clear();
    }
}

