/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.particles.ParticleCurve;
import mchorse.bbs_mod.particles.ParticleMaterial;
import mchorse.bbs_mod.particles.ParticleMolangParser;
import mchorse.bbs_mod.particles.ParticleParser;
import mchorse.bbs_mod.particles.components.IComponentBase;
import mchorse.bbs_mod.particles.components.IComponentEmitterInitialize;
import mchorse.bbs_mod.particles.components.IComponentEmitterUpdate;
import mchorse.bbs_mod.particles.components.IComponentParticleInitialize;
import mchorse.bbs_mod.particles.components.IComponentParticleRender;
import mchorse.bbs_mod.particles.components.IComponentParticleUpdate;
import mchorse.bbs_mod.particles.components.ParticleComponentBase;
import mchorse.bbs_mod.particles.components.motion.ParticleComponentInitialSpeed;
import mchorse.bbs_mod.particles.emitter.Particle;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ParticleScheme
extends ValueGroup {
    public static final Link DEFAULT_TEXTURE = Link.assets("textures/default_atlas.png");
    public static final ParticleParser PARSER = new ParticleParser();
    public String identifier = "";
    public ParticleMaterial material = ParticleMaterial.OPAQUE;
    public Link texture = DEFAULT_TEXTURE;
    public Map<String, ParticleCurve> curves = new HashMap<String, ParticleCurve>();
    public List<ParticleComponentBase> components = new ArrayList<ParticleComponentBase>();
    public List<IComponentEmitterInitialize> emitterInitializes;
    public List<IComponentEmitterUpdate> emitterUpdates;
    public List<IComponentParticleInitialize> particleInitializes;
    public List<IComponentParticleUpdate> particleUpdates;
    public List<IComponentParticleRender> particleRender;
    public final ParticleMolangParser parser = new ParticleMolangParser(this);
    public Particle particle;
    public ParticleEmitter emitter;

    public static ParticleScheme parse(String json) {
        return ParticleScheme.parse(DataToString.mapFromString(json));
    }

    public static ParticleScheme parse(MapType json) {
        try {
            return PARSER.fromData(json);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MapType toData(ParticleScheme scheme) {
        return PARSER.toData(scheme);
    }

    public static ParticleScheme dupe(ParticleScheme scheme) {
        return ParticleScheme.parse(ParticleScheme.toData(scheme));
    }

    public ParticleScheme() {
        super("");
        this.parser.register("variable.particle_age");
        this.parser.register("variable.particle_lifetime");
        this.parser.register("variable.particle_random_1");
        this.parser.register("variable.particle_random_2");
        this.parser.register("variable.particle_random_3");
        this.parser.register("variable.particle_random_4");
        this.parser.register("variable.emitter_age");
        this.parser.register("variable.emitter_lifetime");
        this.parser.register("variable.emitter_random_1");
        this.parser.register("variable.emitter_random_2");
        this.parser.register("variable.emitter_random_3");
        this.parser.register("variable.emitter_random_4");
    }

    public void setup() {
        this.getOrCreate(ParticleComponentInitialSpeed.class);
        this.emitterInitializes = this.getComponents(IComponentEmitterInitialize.class);
        this.emitterUpdates = this.getComponents(IComponentEmitterUpdate.class);
        this.particleInitializes = this.getComponents(IComponentParticleInitialize.class);
        this.particleUpdates = this.getComponents(IComponentParticleUpdate.class);
        this.particleRender = this.getComponents(IComponentParticleRender.class);
        for (Map.Entry<String, ParticleCurve> entry : this.curves.entrySet()) {
            entry.getValue().variable = this.parser.getOrCreateVariable(entry.getKey());
        }
    }

    public void addComponent(ParticleComponentBase base) {
        this.remove(base.getClass());
        this.components.add(base);
    }

    public <T extends IComponentBase> List<T> getComponents(Class<T> clazz) {
        ArrayList<IComponentBase> list = new ArrayList<IComponentBase>();
        for (ParticleComponentBase component : this.components) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            list.add((IComponentBase)((Object)component));
        }
        if (list.size() > 1) {
            Collections.sort(list, Comparator.comparingInt(IComponentBase::getSortingIndex));
        }
        return list;
    }

    public <T extends ParticleComponentBase> T get(Class<T> clazz) {
        for (ParticleComponentBase component : this.components) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            return (T)component;
        }
        return null;
    }

    public <T extends ParticleComponentBase> T add(Class<T> clazz) {
        ParticleComponentBase result = null;
        try {
            result = (ParticleComponentBase)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.addComponent(result);
            this.setup();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)result;
    }

    public <T extends ParticleComponentBase> T getOrCreate(Class<T> clazz) {
        return this.getOrCreate(clazz, clazz);
    }

    public <T extends ParticleComponentBase> T getOrCreate(Class<T> clazz, Class subclass) {
        T result = this.get(clazz);
        if (result == null) {
            result = this.add(subclass);
        }
        return result;
    }

    public <T extends ParticleComponentBase> T remove(Class<T> clazz) {
        Iterator<ParticleComponentBase> it = this.components.iterator();
        while (it.hasNext()) {
            ParticleComponentBase component = it.next();
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            it.remove();
            return (T)component;
        }
        return null;
    }

    public <T extends ParticleComponentBase> T replace(Class<T> clazz, Class subclass) {
        this.remove(clazz);
        return this.add(subclass);
    }

    public void updateCurves() {
        for (ParticleCurve curve : this.curves.values()) {
            if (curve.variable == null) continue;
            curve.variable.set(curve.compute());
        }
    }

    @Override
    public void fromData(BaseType data) {
        try {
            PARSER.fromData(this, data.asMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public BaseType toData() {
        return PARSER.toData(this);
    }
}

