/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.particles.components.shape.directions;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.StringType;
import mchorse.bbs_mod.particles.components.shape.directions.ShapeDirection;
import mchorse.bbs_mod.particles.emitter.Particle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class ShapeDirectionInwards
extends ShapeDirection {
    public static final ShapeDirection INWARDS = new ShapeDirectionInwards(-1.0f);
    public static final ShapeDirection OUTWARDS = new ShapeDirectionInwards(1.0f);
    private float factor;

    public ShapeDirectionInwards(float factor) {
        this.factor = factor;
    }

    public static ShapeDirection fromString(String value) {
        if (value.equals("inwards")) {
            return INWARDS;
        }
        return OUTWARDS;
    }

    @Override
    public void applyDirection(Particle particle, double x, double y, double z) {
        Vector3d vector = new Vector3d((Vector3dc)particle.position);
        vector.sub((Vector3dc)new Vector3d(x, y, z));
        if (vector.length() <= 0.0) {
            vector.set(0.0, 0.0, 0.0);
        } else {
            vector.normalize();
            vector.mul((double)this.factor);
        }
        particle.speed.set((Vector3dc)vector);
    }

    @Override
    public BaseType toData() {
        return new StringType(this.factor < 0.0f ? "inwards" : "outwards");
    }
}

