/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.dashboard;

import java.io.File;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.utils.PNGEncoder;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIDebugPanel
extends UIDashboardPanel {
    public UIKeyframes keyframes = new UIKeyframes(null).duration(() -> 40);
    public UIButton button;

    public UIDebugPanel(UIDashboard dashboard) {
        super(dashboard);
        this.keyframes.full(this);
        for (int i = 0; i < 20; ++i) {
            KeyframeChannel<Double> channel = new KeyframeChannel<Double>("baboy", KeyframeFactories.DOUBLE);
            UIKeyframeSheet sheet = new UIKeyframeSheet("baboy_" + i, IKey.raw("Baboy " + i), Colors.HSVtoRGB((float)Math.random(), 1.0f, 1.0f).getRGBColor(), false, channel, null);
            channel.insert(0.0f, 0.0);
            channel.insert(20L + (long)(Math.random() * 18.0 - 9.0), 0.0);
            channel.insert(40.0f, 1.0);
            channel.get(1).setDuration(10.0f);
            this.keyframes.addSheet(sheet);
        }
        this.button = new UIButton(IKey.raw("Hello"), b -> {
            try {
                Pixels newP = Pixels.fromSize(32, 512);
                for (int i = 0; i < 16; ++i) {
                    Link link = Link.assets("textures/abc/sonic_boom_" + i + ".png");
                    Pixels pixels = Pixels.fromPNGStream(BBSMod.getProvider().getAsset(link));
                    newP.draw(pixels, 0, i * 32);
                    pixels.delete();
                }
                newP.rewindBuffer();
                File file = BBSMod.getProvider().getFile(Link.assets("textures/sonic_boom.png"));
                PNGEncoder.writeToFile(newP, file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.button.relative(this).xy(10, 10).w(80);
        this.add((IUIElement)this.button);
    }

    @Override
    public void resize() {
        super.resize();
        this.keyframes.resetViewX();
    }
}

