/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.dashboard.utils;

import mchorse.bbs_mod.graphics.line.LineBuilder;
import mchorse.bbs_mod.graphics.line.SolidColorLineRenderer;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.math.IExpression;
import mchorse.bbs_mod.math.MathBuilder;
import mchorse.bbs_mod.math.Variable;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.utils.UICanvas;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIGraphCanvas
extends UICanvas {
    private MathBuilder builder = new MathBuilder();
    private Variable x = this.builder.register("x");
    private boolean first = true;
    public IExpression expression;

    public UIGraphCanvas() {
        this.scaleY.inverse = true;
    }

    public void parseExpression(String expression) {
        try {
            this.expression = this.builder.parse(expression);
        }
        catch (Exception e) {
            this.expression = null;
        }
    }

    @Override
    public void resize() {
        super.resize();
        if (this.first) {
            this.scaleX.view(-10.0, 10.0);
            this.scaleX.calculateMultiplier();
            this.scaleY.view(-10.0, 10.0);
            this.scaleY.calculateMultiplier();
            this.first = false;
        }
    }

    @Override
    protected void renderCanvas(UIContext context) {
        this.area.render(context.batcher, -2013265920);
        this.renderVerticalGrid(context);
        this.renderHorizontalGridAndGraph(context);
    }

    private void renderVerticalGrid(UIContext context) {
        int ty = (int)this.scaleY.from(this.area.ey());
        int by = (int)this.scaleY.from(this.area.y - 12);
        int min = Math.min(ty, by) - 1;
        int max = Math.max(ty, by) + 1;
        int mult = this.scaleY.getMult();
        min -= min % mult + mult;
        max -= max % mult - mult;
        int c = (max - min) / mult;
        for (int j = 0; j < c; ++j) {
            int y = (int)this.scaleY.to(min + j * mult);
            if (y >= this.area.ey()) continue;
            context.batcher.box(this.area.x, y, this.area.ex(), y + 1, Colors.setA(-1, 0.25f));
            context.batcher.text(String.valueOf(min + j * mult), this.area.x + 4, y + 4);
        }
    }

    private void renderHorizontalGridAndGraph(UIContext context) {
        int x;
        int tx = (int)this.scaleX.from(this.area.ex());
        int bx = (int)this.scaleX.from(this.area.x);
        int min = Math.min(tx, bx) - 1;
        int max = Math.max(tx, bx) + 1;
        int mult = this.scaleX.getMult();
        min -= min % mult + mult;
        max -= max % mult - mult;
        int c = (max - min) / mult;
        for (int j = 0; j < c && (x = (int)this.scaleX.to(min + j * mult)) < this.area.ex(); ++j) {
            context.batcher.box(x, this.area.y, x + 1, this.area.ey(), Colors.setA(-1, 0.25f));
            context.batcher.text(String.valueOf(min + j * mult), x + 4, this.area.y + 4);
        }
        if (this.expression == null) {
            return;
        }
        if (Window.isMouseButtonPressed(0) && !context.isFocused()) {
            int mouseX = context.mouseX;
            double x2 = this.scaleX.from(mouseX);
            this.x.set(x2);
            double y = this.expression.get().doubleValue();
            int y1 = context.mouseY;
            int y2 = (int)this.scaleY.to(y) + 1;
            boolean isNaN = Double.isNaN(y);
            if (y1 < y2) {
                y1 -= 12;
            }
            String coordinate = "(" + UITrackpad.format(x2) + ", " + (isNaN ? "undefined" : UITrackpad.format(y)) + ")";
            if (!isNaN) {
                context.batcher.box(mouseX, Math.min(y1, y2), mouseX + 1, Math.max(y1, y2), -11012822);
            }
            int y3 = y1 < y2 ? y1 : y1 - 12;
            int w = context.batcher.getFont().getWidth(coordinate);
            context.batcher.box(++mouseX, y3, mouseX + w + 4, y3 + 12, -1);
            context.batcher.text(coordinate, mouseX + 2, y3 + 2, 0);
        }
        LineBuilder line = new LineBuilder(1.0f);
        double step = 1.0;
        for (double j = (double)this.area.x - step; j < (double)this.area.ex() + step; j += step) {
            double previous = this.scaleX.from(j);
            this.x.set(previous);
            double y1 = this.expression.get().doubleValue();
            line.add((float)j, (float)this.scaleY.to(y1));
        }
        line.render(context.batcher, SolidColorLineRenderer.get(0.0f, 0.5f, 1.0f, 1.0f));
    }
}

