/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.actions.types.AttackActionClip;
import mchorse.bbs_mod.actions.types.DamageActionClip;
import mchorse.bbs_mod.actions.types.FormTriggerClientActionClip;
import mchorse.bbs_mod.actions.types.SwipeActionClip;
import mchorse.bbs_mod.actions.types.blocks.BreakBlockActionClip;
import mchorse.bbs_mod.actions.types.blocks.InteractBlockActionClip;
import mchorse.bbs_mod.actions.types.blocks.PlaceBlockActionClip;
import mchorse.bbs_mod.actions.types.chat.ChatActionClip;
import mchorse.bbs_mod.actions.types.chat.CommandActionClip;
import mchorse.bbs_mod.actions.types.item.ItemDropActionClip;
import mchorse.bbs_mod.actions.types.item.UseBlockItemActionClip;
import mchorse.bbs_mod.actions.types.item.UseItemActionClip;
import mchorse.bbs_mod.camera.clips.misc.AudioClientClip;
import mchorse.bbs_mod.camera.clips.misc.CurveClientClip;
import mchorse.bbs_mod.camera.clips.misc.SubtitleClip;
import mchorse.bbs_mod.camera.clips.misc.TrackerClientClip;
import mchorse.bbs_mod.camera.clips.modifiers.AngleClip;
import mchorse.bbs_mod.camera.clips.modifiers.DollyZoomClip;
import mchorse.bbs_mod.camera.clips.modifiers.DragClip;
import mchorse.bbs_mod.camera.clips.modifiers.LookClip;
import mchorse.bbs_mod.camera.clips.modifiers.MathClip;
import mchorse.bbs_mod.camera.clips.modifiers.OrbitClip;
import mchorse.bbs_mod.camera.clips.modifiers.RemapperClip;
import mchorse.bbs_mod.camera.clips.modifiers.ShakeClip;
import mchorse.bbs_mod.camera.clips.modifiers.TranslateClip;
import mchorse.bbs_mod.camera.clips.overwrite.DollyClip;
import mchorse.bbs_mod.camera.clips.overwrite.IdleClip;
import mchorse.bbs_mod.camera.clips.overwrite.KeyframeClip;
import mchorse.bbs_mod.camera.clips.overwrite.PathClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.camera.utils.TimeUtils;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.UIAngleClip;
import mchorse.bbs_mod.ui.film.clips.UIAudioClip;
import mchorse.bbs_mod.ui.film.clips.UICurveClip;
import mchorse.bbs_mod.ui.film.clips.UIDollyClip;
import mchorse.bbs_mod.ui.film.clips.UIDollyZoomClip;
import mchorse.bbs_mod.ui.film.clips.UIDragClip;
import mchorse.bbs_mod.ui.film.clips.UIIdleClip;
import mchorse.bbs_mod.ui.film.clips.UIKeyframeClip;
import mchorse.bbs_mod.ui.film.clips.UILookClip;
import mchorse.bbs_mod.ui.film.clips.UIMathClip;
import mchorse.bbs_mod.ui.film.clips.UIOrbitClip;
import mchorse.bbs_mod.ui.film.clips.UIPathClip;
import mchorse.bbs_mod.ui.film.clips.UIRemapperClip;
import mchorse.bbs_mod.ui.film.clips.UIShakeClip;
import mchorse.bbs_mod.ui.film.clips.UISubtitleClip;
import mchorse.bbs_mod.ui.film.clips.UITrackerClip;
import mchorse.bbs_mod.ui.film.clips.UITranslateClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIAttackActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIBreakBlockActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIChatActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UICommandActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIDamageActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIFormTriggerActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIInteractBlockActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIItemDropActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIPlaceBlockActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UISwipeActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIUseBlockItemActionClip;
import mchorse.bbs_mod.ui.film.clips.actions.UIUseItemActionClip;
import mchorse.bbs_mod.ui.film.clips.widgets.UIEnvelope;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.utils.ScrollDirection;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.utils.TimeUtilsClient;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.undo.IUndo;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UIClip<T extends Clip>
extends UIElement {
    private static final Map<Class, IUIClipFactory> FACTORIES = new HashMap<Class, IUIClipFactory>();
    private static final Map<Class, Integer> SCROLLS = new HashMap<Class, Integer>();
    public T clip;
    public IUIClipsDelegate editor;
    public UIToggle enabled;
    public UITextbox title;
    public UITrackpad layer;
    public UITrackpad tick;
    public UITrackpad duration;
    public UIEnvelope envelope;
    public UIScrollView panels;

    public static <T extends Clip> void register(Class<T> clazz, IUIClipFactory<T> factory) {
        FACTORIES.put(clazz, factory);
    }

    public static void saveScroll(UIClip editor) {
        if (editor != null) {
            SCROLLS.put(editor.clip.getClass(), (int)editor.panels.scroll.getScroll());
        }
    }

    public static UIClip createPanel(Clip clip, IUIClipsDelegate delegate) {
        UIClip clipEditor;
        IUIClipFactory factory = FACTORIES.get(clip.getClass());
        UIClip uIClip = clipEditor = factory == null ? null : factory.create(clip, delegate);
        if (clipEditor != null) {
            clipEditor.panels.scroll.setScroll(SCROLLS.getOrDefault(clip.getClass(), 0).intValue());
        }
        return clipEditor;
    }

    public static UILabel label(IKey key) {
        return UI.label(key).background(() -> BBSSettings.primaryColor(-2013265920));
    }

    public UIClip(T clip, IUIClipsDelegate editor) {
        this.clip = clip;
        this.editor = editor;
        this.enabled = new UIToggle(UIKeys.CAMERA_PANELS_ENABLED, b -> this.editor.editMultiple(((Clip)this.clip).enabled, value -> value.set(b.getValue())));
        this.title = new UITextbox(1000, t -> ((Clip)this.clip).title.set(t));
        this.title.tooltip(UIKeys.CAMERA_PANELS_TITLE_TOOLTIP);
        this.layer = new UITrackpad(v -> this.editor.editMultiple(((Clip)this.clip).layer, v.intValue()));
        this.layer.limit(0.0, 2.147483647E9, true).tooltip(UIKeys.CAMERA_PANELS_LAYER);
        this.tick = new UITrackpad(v -> this.editor.editMultiple(((Clip)this.clip).tick, TimeUtils.fromTime(v)));
        this.tick.limit(0.0, 2.147483647E9, true).tooltip(UIKeys.CAMERA_PANELS_TICK);
        this.duration = new UITrackpad(v -> {
            this.editor.editMultiple(((Clip)this.clip).duration, TimeUtils.fromTime(v));
            this.updateDuration(TimeUtils.fromTime(v));
        });
        this.duration.limit(1.0, 2.147483647E9, true).tooltip(UIKeys.CAMERA_PANELS_DURATION);
        this.envelope = new UIEnvelope(this);
        this.envelope.channel.setUndoId("envelope_keyframes");
        boolean horizontal = (Boolean)BBSSettings.editorHorizontalClipEditor.get();
        this.panels = new UIScrollView(horizontal ? ScrollDirection.HORIZONTAL : ScrollDirection.VERTICAL);
        this.panels.scroll.cancelScrolling();
        if (horizontal) {
            this.panels.full(this).column(5).scroll().width(140).padding(10);
        } else {
            this.panels.full(this).column(5).scroll().vertical().stretch().padding(10);
        }
        this.registerUI();
        this.registerPanels();
        this.add((IUIElement)this.panels);
    }

    protected void registerUI() {
    }

    protected void registerPanels() {
        this.panels.add(UIClip.label(UIKeys.CAMERA_PANELS_TITLE), this.title);
        this.panels.add((IUIElement)this.enabled.marginBottom(6));
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_METRICS), UI.row(this.layer, this.tick), this.duration));
        this.addEnvelopes();
    }

    protected void addEnvelopes() {
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_ENVELOPES_TITLE), this.envelope).marginTop(12));
    }

    public void handleUndo(IUndo<ValueGroup> undo, boolean redo) {
        this.fillData();
    }

    protected void updateDuration(int duration) {
    }

    public void editClip(Position position) {
        this.fillData();
    }

    public void fillData() {
        TimeUtilsClient.configure(this.tick, 0);
        TimeUtilsClient.configure(this.duration, 1);
        this.enabled.setValue((Boolean)((Clip)this.clip).enabled.get());
        this.title.setText((String)((Clip)this.clip).title.get());
        this.layer.setValue(((Integer)((Clip)this.clip).layer.get()).intValue());
        this.tick.setValue(TimeUtils.toTime((Integer)((Clip)this.clip).tick.get()));
        this.duration.setValue(TimeUtils.toTime((Integer)((Clip)this.clip).duration.get()));
        this.envelope.fillData();
    }

    @Override
    public void render(UIContext context) {
        context.batcher.gradientHBox(this.area.x - 40, this.area.y, this.area.ex() - 40, this.area.ey(), 0, 0x44000000);
        context.batcher.box(this.area.ex() - 40, this.area.y, this.area.ex(), this.area.ey(), 0x44000000);
        super.render(context);
    }

    @Override
    public void applyUndoData(MapType data) {
        super.applyUndoData(data);
        if (data.getString("embed").equals("envelope")) {
            this.editor.embedView(this.envelope.channel);
            this.envelope.channel.view.editSheet(this.envelope.channel.view.getGraph().getSheets().get(0));
            this.envelope.channel.view.resetView();
        }
    }

    @Override
    public void collectUndoData(MapType data) {
        super.collectUndoData(data);
        if (this.envelope.channel.hasParent()) {
            data.putString("embed", "envelope");
        }
    }

    static {
        UIClip.register(IdleClip.class, UIIdleClip::new);
        UIClip.register(DollyClip.class, UIDollyClip::new);
        UIClip.register(PathClip.class, UIPathClip::new);
        UIClip.register(KeyframeClip.class, UIKeyframeClip::new);
        UIClip.register(TranslateClip.class, UITranslateClip::new);
        UIClip.register(AngleClip.class, UIAngleClip::new);
        UIClip.register(DragClip.class, UIDragClip::new);
        UIClip.register(ShakeClip.class, UIShakeClip::new);
        UIClip.register(MathClip.class, UIMathClip::new);
        UIClip.register(LookClip.class, UILookClip::new);
        UIClip.register(TrackerClientClip.class, UITrackerClip::new);
        UIClip.register(OrbitClip.class, UIOrbitClip::new);
        UIClip.register(RemapperClip.class, UIRemapperClip::new);
        UIClip.register(AudioClientClip.class, UIAudioClip::new);
        UIClip.register(SubtitleClip.class, UISubtitleClip::new);
        UIClip.register(CurveClientClip.class, UICurveClip::new);
        UIClip.register(DollyZoomClip.class, UIDollyZoomClip::new);
        UIClip.register(ChatActionClip.class, UIChatActionClip::new);
        UIClip.register(CommandActionClip.class, UICommandActionClip::new);
        UIClip.register(PlaceBlockActionClip.class, UIPlaceBlockActionClip::new);
        UIClip.register(InteractBlockActionClip.class, UIInteractBlockActionClip::new);
        UIClip.register(BreakBlockActionClip.class, UIBreakBlockActionClip::new);
        UIClip.register(UseItemActionClip.class, UIUseItemActionClip::new);
        UIClip.register(UseBlockItemActionClip.class, UIUseBlockItemActionClip::new);
        UIClip.register(AttackActionClip.class, UIAttackActionClip::new);
        UIClip.register(DamageActionClip.class, UIDamageActionClip::new);
        UIClip.register(ItemDropActionClip.class, UIItemDropActionClip::new);
        UIClip.register(SwipeActionClip.class, UISwipeActionClip::new);
        UIClip.register(FormTriggerClientActionClip.class, UIFormTriggerActionClip::new);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface IUIClipFactory<T extends Clip> {
        public UIClip create(T var1, IUIClipsDelegate var2);
    }
}

