/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import mchorse.bbs_mod.camera.clips.CameraClipContext;
import mchorse.bbs_mod.camera.clips.overwrite.DollyClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.clips.modules.UIAngleModule;
import mchorse.bbs_mod.ui.film.clips.modules.UIPointModule;
import mchorse.bbs_mod.ui.film.utils.UICameraUtils;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.context.UIInterpolationContextMenu;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.tooltips.InterpolationTooltip;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIDollyClip
extends UIClip<DollyClip> {
    public UIPointModule point;
    public UIAngleModule angle;
    public UITrackpad distance;
    public UIIcon reverse;
    public UIButton interp;
    public UITrackpad yaw;
    public UITrackpad pitch;

    public UIDollyClip(DollyClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    @Override
    protected void registerUI() {
        super.registerUI();
        this.point = new UIPointModule(this.editor);
        this.angle = new UIAngleModule(this.editor);
        this.distance = new UITrackpad(value -> ((DollyClip)this.clip).distance.set(Float.valueOf(value.floatValue())));
        this.distance.tooltip(UIKeys.CAMERA_PANELS_DOLLY_DISTANCE);
        this.reverse = new UIIcon(Icons.REVERSE, b -> this.reverse());
        this.reverse.tooltip(UIKeys.CAMERA_PANELS_DOLLY_REVERSE);
        this.yaw = new UITrackpad(value -> ((DollyClip)this.clip).yaw.set(Float.valueOf(value.floatValue())));
        this.yaw.tooltip(UIKeys.CAMERA_PANELS_DOLLY_YAW);
        this.pitch = new UITrackpad(value -> ((DollyClip)this.clip).pitch.set(Float.valueOf(value.floatValue())));
        this.pitch.tooltip(UIKeys.CAMERA_PANELS_DOLLY_PITCH);
        this.interp = new UIButton(UIKeys.CAMERA_PANELS_INTERPOLATION, b -> this.getContext().replaceContextMenu(new UIInterpolationContextMenu(((DollyClip)this.clip).interp)));
        this.interp.tooltip(new InterpolationTooltip(1.0f, 0.5f, () -> ((DollyClip)this.clip).interp));
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.CAMERA_PANELS_DOLLY_TITLE), UI.row(0, 0, 20, this.distance, this.reverse)).marginTop(12));
        this.panels.add(this.yaw, this.pitch, this.interp);
        this.panels.add(this.point.marginTop(12), this.angle.marginTop(6));
        this.panels.context((ContextMenuManager menu) -> UICameraUtils.positionContextMenu(menu, this.editor, ((DollyClip)this.clip).position));
    }

    private void reverse() {
        Position position = new Position();
        ((DollyClip)this.clip).applyLast(new CameraClipContext(), position);
        ((DollyClip)this.clip).position.set(position);
        ((DollyClip)this.clip).distance.set(Float.valueOf(-((Float)((DollyClip)this.clip).distance.get()).floatValue()));
        this.fillData();
    }

    @Override
    public void editClip(Position position) {
        ((DollyClip)this.clip).position.set(position);
        ((DollyClip)this.clip).yaw.set(Float.valueOf(position.angle.yaw));
        ((DollyClip)this.clip).pitch.set(Float.valueOf(position.angle.pitch));
        super.editClip(position);
    }

    @Override
    public void fillData() {
        super.fillData();
        this.point.fill(((DollyClip)this.clip).position.getPoint());
        this.angle.fill(((DollyClip)this.clip).position.getAngle());
        this.yaw.setValue(((Float)((DollyClip)this.clip).yaw.get()).floatValue());
        this.pitch.setValue(((Float)((DollyClip)this.clip).pitch.get()).floatValue());
        this.distance.setValue(((Float)((DollyClip)this.clip).distance.get()).floatValue());
    }
}

