/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import java.util.function.Consumer;
import mchorse.bbs_mod.camera.clips.modifiers.RemapperClip;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.replays.UIReplaysEditor;
import mchorse.bbs_mod.ui.film.utils.keyframes.UIFilmKeyframes;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeEditor;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIRemapperClip
extends UIClip<RemapperClip> {
    public UIKeyframeEditor keyframes;
    public UIButton edit;

    public UIRemapperClip(RemapperClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    @Override
    protected void registerUI() {
        super.registerUI();
        this.keyframes = new UIKeyframeEditor(consumer -> new UIFilmKeyframes(this.editor, (Consumer<Keyframe>)consumer));
        this.keyframes.view.backgroundRenderer(context -> UIReplaysEditor.renderBackground(context, this.keyframes.view, (Clips)((RemapperClip)this.clip).getParentValue(), (Integer)((RemapperClip)this.clip).tick.get()));
        this.keyframes.view.duration(() -> (Integer)((RemapperClip)this.clip).duration.get());
        this.keyframes.setUndoId("remapper_keyframes");
        this.edit = new UIButton(UIKeys.CAMERA_PANELS_EDIT_KEYFRAMES, b -> {
            this.editor.embedView(this.keyframes);
            this.keyframes.view.resetView();
            this.keyframes.view.editSheet(this.keyframes.view.getGraph().getSheets().get(0));
        });
        this.edit.keys().register(Keys.FORMS_EDIT, () -> this.edit.clickItself());
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add((IUIElement)UI.column(UIClip.label(UIKeys.C_CLIP.get("bbs:remapper")), this.edit).marginTop(12));
    }

    @Override
    public void fillData() {
        super.fillData();
        this.keyframes.setChannel(((RemapperClip)this.clip).channel, 35071);
    }

    @Override
    public void updateDuration(int duration) {
        super.updateDuration(duration);
        this.keyframes.updateConverter();
    }

    @Override
    public void applyUndoData(MapType data) {
        super.applyUndoData(data);
        if (data.getString("embed").equals("remapper")) {
            this.editor.embedView(this.keyframes);
            this.keyframes.view.editSheet(this.keyframes.view.getGraph().getSheets().get(0));
            this.keyframes.view.resetView();
        }
    }

    @Override
    public void collectUndoData(MapType data) {
        super.collectUndoData(data);
        if (this.keyframes.hasParent()) {
            data.putString("embed", "remapper");
        }
    }
}

