/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.controller;

import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.film.BaseFilmController;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.FilmControllerContext;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.MCEntity;
import mchorse.bbs_mod.forms.entities.StubEntity;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.ui.ValueOnionSkin;
import mchorse.bbs_mod.ui.film.controller.UIFilmController;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;

@Environment(value=EnvType.CLIENT)
public class FilmEditorController
extends BaseFilmController {
    public UIFilmController controller;
    private int lastTick;

    public FilmEditorController(Film film, UIFilmController controller) {
        super(film);
        this.controller = controller;
    }

    @Override
    public Map<String, Integer> getActors() {
        return this.controller.getActors();
    }

    @Override
    public int getTick() {
        return this.controller.panel.getRunner().ticks;
    }

    @Override
    protected void updateEntities(int ticks) {
        ticks = this.getTick() + (this.controller.panel.getRunner().isRunning() ? 1 : 0);
        super.updateEntities(ticks);
        this.lastTick = ticks;
    }

    @Override
    protected void updateEntityAndForm(IEntity entity, int tick) {
        boolean isActor;
        boolean isPlaying = this.controller.isPlaying();
        boolean bl = isActor = !(entity instanceof MCEntity);
        if (isPlaying && isActor) {
            super.updateEntityAndForm(entity, tick);
        }
    }

    @Override
    protected void applyReplay(Replay replay, int ticks, IEntity entity) {
        boolean isActor;
        List<String> groups = this.controller.getRecordingGroups();
        boolean isPlaying = this.controller.isPlaying();
        boolean bl = isActor = !(entity instanceof MCEntity);
        if (entity != this.controller.getControlled() || this.controller.isRecording() && this.controller.getRecordingCountdown() <= 0 && groups != null) {
            replay.applyFrame(ticks, entity, entity == this.controller.getControlled() ? groups : null);
            replay.applyClientActions(ticks, entity, this.film);
        }
        if (entity == this.controller.getControlled() && this.controller.isRecording() && this.controller.panel.getRunner().isRunning()) {
            replay.keyframes.record(this.controller.panel.getRunner().ticks, entity, groups);
        }
        ticks = this.getTick() + (this.controller.panel.getRunner().isRunning() ? 1 : 0);
        if (!isPlaying && isActor) {
            entity.setPrevX(entity.getX());
            entity.setPrevY(entity.getY());
            entity.setPrevZ(entity.getZ());
            entity.setPrevYaw(entity.getYaw());
            entity.setPrevHeadYaw(entity.getHeadYaw());
            entity.setPrevBodyYaw(entity.getBodyYaw());
            entity.setPrevPitch(entity.getPitch());
            for (int diff = Math.abs(this.lastTick - ticks); diff > 0; --diff) {
                entity.update();
                if (entity.getForm() == null) continue;
                entity.getForm().update(entity);
            }
        }
    }

    @Override
    protected float getTransition(IEntity entity, float transition) {
        boolean current = this.isCurrent(entity) && this.controller.isControlling();
        float delta = !this.controller.isPlaying() && !current ? 0.0f : transition;
        return delta;
    }

    @Override
    protected boolean canUpdate(int i, Replay replay, IEntity entity, BaseFilmController.UpdateMode updateMode) {
        return super.canUpdate(i, replay, entity, updateMode) || this.controller.getPovMode() != 3 || !this.isCurrent(entity) || !this.controller.orbit.enabled;
    }

    @Override
    protected void renderEntity(WorldRenderContext context, Replay replay, IEntity entity) {
        boolean current = this.isCurrent(entity);
        if (this.controller.getPovMode() != 3 || !current) {
            super.renderEntity(context, replay, entity);
        }
        boolean isPlaying = this.controller.isPlaying();
        int ticks = replay.getTick(this.getTick());
        ValueOnionSkin onionSkin = this.controller.getOnionSkin();
        BaseValue value = replay.properties.get((String)onionSkin.group.get());
        if (value == null) {
            value = replay.properties.get("pose");
        }
        if (value instanceof KeyframeChannel) {
            KeyframeChannel pose = (KeyframeChannel)value;
            if (entity instanceof StubEntity) {
                KeyframeSegment segment;
                boolean canRender = (Boolean)onionSkin.enabled.get();
                if (!((Boolean)onionSkin.all.get()).booleanValue()) {
                    boolean bl = canRender = canRender && current;
                }
                if (canRender && (segment = pose.findSegment(ticks)) != null) {
                    this.renderOnion(replay, pose.getKeyframes().indexOf(segment.a), -1, pose, (Integer)onionSkin.preColor.get(), (Integer)onionSkin.preFrames.get(), context, isPlaying, entity);
                    this.renderOnion(replay, pose.getKeyframes().indexOf(segment.b), 1, pose, (Integer)onionSkin.postColor.get(), (Integer)onionSkin.postFrames.get(), context, isPlaying, entity);
                    replay.applyFrame(ticks, entity, null);
                    replay.applyProperties((float)ticks + this.getTransition(entity, context.tickDelta()), entity.getForm());
                    if (!isPlaying) {
                        entity.setPrevX(entity.getX());
                        entity.setPrevY(entity.getY());
                        entity.setPrevZ(entity.getZ());
                        entity.setPrevYaw(entity.getYaw());
                        entity.setPrevHeadYaw(entity.getHeadYaw());
                        entity.setPrevBodyYaw(entity.getBodyYaw());
                        entity.setPrevPitch(entity.getPitch());
                    }
                }
            }
        }
    }

    private void renderOnion(Replay replay, int index, int direction, KeyframeChannel<?> pose, int color, int frames, WorldRenderContext context, boolean isPlaying, IEntity entity) {
        List<Keyframe<?>> keyframes = pose.getKeyframes();
        float alpha = Colors.getA(color);
        while (CollectionUtils.inRange(keyframes, index) && frames > 0) {
            Keyframe<?> keyframe = keyframes.get(index);
            if (keyframe.getTick() != (float)this.getTick()) {
                replay.applyFrame((int)keyframe.getTick(), entity);
                replay.applyProperties((int)keyframe.getTick(), entity.getForm());
                BaseFilmController.renderEntity(FilmControllerContext.instance.setup(this.getEntities(), entity, replay, context).color(Colors.setA(color, alpha)).transition(0.0f));
                --frames;
                alpha *= alpha;
            }
            index += direction;
        }
    }

    @Override
    protected FilmControllerContext getFilmControllerContext(WorldRenderContext context, Replay replay, IEntity entity) {
        Pair<String, Boolean> bone = this.isCurrent(entity) && !this.controller.panel.recorder.isRecording() ? this.controller.getBone() : null;
        return super.getFilmControllerContext(context, replay, entity).transition(this.getTransition(entity, context.tickDelta())).bone(bone == null ? null : (String)bone.a, bone != null && (Boolean)bone.b != false);
    }

    private boolean isCurrent(IEntity entity) {
        return entity == this.controller.getCurrentEntity();
    }
}

