/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.replays;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIMessageOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIRecordOverlayPanel
extends UIMessageOverlayPanel {
    public UIIcon all;
    public UIIcon left;
    public UIIcon right;
    public UIIcon triggers;
    public UIIcon extra1;
    public UIIcon extra2;
    public UIIcon position;
    public UIIcon rotation;
    public UIIcon posRot;
    public UIElement bar;
    private Consumer<List<String>> callback;

    public UIRecordOverlayPanel(IKey title, IKey message, Consumer<List<String>> callback) {
        super(title, message);
        this.callback = callback;
        this.all = new UIIcon(Icons.SPHERE, b -> this.submit(null));
        this.left = new UIIcon(Icons.LEFT_STICK, b -> this.submit(Arrays.asList("lstick")));
        this.right = new UIIcon(Icons.RIGHT_STICK, b -> this.submit(Arrays.asList("rstick")));
        this.triggers = new UIIcon(Icons.TRIGGER, b -> this.submit(Arrays.asList("triggers")));
        this.extra1 = new UIIcon(Icons.GRAPH, b -> this.submit(Arrays.asList("extra1")));
        this.extra2 = new UIIcon(Icons.CURVES, b -> this.submit(Arrays.asList("extra2")));
        this.position = new UIIcon(Icons.ALL_DIRECTIONS, b -> this.submit(Arrays.asList("position")));
        this.rotation = new UIIcon(Icons.REFRESH, b -> this.submit(Arrays.asList("rotation")));
        this.posRot = new UIIcon(Icons.FULLSCREEN, b -> this.submit(Arrays.asList("position", "rotation")));
        this.all.tooltip(UIKeys.FILM_GROUPS_ALL);
        this.left.tooltip(UIKeys.FILM_GROUPS_LEFT_STICK);
        this.right.tooltip(UIKeys.FILM_GROUPS_RIGHT_STICK);
        this.triggers.tooltip(UIKeys.FILM_GROUPS_TRIGGERS);
        this.extra1.tooltip(UIKeys.FILM_GROUPS_EXTRA_1);
        this.extra2.tooltip(UIKeys.FILM_GROUPS_EXTRA_2);
        this.position.tooltip(UIKeys.FILM_GROUPS_ONLY_POSITION);
        this.rotation.tooltip(UIKeys.FILM_GROUPS_ONLY_ROTATION);
        this.posRot.tooltip(UIKeys.FILM_GROUPS_ONLY_POS_ROT);
        this.bar = UI.row(this.all, this.left, this.right, this.triggers, this.extra1, this.extra2, this.position, this.rotation, this.posRot);
        this.bar.relative(this.content).x(0.5f).y(1.0f, -6).w(1.0f, -12).anchor(0.5f, 1.0f).row().resize();
        this.content.add((IUIElement)this.bar);
        this.keys().register(Keys.RECORDING_GROUP_ALL, this.all::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_LEFT_STICK, this.left::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_RIGHT_STICK, this.right::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_TRIGGERS, this.triggers::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_EXTRA_1, this.extra1::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_EXTRA_2, this.extra2::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_ONLY_POSITION, this.position::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_ONLY_ROTATION, this.rotation::clickItself);
        this.keys().register(Keys.RECORDING_GROUP_POS_ROT, this.posRot::clickItself);
    }

    public void submit(List<String> groups) {
        this.close();
        if (this.callback != null) {
            this.callback.accept(groups);
        }
    }
}

