/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.utils.undo.ValueChangeUndo;
import mchorse.bbs_mod.utils.Timer;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.undo.CompoundUndo;
import mchorse.bbs_mod.utils.undo.IUndo;
import mchorse.bbs_mod.utils.undo.UndoManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIFilmUndoHandler {
    private UndoManager<ValueGroup> undoManager;
    private Map<BaseValue, BaseType> cachedValues = new HashMap<BaseValue, BaseType>();
    private boolean cacheMarkLastUndoNoMerging;
    private MapType uiData;
    private Timer undoTimer = new Timer(1000L);
    private Timer actionsTimer = new Timer(100L);
    private Set<BaseValue> syncData = new HashSet<BaseValue>();
    private UIFilmPanel panel;

    public UIFilmUndoHandler(UIFilmPanel panel) {
        this.panel = panel;
        this.undoManager = new UndoManager(100);
        this.undoManager.setCallback(this::handleUndos);
    }

    public UndoManager<ValueGroup> getUndoManager() {
        return this.undoManager;
    }

    private void handleUndos(IUndo<ValueGroup> undo, boolean redo) {
        IUndo<ValueGroup> anotherUndo = undo;
        if (anotherUndo instanceof CompoundUndo) {
            anotherUndo = ((CompoundUndo)anotherUndo).getFirst(ValueChangeUndo.class);
        }
        if (anotherUndo instanceof ValueChangeUndo) {
            ValueChangeUndo change = (ValueChangeUndo)anotherUndo;
            this.panel.applyAllUndoData(change.getUIData(redo));
        }
    }

    public void handlePreValues(BaseValue baseValue, int flag) {
        if (this.uiData == null) {
            this.uiData = this.panel.collectAllUndoData();
        }
        if (!this.cachedValues.containsKey(baseValue)) {
            this.cachedValues.put(baseValue, (BaseType)baseValue.toData());
        }
        if ((flag & 1) != 0) {
            this.cacheMarkLastUndoNoMerging = true;
        }
    }

    public void submitUndo() {
        this.handleTimers();
        if (this.cachedValues.isEmpty()) {
            return;
        }
        this.reduceUndoRedundancy();
        ArrayList<ValueChangeUndo> changeUndos = new ArrayList<ValueChangeUndo>();
        for (Map.Entry<BaseValue, BaseType> entry : this.cachedValues.entrySet()) {
            BaseValue value = entry.getKey();
            ValueChangeUndo undo = new ValueChangeUndo(value.getPath(), entry.getValue(), (BaseType)value.toData());
            undo.cacheAfter(this.panel);
            undo.cacheBefore(this.uiData);
            changeUndos.add(undo);
            if (!this.isReplayActions(value)) continue;
            this.syncData.add(value);
            this.actionsTimer.mark();
        }
        if (changeUndos.size() == 1) {
            this.undoManager.pushUndo((IUndo)changeUndos.get(0));
        } else if (!changeUndos.isEmpty()) {
            this.undoManager.pushUndo(new CompoundUndo(changeUndos.toArray(new IUndo[0])));
        }
        this.cachedValues.clear();
        this.uiData = null;
        this.undoTimer.mark();
        if (this.cacheMarkLastUndoNoMerging) {
            this.cacheMarkLastUndoNoMerging = false;
            this.markLastUndoNoMerging();
        }
    }

    private void handleTimers() {
        if (this.undoTimer.checkReset()) {
            this.markLastUndoNoMerging();
        }
        if (this.actionsTimer.checkReset()) {
            for (BaseValue syncData : this.syncData) {
                ClientNetwork.sendSyncData(((Film)this.panel.getData()).getId(), syncData);
            }
            this.syncData.clear();
        }
    }

    private boolean isReplayActions(BaseValue value) {
        String path = value.getPath().toString();
        if (path.endsWith("/replays") || path.endsWith("/keyframes") || path.contains("/keyframes/x") || path.contains("/keyframes/y") || path.contains("/keyframes/z") || path.contains("/keyframes/item_main_hand") || path.contains("/keyframes/item_off_hand") || path.contains("/keyframes/item_head") || path.contains("/keyframes/item_chest") || path.contains("/keyframes/item_legs") || path.contains("/keyframes/item_feet") || path.endsWith("/actor") || path.endsWith("/enabled") || path.endsWith("/form")) {
            return true;
        }
        if (value.getParentValue() != null && value.getParentValue().getId().equals("replays")) {
            return true;
        }
        while (value != null) {
            Clips clips;
            if (value instanceof Clips && (clips = (Clips)value).getFactory() == BBSMod.getFactoryActionClips()) {
                return true;
            }
            value = value.getParentValue();
        }
        return false;
    }

    private void reduceUndoRedundancy() {
        Iterator<BaseValue> it = this.cachedValues.keySet().iterator();
        while (it.hasNext()) {
            boolean remove = false;
            for (BaseValue value = it.next().getParentValue(); value != null; value = value.getParentValue()) {
                if (!this.cachedValues.containsKey(value)) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
    }

    public void markLastUndoNoMerging() {
        IUndo<ValueGroup> undo = this.undoManager.getCurrentUndo();
        if (undo != null) {
            undo.noMerging();
        }
    }
}

