/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.buttons;

import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIClickable;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.framework.elements.utils.ITextColoring;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIButton
extends UIClickable<UIButton>
implements ITextColoring {
    public IKey label;
    public int textColor = -1;
    public boolean textShadow = true;
    public boolean custom;
    public int customColor;
    public boolean background = true;

    public UIButton(IKey label, Consumer<UIButton> callback) {
        super(callback);
        this.label = label;
        this.h(20);
    }

    public UIButton color(int color) {
        this.custom = true;
        this.customColor = color & 0xFFFFFF;
        return this;
    }

    public UIButton textColor(int color, boolean shadow) {
        this.textColor = color;
        this.textShadow = shadow;
        return this;
    }

    public UIButton background(boolean background) {
        this.background = background;
        return this;
    }

    @Override
    public void setColor(int color, boolean shadow) {
        this.textColor = color;
        this.textShadow = shadow;
    }

    @Override
    protected UIButton get() {
        return this;
    }

    @Override
    protected void renderSkin(UIContext context) {
        int color = -16777216 + (this.custom ? this.customColor : (Integer)BBSSettings.primaryColor.get());
        if (this.hover) {
            color = Colors.mulRGB(color, 0.85f);
        }
        if (this.background) {
            this.area.render(context.batcher, color);
        }
        FontRenderer font = context.batcher.getFont();
        String label = font.limitToWidth(this.label.get(), this.area.w - 4);
        int x = this.area.mx(font.getWidth(label));
        int y = this.area.my(font.getHeight());
        context.batcher.text(label, x, y, Colors.mulRGB(this.textColor, this.hover ? 0.9f : 1.0f), this.textShadow);
        this.renderLockedArea(context);
    }
}

