/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input;

import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Axis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3d;

@Environment(value=EnvType.CLIENT)
public abstract class UITransform
extends UIElement {
    public UITrackpad tx;
    public UITrackpad ty;
    public UITrackpad tz;
    public UITrackpad sx;
    public UITrackpad sy;
    public UITrackpad sz;
    public UITrackpad rx;
    public UITrackpad ry;
    public UITrackpad rz;
    public UITrackpad r2x;
    public UITrackpad r2y;
    public UITrackpad r2z;
    protected UIIcon iconT;
    protected UIIcon iconS;
    protected UIIcon iconR;
    protected UIIcon iconR2;
    protected UIElement scaleRow;
    private boolean uniformDrag;
    private boolean uniformScale;

    public UITransform() {
        IKey raw = IKey.constant("%s (%s)");
        this.tx = new UITrackpad(value -> this.internalSetT((double)value, Axis.X)).block().onlyNumbers();
        this.tx.tooltip(raw.format(UIKeys.TRANSFORMS_TRANSLATE, UIKeys.GENERAL_X));
        this.tx.textbox.setColor(0xFF3333);
        this.ty = new UITrackpad(value -> this.internalSetT((double)value, Axis.Y)).block().onlyNumbers();
        this.ty.tooltip(raw.format(UIKeys.TRANSFORMS_TRANSLATE, UIKeys.GENERAL_Y));
        this.ty.textbox.setColor(0x33FF33);
        this.tz = new UITrackpad(value -> this.internalSetT((double)value, Axis.Z)).block().onlyNumbers();
        this.tz.tooltip(raw.format(UIKeys.TRANSFORMS_TRANSLATE, UIKeys.GENERAL_Z));
        this.tz.textbox.setColor(0x3366FF);
        this.sx = new UITrackpad(value -> {
            this.internalSetS((double)value, Axis.X);
            this.syncScale((double)value);
        }).disableCanceling();
        this.sx.onlyNumbers().tooltip(raw.format(UIKeys.TRANSFORMS_SCALE, UIKeys.GENERAL_X));
        this.sx.textbox.setColor(0xFF3333);
        this.sy = new UITrackpad(value -> {
            this.internalSetS((double)value, Axis.Y);
            this.syncScale((double)value);
        }).disableCanceling();
        this.sy.onlyNumbers().tooltip(raw.format(UIKeys.TRANSFORMS_SCALE, UIKeys.GENERAL_Y));
        this.sy.textbox.setColor(0x33FF33);
        this.sz = new UITrackpad(value -> {
            this.internalSetS((double)value, Axis.Z);
            this.syncScale((double)value);
        }).disableCanceling();
        this.sz.onlyNumbers().tooltip(raw.format(UIKeys.TRANSFORMS_SCALE, UIKeys.GENERAL_Z));
        this.sz.textbox.setColor(0x3366FF);
        this.rx = new UITrackpad(value -> this.internalSetR((double)value, Axis.X)).degrees().onlyNumbers();
        this.rx.tooltip(raw.format(UIKeys.TRANSFORMS_ROTATE, UIKeys.GENERAL_X));
        this.rx.textbox.setColor(0xFF3333);
        this.ry = new UITrackpad(value -> this.internalSetR((double)value, Axis.Y)).degrees().onlyNumbers();
        this.ry.tooltip(raw.format(UIKeys.TRANSFORMS_ROTATE, UIKeys.GENERAL_Y));
        this.ry.textbox.setColor(0x33FF33);
        this.rz = new UITrackpad(value -> this.internalSetR((double)value, Axis.Z)).degrees().onlyNumbers();
        this.rz.tooltip(raw.format(UIKeys.TRANSFORMS_ROTATE, UIKeys.GENERAL_Z));
        this.rz.textbox.setColor(0x3366FF);
        this.r2x = new UITrackpad(value -> this.internalSetR2((double)value, Axis.X)).degrees().onlyNumbers();
        this.r2x.tooltip(raw.format(UIKeys.TRANSFORMS_ROTATE2, UIKeys.GENERAL_X));
        this.r2x.textbox.setColor(0xFF3333);
        this.r2y = new UITrackpad(value -> this.internalSetR2((double)value, Axis.Y)).degrees().onlyNumbers();
        this.r2y.tooltip(raw.format(UIKeys.TRANSFORMS_ROTATE2, UIKeys.GENERAL_Y));
        this.r2y.textbox.setColor(0x33FF33);
        this.r2z = new UITrackpad(value -> this.internalSetR2((double)value, Axis.Z)).degrees().onlyNumbers();
        this.r2z.tooltip(raw.format(UIKeys.TRANSFORMS_ROTATE2, UIKeys.GENERAL_Z));
        this.r2z.textbox.setColor(0x3366FF);
        this.w(1.0f).column().stretch().vertical();
        this.iconT = new UIIcon(Icons.ALL_DIRECTIONS, null);
        this.iconS = new UIIcon(Icons.SCALE, b -> this.toggleUniformScale());
        this.iconS.tooltip(UIKeys.TRANSFORMS_UNIFORM_SCALE);
        this.iconR = new UIIcon(Icons.REFRESH, null);
        this.iconR2 = new UIIcon(Icons.REFRESH, null);
        this.iconR2.disabledColor = -1;
        this.iconR.disabledColor = -1;
        this.iconS.disabledColor = -1;
        this.iconT.disabledColor = -1;
        this.iconR2.hoverColor = -1;
        this.iconR.hoverColor = -1;
        this.iconS.hoverColor = -1;
        this.iconT.hoverColor = -1;
        this.iconT.setEnabled(false);
        this.iconR.setEnabled(false);
        this.iconR2.setEnabled(false);
        this.add((IUIElement)UI.row(this.iconT, this.tx, this.ty, this.tz));
        this.scaleRow = UI.row(this.iconS, this.sx, this.sy, this.sz);
        this.add((IUIElement)this.scaleRow);
        this.add((IUIElement)UI.row(this.iconR, this.rx, this.ry, this.rz));
        this.add((IUIElement)UI.row(this.iconR2, this.r2x, this.r2y, this.r2z));
        this.context((ContextMenuManager menu) -> {
            ListType transforms = Window.getClipboardList();
            if (transforms != null && transforms.size() < 9) {
                transforms = null;
            }
            menu.autoKeys().action(Icons.COPY, UIKeys.TRANSFORMS_CONTEXT_COPY, this::copyTransformations);
            if (transforms != null) {
                ListType innerList = transforms;
                menu.action(Icons.PASTE, UIKeys.TRANSFORMS_CONTEXT_PASTE, () -> this.pasteAll(innerList));
                menu.action(Icons.ALL_DIRECTIONS, UIKeys.TRANSFORMS_CONTEXT_PASTE_TRANSLATION, () -> this.pasteTranslation(this.getVector(innerList, 0)));
                menu.action(Icons.MAXIMIZE, UIKeys.TRANSFORMS_CONTEXT_PASTE_SCALE, () -> this.pasteScale(this.getVector(innerList, 3)));
                menu.action(Icons.REFRESH, UIKeys.TRANSFORMS_CONTEXT_PASTE_ROTATION, () -> this.pasteRotation(this.getVector(innerList, 6)));
            }
            menu.action(Icons.CLOSE, UIKeys.TRANSFORMS_CONTEXT_RESET, this::reset);
        });
        this.wh(190, 70);
        this.keys().register(Keys.COPY, this::copyTransformations).inside().label(UIKeys.TRANSFORMS_CONTEXT_COPY);
        this.keys().register(Keys.PASTE, () -> {
            ListType transforms = Window.getClipboardList();
            if (transforms != null && transforms.size() < 9) {
                transforms = null;
            }
            if (transforms != null) {
                this.pasteAll(transforms);
            }
        }).inside().label(UIKeys.TRANSFORMS_CONTEXT_PASTE);
    }

    protected void toggleUniformScale() {
        this.uniformScale = !this.uniformScale;
        this.scaleRow.removeAll();
        if (this.uniformScale) {
            this.scaleRow.add(this.iconS, this.sx);
        } else {
            this.scaleRow.add(this.iconS, this.sx, this.sy, this.sz);
        }
        UIElement parentContainer = this.getParentContainer();
        if (parentContainer != null) {
            parentContainer.resize();
        }
    }

    protected boolean isUniformScale() {
        return this.uniformDrag || Window.isKeyPressed(32);
    }

    private void syncScale(double value) {
        if (this.isUniformScale()) {
            this.fillS(value, value, value);
            this.setS(null, value, value, value);
        }
    }

    public void fillSetT(double x, double y, double z) {
        this.fillT(x, y, z);
        this.setT(null, x, y, z);
    }

    public void fillSetS(double x, double y, double z) {
        this.fillS(x, y, z);
        this.setS(null, x, y, z);
    }

    public void fillSetR(double x, double y, double z) {
        this.fillR(x, y, z);
        this.setR(null, x, y, z);
    }

    public void fillSetR2(double x, double y, double z) {
        this.fillR2(x, y, z);
        this.setR2(null, x, y, z);
    }

    public void fillT(double x, double y, double z) {
        this.tx.setValue(x);
        this.ty.setValue(y);
        this.tz.setValue(z);
    }

    public void fillS(double x, double y, double z) {
        this.sx.setValue(x);
        this.sy.setValue(y);
        this.sz.setValue(z);
    }

    public void fillR(double x, double y, double z) {
        this.rx.setValue(x);
        this.ry.setValue(y);
        this.rz.setValue(z);
    }

    public void fillR2(double x, double y, double z) {
        this.r2x.setValue(x);
        this.r2y.setValue(y);
        this.r2z.setValue(z);
    }

    protected void internalSetT(double x, Axis axis) {
        try {
            this.setT(axis, axis == Axis.X ? x : this.tx.value, axis == Axis.Y ? x : this.ty.value, axis == Axis.Z ? x : this.tz.value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void internalSetS(double x, Axis axis) {
        try {
            if (this.uniformScale && axis == Axis.X) {
                this.setS(axis, x, x, x);
                this.sy.setValue(x);
                this.sz.setValue(x);
                return;
            }
            this.setS(axis, axis == Axis.X ? x : this.sx.value, axis == Axis.Y ? x : this.sy.value, axis == Axis.Z ? x : this.sz.value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void internalSetR(double x, Axis axis) {
        try {
            this.setR(axis, axis == Axis.X ? x : this.rx.value, axis == Axis.Y ? x : this.ry.value, axis == Axis.Z ? x : this.rz.value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void internalSetR2(double x, Axis axis) {
        try {
            this.setR2(axis, axis == Axis.X ? x : this.r2x.value, axis == Axis.Y ? x : this.r2y.value, axis == Axis.Z ? x : this.r2z.value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void setT(Axis var1, double var2, double var4, double var6);

    public abstract void setS(Axis var1, double var2, double var4, double var6);

    public abstract void setR(Axis var1, double var2, double var4, double var6);

    public abstract void setR2(Axis var1, double var2, double var4, double var6);

    private void copyTransformations() {
        ListType list = new ListType();
        list.addDouble(this.tx.value);
        list.addDouble(this.ty.value);
        list.addDouble(this.tz.value);
        list.addDouble(this.sx.value);
        list.addDouble(this.sy.value);
        list.addDouble(this.sz.value);
        list.addDouble(this.rx.value);
        list.addDouble(this.ry.value);
        list.addDouble(this.rz.value);
        list.addDouble(this.r2x.value);
        list.addDouble(this.r2y.value);
        list.addDouble(this.r2z.value);
        Window.setClipboard(list);
    }

    public void pasteAll(ListType list) {
        this.pasteTranslation(this.getVector(list, 0));
        this.pasteScale(this.getVector(list, 3));
        this.pasteRotation(this.getVector(list, 6));
        this.pasteRotation2(this.getVector(list, 9));
    }

    public void pasteTranslation(Vector3d translation) {
        this.tx.setValue(translation.x);
        this.ty.setValue(translation.y);
        this.tz.setValueAndNotify(translation.z);
    }

    public void pasteScale(Vector3d scale) {
        this.sz.setValue(scale.z);
        this.sy.setValue(scale.y);
        this.sx.setValueAndNotify(scale.x);
    }

    public void pasteRotation(Vector3d rotation) {
        this.rx.setValue(rotation.x);
        this.ry.setValue(rotation.y);
        this.rz.setValueAndNotify(rotation.z);
    }

    public void pasteRotation2(Vector3d rotation) {
        this.r2x.setValue(rotation.x);
        this.r2y.setValue(rotation.y);
        this.r2z.setValueAndNotify(rotation.z);
    }

    private Vector3d getVector(ListType list, int offset) {
        Vector3d result = new Vector3d();
        if (list.get(offset).isNumeric() && list.get(offset + 1).isNumeric() && list.get(offset + 2).isNumeric()) {
            result.x = list.get(offset).asNumeric().doubleValue();
            result.y = list.get(offset + 1).asNumeric().doubleValue();
            result.z = list.get(offset + 2).asNumeric().doubleValue();
        }
        if (offset == 0) {
            result.x = result.x * (Window.isShiftPressed() ? -1.0 : 1.0);
        }
        if (offset >= 6) {
            result.y = result.y * (Window.isShiftPressed() ? -1.0 : 1.0);
            result.z = result.z * (Window.isShiftPressed() ? -1.0 : 1.0);
        }
        return result;
    }

    protected void reset() {
        this.fillSetT(0.0, 0.0, 0.0);
        this.fillSetS(1.0, 1.0, 1.0);
        this.fillSetR(0.0, 0.0, 0.0);
        this.fillSetR2(0.0, 0.0, 0.0);
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        if ((this.sx.area.isInside(context) || this.sy.area.isInside(context) || this.sz.area.isInside(context)) && context.mouseButton == 1 && (this.sx.isDragging() || this.sy.isDragging() || this.sz.isDragging())) {
            this.uniformDrag = true;
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    protected boolean subMouseReleased(UIContext context) {
        if (context.mouseButton == 1) {
            this.uniformDrag = false;
        }
        return super.subMouseReleased(context);
    }

    @Override
    protected boolean subKeyPressed(UIContext context) {
        if ((this.sx.isDragging() || this.sy.isDragging() || this.sz.isDragging()) && context.isHeld(32)) {
            return true;
        }
        return super.subKeyPressed(context);
    }
}

