/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class KeyframeSelection {
    private static final List<Integer> tmpIndices = new ArrayList<Integer>();
    private KeyframeChannel channel;
    private Set<Integer> selected = new LinkedHashSet<Integer>();
    private List<Keyframe> tmp = new ArrayList<Keyframe>();

    public KeyframeSelection(KeyframeChannel channel) {
        this.channel = channel;
    }

    public boolean hasAny() {
        return !this.selected.isEmpty();
    }

    public boolean has(int index) {
        return this.selected.contains(index);
    }

    public boolean has(Keyframe keyframe) {
        return this.selected.contains(this.channel.getKeyframes().indexOf(keyframe));
    }

    public void all() {
        this.selected.clear();
        int c = this.channel.getKeyframes().size();
        for (int i = 0; i < c; ++i) {
            this.selected.add(i);
        }
    }

    public void after(float tick, int direction) {
        this.selected.clear();
        List keyframes = this.channel.getKeyframes();
        if (direction < 0) {
            for (int i = 0; i < keyframes.size(); ++i) {
                Keyframe keyframe = keyframes.get(i);
                if (keyframe.getTick() > tick) {
                    return;
                }
                this.selected.add(i);
            }
        } else {
            for (int i = keyframes.size() - 1; i >= 0; --i) {
                Keyframe keyframe = keyframes.get(i);
                if (keyframe.getTick() < tick) {
                    return;
                }
                this.selected.add(i);
            }
        }
    }

    public void clear() {
        this.selected.clear();
    }

    public void add(int i) {
        this.selected.add(i);
    }

    public void add(Keyframe keyframe) {
        int index = this.channel.getKeyframes().indexOf(keyframe);
        if (index >= 0) {
            this.add(index);
        }
    }

    public void addAll(Collection<Integer> selected) {
        this.selected.addAll(selected);
    }

    public void remove(int index) {
        this.selected.remove(index);
    }

    public void removeSelected() {
        tmpIndices.clear();
        tmpIndices.addAll(this.selected);
        tmpIndices.sort(Comparator.reverseOrder());
        for (Integer index : tmpIndices) {
            this.channel.remove(index);
        }
        this.selected.clear();
    }

    public Keyframe getFirst() {
        Iterator<Integer> iterator = this.selected.iterator();
        if (iterator.hasNext()) {
            Integer integer = iterator.next();
            return this.channel.get(integer);
        }
        return null;
    }

    public List<Keyframe> getSelected() {
        this.tmp.clear();
        for (Integer index : this.selected) {
            Keyframe keyframe = this.channel.get(index);
            if (keyframe == null) continue;
            this.tmp.add(keyframe);
        }
        return this.tmp;
    }

    public Collection<Integer> getIndices() {
        return Collections.unmodifiableSet(this.selected);
    }
}

