/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.MobForm;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.pose.UIPoseEditor;
import mchorse.bbs_mod.utils.Axis;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.joml.Vectors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.pose.PoseTransform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class UIPoseKeyframeFactory
extends UIKeyframeFactory<Pose> {
    public UIPoseFactoryEditor poseEditor;

    public UIPoseKeyframeFactory(Keyframe<Pose> keyframe, UIKeyframes editor) {
        super(keyframe, editor);
        this.poseEditor = new UIPoseFactoryEditor(editor, keyframe);
        UIKeyframeSheet sheet = editor.getGraph().getSheet(keyframe);
        Form form = FormUtils.getForm(sheet.property);
        if (form instanceof ModelForm) {
            ModelForm modelForm = (ModelForm)form;
            model = ((ModelFormRenderer)FormUtilsClient.getRenderer(modelForm)).getModel();
            if (model != null) {
                this.poseEditor.setPose(keyframe.getValue(), ((ModelInstance)model).poseGroup);
                this.poseEditor.fillGroups(((ModelInstance)model).model, ((ModelInstance)model).flippedParts, false);
            }
        } else {
            model = FormUtils.getForm(sheet.property);
            if (model instanceof MobForm) {
                MobForm mobForm = (MobForm)model;
                List<String> bones = FormUtilsClient.getRenderer(mobForm).getBones();
                this.poseEditor.setPose(keyframe.getValue(), "");
                this.poseEditor.fillGroups(bones, false);
            }
        }
        this.scroll.add((IUIElement)this.poseEditor);
    }

    @Override
    public void resize() {
        this.poseEditor.removeAll();
        if (this.getFlex().getW() > 240) {
            this.poseEditor.add((IUIElement)UI.row(UI.column(UI.label(UIKeys.POSE_CONTEXT_FIX), this.poseEditor.fix, UI.row(this.poseEditor.color, this.poseEditor.lighting), this.poseEditor.transform), UI.column(UI.label(UIKeys.FORMS_EDITOR_BONE), this.poseEditor.groups)));
        } else {
            this.poseEditor.add(UI.label(UIKeys.FORMS_EDITOR_BONE), this.poseEditor.groups, UI.label(UIKeys.POSE_CONTEXT_FIX), this.poseEditor.fix, UI.row(this.poseEditor.color, this.poseEditor.lighting), this.poseEditor.transform);
        }
        for (UIElement child : this.scroll.getChildren(UIElement.class)) {
            child.noCulling();
        }
        super.resize();
    }

    @Environment(value=EnvType.CLIENT)
    public static class UIPoseFactoryEditor
    extends UIPoseEditor {
        private UIKeyframes editor;
        private Keyframe<Pose> keyframe;

        public static void apply(UIKeyframes editor, Keyframe keyframe, Consumer<Pose> consumer) {
            for (UIKeyframeSheet sheet : editor.getGraph().getSheets()) {
                if (sheet.channel.getFactory() != keyframe.getFactory()) continue;
                for (Keyframe kf : sheet.selection.getSelected()) {
                    Object t = kf.getValue();
                    if (!(t instanceof Pose)) continue;
                    Pose pose = (Pose)t;
                    kf.preNotify();
                    consumer.accept(pose);
                    kf.postNotify();
                }
            }
        }

        public static void apply(UIKeyframes editor, Keyframe keyframe, String group, Consumer<PoseTransform> consumer) {
            UIPoseFactoryEditor.apply(editor, keyframe, pose -> consumer.accept(pose.get(group)));
        }

        public UIPoseFactoryEditor(UIKeyframes editor, Keyframe<Pose> keyframe) {
            this.editor = editor;
            this.keyframe = keyframe;
            ((UIPoseTransforms)this.transform).setKeyframe(this);
        }

        private String getGroup(PoseTransform transform) {
            return CollectionUtils.getKey(this.getPose().transforms, transform);
        }

        @Override
        protected UIPropTransform createTransformEditor() {
            return new UIPoseTransforms().enableHotkeys();
        }

        @Override
        protected void pastePose(MapType data) {
            String current = (String)this.groups.getCurrentFirst();
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, pose -> pose.fromData(data));
            this.pickBone(current);
        }

        @Override
        protected void flipPose() {
            String current = (String)this.groups.getCurrentFirst();
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, pose -> pose.flip(this.flippedParts));
            this.pickBone(current);
        }

        @Override
        protected void changedPose(Runnable runnable) {
            BaseValue.edit(this.keyframe, kf -> runnable.run());
        }

        @Override
        protected void setFix(PoseTransform transform, float value) {
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, this.getGroup(transform), poseT -> {
                poseT.fix = value;
            });
        }

        @Override
        protected void setColor(PoseTransform transform, int value) {
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, this.getGroup(transform), poseT -> poseT.color.set(value));
        }

        @Override
        protected void setLighting(PoseTransform poseTransform, boolean value) {
            UIPoseFactoryEditor.apply(this.editor, this.keyframe, this.getGroup(poseTransform), poseT -> {
                poseT.lighting = value ? 0.0f : 1.0f;
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class UIPoseTransforms
    extends UIPropTransform {
        private UIPoseFactoryEditor editor;

        public void setKeyframe(UIPoseFactoryEditor editor) {
            this.editor = editor;
        }

        @Override
        protected void reset() {
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> {
                poseT.translate.set(0.0f, 0.0f, 0.0f);
                poseT.scale.set(1.0f, 1.0f, 1.0f);
                poseT.rotate.set(0.0f, 0.0f, 0.0f);
                poseT.rotate2.set(0.0f, 0.0f, 0.0f);
            });
            this.setTransform(this.getTransform());
        }

        @Override
        public void pasteTranslation(Vector3d translation) {
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> poseT.translate.set((Vector3dc)translation));
            this.setTransform(this.getTransform());
        }

        @Override
        public void pasteScale(Vector3d scale) {
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> poseT.scale.set((Vector3dc)scale));
            this.setTransform(this.getTransform());
        }

        @Override
        public void pasteRotation(Vector3d rotation) {
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> poseT.rotate.set((Vector3dc)Vectors.toRad(rotation)));
            this.setTransform(this.getTransform());
        }

        @Override
        public void pasteRotation2(Vector3d rotation) {
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> poseT.rotate2.set((Vector3dc)Vectors.toRad(rotation)));
            this.setTransform(this.getTransform());
        }

        @Override
        public void setT(Axis axis, double x, double y, double z) {
            float dx = (float)(x - (double)this.getTransform().translate.x);
            float dy = (float)(y - (double)this.getTransform().translate.y);
            float dz = (float)(z - (double)this.getTransform().translate.z);
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> {
                poseT.translate.x += dx;
                poseT.translate.y += dy;
                poseT.translate.z += dz;
            });
        }

        @Override
        public void setS(Axis axis, double x, double y, double z) {
            float dx = (float)(x - (double)this.getTransform().scale.x);
            float dy = (float)(y - (double)this.getTransform().scale.y);
            float dz = (float)(z - (double)this.getTransform().scale.z);
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> {
                poseT.scale.x += dx;
                poseT.scale.y += dy;
                poseT.scale.z += dz;
            });
        }

        @Override
        public void setR(Axis axis, double x, double y, double z) {
            float dx = MathUtils.toRad((float)x) - this.getTransform().rotate.x;
            float dy = MathUtils.toRad((float)y) - this.getTransform().rotate.y;
            float dz = MathUtils.toRad((float)z) - this.getTransform().rotate.z;
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> {
                poseT.rotate.x += dx;
                poseT.rotate.y += dy;
                poseT.rotate.z += dz;
            });
        }

        @Override
        public void setR2(Axis axis, double x, double y, double z) {
            float dx = MathUtils.toRad((float)x) - this.getTransform().rotate2.x;
            float dy = MathUtils.toRad((float)y) - this.getTransform().rotate2.y;
            float dz = MathUtils.toRad((float)z) - this.getTransform().rotate2.z;
            UIPoseFactoryEditor.apply(this.editor.editor, this.editor.keyframe, this.editor.getGroup(), poseT -> {
                poseT.rotate2.x += dx;
                poseT.rotate2.y += dy;
                poseT.rotate2.z += dz;
            });
        }
    }
}

