/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import java.util.function.Consumer;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.utils.Axis;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.joml.Vectors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Environment(value=EnvType.CLIENT)
public class UITransformKeyframeFactory
extends UIKeyframeFactory<Transform> {
    private UIPropTransform transform = new UIPoseTransforms(this);

    public UITransformKeyframeFactory(Keyframe<Transform> keyframe, UIKeyframes editor) {
        super(keyframe, editor);
        this.transform.enableHotkeys();
        this.transform.setTransform(keyframe.getValue());
        this.scroll.add((IUIElement)this.transform);
    }

    @Environment(value=EnvType.CLIENT)
    public static class UIPoseTransforms
    extends UIPropTransform {
        private UITransformKeyframeFactory editor;

        public UIPoseTransforms(UITransformKeyframeFactory editor) {
            this.editor = editor;
        }

        public static void apply(UIKeyframes editor, Keyframe keyframe, Consumer<Transform> consumer) {
            for (UIKeyframeSheet sheet : editor.getGraph().getSheets()) {
                if (sheet.channel.getFactory() != keyframe.getFactory()) continue;
                for (Keyframe kf : sheet.selection.getSelected()) {
                    Object t = kf.getValue();
                    if (!(t instanceof Transform)) continue;
                    Transform transform = (Transform)t;
                    kf.preNotify();
                    consumer.accept(transform);
                    kf.postNotify();
                }
            }
        }

        @Override
        public void pasteTranslation(Vector3d translation) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.translate.set((Vector3dc)translation));
            this.setTransform(this.getTransform());
        }

        @Override
        public void pasteScale(Vector3d scale) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.scale.set((Vector3dc)scale));
            this.setTransform(this.getTransform());
        }

        @Override
        public void pasteRotation(Vector3d rotation) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.rotate.set((Vector3dc)Vectors.toRad(rotation)));
            this.setTransform(this.getTransform());
        }

        @Override
        public void pasteRotation2(Vector3d rotation) {
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> poseT.rotate2.set((Vector3dc)Vectors.toRad(rotation)));
            this.setTransform(this.getTransform());
        }

        @Override
        public void setT(Axis axis, double x, double y, double z) {
            float dx = (float)(x - (double)this.getTransform().translate.x);
            float dy = (float)(y - (double)this.getTransform().translate.y);
            float dz = (float)(z - (double)this.getTransform().translate.z);
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.translate.x += dx;
                poseT.translate.y += dy;
                poseT.translate.z += dz;
            });
        }

        @Override
        public void setS(Axis axis, double x, double y, double z) {
            float dx = (float)(x - (double)this.getTransform().scale.x);
            float dy = (float)(y - (double)this.getTransform().scale.y);
            float dz = (float)(z - (double)this.getTransform().scale.z);
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.scale.x += dx;
                poseT.scale.y += dy;
                poseT.scale.z += dz;
            });
        }

        @Override
        public void setR(Axis axis, double x, double y, double z) {
            float dx = MathUtils.toRad((float)x) - this.getTransform().rotate.x;
            float dy = MathUtils.toRad((float)y) - this.getTransform().rotate.y;
            float dz = MathUtils.toRad((float)z) - this.getTransform().rotate.z;
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.rotate.x += dx;
                poseT.rotate.y += dy;
                poseT.rotate.z += dz;
            });
        }

        @Override
        public void setR2(Axis axis, double x, double y, double z) {
            float dx = MathUtils.toRad((float)x) - this.getTransform().rotate2.x;
            float dy = MathUtils.toRad((float)y) - this.getTransform().rotate2.y;
            float dz = MathUtils.toRad((float)z) - this.getTransform().rotate2.z;
            UIPoseTransforms.apply(this.editor.editor, this.editor.keyframe, poseT -> {
                poseT.rotate2.x += dx;
                poseT.rotate2.y += dy;
                poseT.rotate2.z += dz;
            });
        }
    }
}

