/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs;

import java.util.List;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs.KeyframeType;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.interps.Interpolation;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public interface IUIKeyframeGraph {
    public static final int TOP_MARGIN = 25;

    public void resetView();

    public List<UIKeyframeSheet> getSheets();

    default public void clearSelection() {
        for (UIKeyframeSheet sheet : this.getSheets()) {
            sheet.selection.clear();
        }
    }

    default public void selectAll() {
        for (UIKeyframeSheet sheet : this.getSheets()) {
            sheet.selection.all();
        }
        this.pickSelected();
    }

    default public void selectAfter(float tick, int direction) {
        for (UIKeyframeSheet sheet : this.getSheets()) {
            sheet.selection.after(tick, direction);
        }
        this.pickSelected();
    }

    public void selectByX(int var1);

    public void selectInArea(Area var1);

    default public Keyframe getSelected() {
        for (UIKeyframeSheet sheet : this.getSheets()) {
            Keyframe first = sheet.selection.getFirst();
            if (first == null) continue;
            return first;
        }
        return null;
    }

    default public UIKeyframeSheet getSheet(Keyframe keyframe) {
        KeyframeChannel channel = (KeyframeChannel)keyframe.getParentValue();
        for (UIKeyframeSheet sheet : this.getSheets()) {
            if (sheet.channel != channel) continue;
            return sheet;
        }
        return null;
    }

    public UIKeyframeSheet getSheet(int var1);

    public boolean addKeyframe(int var1, int var2);

    default public Keyframe addKeyframe(UIKeyframeSheet sheet, float tick, Object value) {
        KeyframeSegment segment = sheet.channel.find(tick);
        Interpolation interpolation = null;
        BaseValueBasic property = sheet.property;
        if (value == null) {
            if (segment != null) {
                value = segment.createInterpolated();
                interpolation = segment.a.getInterpolation();
            } else {
                value = property != null ? sheet.channel.getFactory().copy(property.get()) : sheet.channel.getFactory().createEmpty();
            }
        }
        int index = sheet.channel.insert(tick, value);
        Keyframe keyframe = sheet.channel.get(index);
        if (interpolation != null) {
            keyframe.getInterpolation().copy(interpolation);
        }
        this.clearSelection();
        this.pickKeyframe(keyframe);
        sheet.selection.add(index);
        return keyframe;
    }

    default public void removeKeyframe(Keyframe keyframe) {
        UIKeyframeSheet sheet = this.getSheet(keyframe);
        sheet.remove(keyframe);
        this.clearSelection();
        this.pickKeyframe(null);
    }

    default public void removeSelected() {
        for (UIKeyframeSheet sheet : this.getSheets()) {
            sheet.selection.removeSelected();
        }
        this.pickKeyframe(null);
    }

    public Pair<Keyframe, KeyframeType> findKeyframe(int var1, int var2);

    default public void pickSelected() {
        this.pickKeyframe(this.getSelected());
    }

    public void pickKeyframe(Keyframe var1);

    public void selectKeyframe(Keyframe var1);

    default public void setTick(float tick, boolean dirty) {
        Keyframe selected = this.getSelected();
        float diff = tick - selected.getTick();
        for (UIKeyframeSheet sheet : this.getSheets()) {
            sheet.setTickBy(diff, dirty);
        }
    }

    default public void setDuration(float duration) {
        for (UIKeyframeSheet sheet : this.getSheets()) {
            sheet.setDuration(duration);
        }
    }

    default public void setInterpolation(Interpolation interpolation) {
        for (UIKeyframeSheet sheet : this.getSheets()) {
            sheet.setInterpolation(interpolation);
        }
    }

    default public void setValue(Object value, boolean unmergeable) {
        Keyframe selected = this.getSelected();
        IKeyframeFactory factory = selected.getFactory();
        Object keyframe = factory.copy(selected.getValue());
        for (UIKeyframeSheet sheet : this.getSheets()) {
            if (sheet.channel.getFactory() != factory) continue;
            sheet.setValue(value, keyframe, unmergeable);
        }
    }

    public void resize();

    public boolean mouseClicked(UIContext var1);

    public void mouseReleased(UIContext var1);

    public void mouseScrolled(UIContext var1);

    public void handleMouse(UIContext var1, int var2, int var3);

    public void dragKeyframes(UIContext var1, Pair<Keyframe, KeyframeType> var2, int var3, int var4, float var5, Object var6);

    public void render(UIContext var1);

    public void postRender(UIContext var1);

    public void saveState(MapType var1);

    public void restoreState(MapType var1);
}

