/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextarea;
import mchorse.bbs_mod.ui.framework.elements.input.text.highlighting.HighlightedTextLine;
import mchorse.bbs_mod.ui.framework.elements.input.text.highlighting.ISyntaxHighlighter;
import mchorse.bbs_mod.ui.framework.elements.input.text.highlighting.JSSyntaxHighlighter;
import mchorse.bbs_mod.ui.framework.elements.input.text.highlighting.SyntaxStyle;
import mchorse.bbs_mod.ui.framework.elements.input.text.highlighting.TextLineNumber;
import mchorse.bbs_mod.ui.framework.elements.input.text.highlighting.TextSegment;
import mchorse.bbs_mod.ui.framework.elements.input.text.undo.TextEditUndo;
import mchorse.bbs_mod.ui.framework.elements.input.text.utils.Cursor;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UITextEditor
extends UITextarea<HighlightedTextLine> {
    private ISyntaxHighlighter highlighter;
    private int placements;
    private boolean lines = true;
    private List<TextLineNumber> numbers = new ArrayList<TextLineNumber>(40);
    private int lineNumber = 0;

    public UITextEditor(Consumer<String> callback) {
        super(callback);
        this.highlighter = new JSSyntaxHighlighter();
    }

    public UITextEditor highlighter(ISyntaxHighlighter highlighter) {
        this.highlighter = highlighter;
        return this;
    }

    @Override
    protected HighlightedTextLine createTextLine(String line) {
        return new HighlightedTextLine(line);
    }

    public UITextEditor noLineNumbers() {
        this.lines = false;
        return this;
    }

    public ISyntaxHighlighter getHighlighter() {
        return this.highlighter;
    }

    public void resetHighlight() {
        for (HighlightedTextLine textLine : this.text) {
            textLine.resetSegments();
        }
    }

    public void updateHighlighter() {
        SyntaxStyle style = new SyntaxStyle();
        if (this.highlighter.getStyle() != style) {
            this.highlighter.setStyle(style);
            this.resetHighlight();
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.resetHighlight();
    }

    @Override
    protected void recalculateSizes() {
        double power = Math.ceil(Math.log10(this.text.size() + 1));
        this.placements = (int)power * 6;
        super.recalculateSizes();
    }

    @Override
    protected void changedLine(int i) {
        String line = ((HighlightedTextLine)this.text.get((int)i)).text;
        if (line.contains("/*") || line.contains("*/")) {
            this.changedLineAfter(i);
        } else {
            super.changedLine(i);
            ((HighlightedTextLine)this.text.get(i)).resetSegments();
        }
    }

    @Override
    protected void changedLineAfter(int i) {
        super.changedLineAfter(i);
        while (i < this.text.size()) {
            ((HighlightedTextLine)this.text.get(i)).resetSegments();
            ++i;
        }
    }

    @Override
    protected String getFromChar(char typedChar) {
        if (this.wasDoubleInsert(typedChar, ')', '(') || this.wasDoubleInsert(typedChar, ']', '[') || this.wasDoubleInsert(typedChar, '}', '{') || this.wasDoubleInsert(typedChar, '\"', '\"') || this.wasDoubleInsert(typedChar, '\'', '\'')) {
            this.moveCursor(1, 0);
            this.playSound("insert");
            return "";
        }
        if (typedChar == '(') {
            return "()";
        }
        if (typedChar == '[') {
            return "[]";
        }
        if (typedChar == '{') {
            return "{}";
        }
        if (typedChar == '\"') {
            return "\"\"";
        }
        if (typedChar == '\'') {
            return "''";
        }
        return super.getFromChar(typedChar);
    }

    private boolean wasDoubleInsert(char input, char target, char supplementary) {
        if (input != target) {
            return false;
        }
        String line = ((HighlightedTextLine)this.text.get((int)this.cursor.line)).text;
        return line.length() >= 2 && this.cursor.offset > 0 && this.cursor.offset < line.length() && line.charAt(this.cursor.offset) == target && line.charAt(this.cursor.offset - 1) == supplementary;
    }

    @Override
    protected void keyNewLine(TextEditUndo undo) {
        String line = ((HighlightedTextLine)this.text.get((int)this.cursor.line)).text;
        boolean unwrap = line.length() >= 2 && this.cursor.offset > 0 && this.cursor.offset < line.length() && line.charAt(this.cursor.offset) == '}' && line.charAt(this.cursor.offset - 1) == '{';
        int indent = this.getIndent(line) + (unwrap ? 4 : 0);
        super.keyNewLine(undo);
        String margin = this.createIndent(indent);
        this.writeString(margin);
        this.cursor.offset = indent;
        undo.postText = undo.postText + margin;
        if (unwrap) {
            super.keyNewLine(undo);
            margin = this.createIndent(indent - 4);
            this.writeString(margin);
            --this.cursor.line;
            this.cursor.offset = indent;
            undo.postText = undo.postText + margin;
        }
    }

    @Override
    protected void keyBackspace(TextEditUndo undo, boolean ctrl) {
        String line = ((HighlightedTextLine)this.text.get((int)this.cursor.line)).text;
        if (!(line = this.cursor.start(line)).isEmpty() && line.trim().isEmpty()) {
            int offset = 4 - line.length() % 4;
            this.startSelecting();
            this.cursor.offset -= offset;
            String deleted = this.getSelectedText();
            this.deleteSelection();
            this.deselect();
            undo.text = deleted;
        } else {
            super.keyBackspace(undo, ctrl);
        }
    }

    @Override
    protected void keyTab(boolean shift, TextEditUndo undo) {
        if (this.isSelected()) {
            Cursor min = this.getMin();
            if (shift) {
                min.offset = Math.max(min.offset - 4, 0);
            }
            Cursor temp = new Cursor();
            List<String> splits = UITextEditor.splitNewlineString(this.getSelectedText());
            for (int i = 0; i < splits.size(); ++i) {
                if (shift) {
                    int indent = this.getIndent(splits.get(i));
                    splits.set(i, splits.get(i).substring(Math.min(indent, 4)));
                    continue;
                }
                splits.set(i, "    " + splits.get(i));
            }
            String result = String.join((CharSequence)"\n", splits);
            temp.copy(min);
            this.deleteSelection();
            this.writeString(result);
            this.getMin().set(min.line, splits.get(splits.size() - 1).length());
            min.copy(temp);
            if (!shift) {
                min.offset += 4;
            }
            undo.postText = result;
        } else {
            undo.postText = "    ";
            this.deleteSelection();
            this.deselect();
            this.writeString(undo.postText);
        }
    }

    public int getIndent(int i) {
        if (this.hasLine(i)) {
            return this.getIndent(((HighlightedTextLine)this.text.get((int)i)).text);
        }
        return 0;
    }

    public int getIndent(String line) {
        for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c == ' ') continue;
            return j;
        }
        return line.length();
    }

    public String createIndent(int i) {
        StringBuilder builder = new StringBuilder();
        while (i > 0) {
            builder.append(' ');
            --i;
        }
        return builder.toString();
    }

    @Override
    protected void renderTextLine(UIContext context, String line, int i, int j, int nx, int ny) {
        FontRenderer font = context.batcher.getFont();
        if (this.lines && j == 0) {
            String label = String.valueOf(i + 1);
            int x = this.area.x + 5 + this.placements - font.getWidth(label);
            if (this.lineNumber >= this.numbers.size()) {
                this.numbers.add(new TextLineNumber());
            }
            this.numbers.get(this.lineNumber).set(label, x, ny);
            ++this.lineNumber;
        }
        HighlightedTextLine textLine = (HighlightedTextLine)this.text.get(i);
        if (textLine.segments == null) {
            textLine.setSegments(this.highlighter.parse(font, this.text, textLine.text, i));
            if (textLine.wrappedLines != null) {
                textLine.calculateWrappedSegments(font);
            }
        }
        List<TextSegment> segments = textLine.segments;
        if (textLine.wrappedSegments != null) {
            List<TextSegment> list = segments = j < textLine.wrappedSegments.size() ? textLine.wrappedSegments.get(j) : null;
        }
        if (segments != null) {
            boolean shadow = this.highlighter.getStyle().shadow;
            for (TextSegment segment : segments) {
                context.batcher.text(segment.text, nx, ny, segment.color, shadow);
                nx += segment.width;
            }
        }
    }

    @Override
    protected int getShiftX() {
        return this.lines ? 10 + this.placements - 1 : 0;
    }

    @Override
    protected void renderBackground(UIContext context) {
        this.area.render(context.batcher, 0xFF000000 | Colors.mulRGB(this.highlighter.getStyle().background, 0.8f));
    }

    @Override
    protected void renderForeground(FontRenderer font, UIContext context) {
        if (this.lines) {
            int x = this.area.x + this.getShiftX();
            context.batcher.box(this.area.x, this.area.y, x, this.area.ey(), 0xFF000000 | this.highlighter.getStyle().background);
            for (TextLineNumber number : this.numbers) {
                if (!number.render) break;
                context.batcher.text(number.line, number.x, number.y, this.highlighter.getStyle().lineNumbers);
                number.render = false;
            }
            this.lineNumber = 0;
            float a = Math.min((float)((int)this.horizontal.getScroll()) / 10.0f, 1.0f) * 0.25f;
            if (a > 0.0f) {
                context.batcher.gradientHBox(x, this.area.y, x + 10, this.area.ey(), Colors.a(a), 0);
            }
        }
    }
}

