/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.tooltips;

import java.util.function.Supplier;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.tooltips.ITooltip;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.renderers.InterpolationRenderer;
import mchorse.bbs_mod.utils.interps.IInterp;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class InterpolationTooltip
implements ITooltip {
    public float ax;
    public float ay;
    public Supplier<IInterp> interpolation;
    public Supplier<Integer> duration;
    public int margin = 10;

    public InterpolationTooltip(float ax, float ay, Supplier<IInterp> interpolation) {
        this(ax, ay, interpolation, null);
    }

    public InterpolationTooltip(float ax, float ay, Supplier<IInterp> interpolation, Supplier<Integer> duration) {
        this.ax = ax;
        this.ay = ay;
        this.interpolation = interpolation;
        this.duration = duration;
    }

    public InterpolationTooltip margin(int margin) {
        this.margin = margin;
        return this;
    }

    @Override
    public IKey getLabel() {
        return IKey.EMPTY;
    }

    @Override
    public void renderTooltip(UIContext context) {
        Area area = context.tooltip.area;
        IInterp interpolation = this.interpolation == null ? null : this.interpolation.get();
        int duration = this.duration == null ? 40 : this.duration.get();
        float fx = (this.ax - 0.5f) * 2.0f;
        int x = area.x(this.ax) + (int)((float)this.margin * fx);
        int y = area.y(this.ay);
        InterpolationRenderer.renderInterpolationPreview(interpolation, context, x, y, 1.0f - this.ax, this.ay, duration);
    }
}

