/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.model_blocks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.blocks.entities.ModelProperties;
import mchorse.bbs_mod.camera.CameraUtils;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.IFlightSupported;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.forms.UIFormPalette;
import mchorse.bbs_mod.ui.forms.UINestedEdit;
import mchorse.bbs_mod.ui.forms.UIToggleEditorEvent;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.events.UIRemovedEvent;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.model_blocks.UIModelBlockEntityList;
import mchorse.bbs_mod.ui.model_blocks.camera.ImmersiveModelBlockCameraController;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.utils.AABB;
import mchorse.bbs_mod.utils.PlayerUtils;
import mchorse.bbs_mod.utils.RayTracing;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class UIModelBlockPanel
extends UIDashboardPanel
implements IFlightSupported {
    public static boolean toggleRendering;
    public UIScrollView scrollView;
    public UIModelBlockEntityList modelBlocks;
    public UINestedEdit pickEdit;
    public UIToggle enabled;
    public UIToggle shadow;
    public UIToggle global;
    public UIPropTransform transform;
    private ModelBlockEntity modelBlock;
    private ModelBlockEntity hovered;
    private Vector3f mouseDirection = new Vector3f();
    private Set<ModelBlockEntity> toSave = new HashSet<ModelBlockEntity>();
    private ImmersiveModelBlockCameraController cameraController;
    private UIElement keyDude = new UIElement().noCulling();

    public UIModelBlockPanel(UIDashboard dashboard) {
        super(dashboard);
        this.keyDude.keys().register(Keys.MODEL_BLOCKS_MOVE_TO, () -> {
            class_310 mc = class_310.method_1551();
            class_4184 camera = mc.field_1773.method_19418();
            class_3965 blockHitResult = RayTracing.rayTrace((class_1937)mc.field_1687, camera.method_19326(), RayTracing.fromVector3f(this.mouseDirection), 512.0);
            if (blockHitResult.method_17783() != class_239.class_240.field_1333) {
                class_243 hit = blockHitResult.method_17784();
                class_2338 pos = this.modelBlock.method_11016();
                this.modelBlock.getProperties().getTransform().translate.set(hit.field_1352 - (double)pos.method_10263() - 0.5, hit.field_1351 - (double)pos.method_10264(), hit.field_1350 - (double)pos.method_10260() - 0.5);
                this.fillData();
            }
        }).active(() -> this.modelBlock != null);
        this.modelBlocks = new UIModelBlockEntityList(l -> this.fill((ModelBlockEntity)((Object)((Object)l.get(0))), false));
        this.modelBlocks.context((ContextMenuManager menu) -> {
            if (this.modelBlock != null) {
                menu.action(UIKeys.MODEL_BLOCKS_KEYS_TELEPORT, this::teleport);
            }
        });
        this.modelBlocks.background();
        this.modelBlocks.h(144);
        this.pickEdit = new UINestedEdit(editing -> {
            UIFormPalette palette = UIFormPalette.open(this, editing, this.modelBlock.getProperties().getForm(), f -> {
                this.pickEdit.setForm((Form)f);
                this.modelBlock.getProperties().setForm((Form)f);
            });
            palette.immersive();
            palette.editor.keys().register(Keys.MODEL_BLOCKS_TOGGLE_RENDERING, () -> {
                toggleRendering = !toggleRendering;
            });
            palette.editor.renderer.full(dashboard.getRoot());
            palette.editor.renderer.setTarget(this.modelBlock.getEntity());
            palette.editor.renderer.setRenderForm(() -> !toggleRendering);
            palette.getEvents().register(UIToggleEditorEvent.class, e -> {
                if (e.editing) {
                    this.addCameraController(palette);
                } else {
                    this.removeCameraController();
                }
            });
            palette.getEvents().register(UIRemovedEvent.class, e -> this.scrollView.setVisible(true));
            palette.resize();
            if (editing.booleanValue()) {
                this.addCameraController(palette);
            }
            this.scrollView.setVisible(false);
        });
        this.pickEdit.keybinds();
        this.enabled = new UIToggle(UIKeys.CAMERA_PANELS_ENABLED, b -> this.modelBlock.getProperties().setEnabled(b.getValue()));
        this.shadow = new UIToggle(UIKeys.MODEL_BLOCKS_SHADOW, b -> this.modelBlock.getProperties().setShadow(b.getValue()));
        this.global = new UIToggle(UIKeys.MODEL_BLOCKS_GLOBAL, b -> {
            this.modelBlock.getProperties().setGlobal(b.getValue());
            class_310.method_1551().field_1769.method_3279();
        });
        this.transform = new UIPropTransform();
        this.transform.enableHotkeys();
        this.scrollView = UI.scrollView(5, 10, this.modelBlocks, this.pickEdit, this.enabled, this.shadow, this.global, this.transform);
        this.scrollView.scroll.opposite().cancelScrolling();
        this.scrollView.relative(this).w(200).h(1.0f);
        this.fill(null, false);
        this.keys().register(Keys.MODEL_BLOCKS_TELEPORT, this::teleport);
        this.add((IUIElement)this.scrollView);
    }

    private void teleport() {
        if (this.modelBlock != null) {
            class_2338 pos = this.modelBlock.method_11016();
            PlayerUtils.teleport((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            UIUtils.playClick();
        }
    }

    @Override
    public boolean supportsRollFOVControl() {
        return false;
    }

    @Override
    public void appear() {
        super.appear();
        this.getContext().menu.main.add((IUIElement)this.keyDude);
        this.dashboard.orbitKeysUI.setEnabled(() -> this.getChildren(UIFormPalette.class).isEmpty());
        if (this.cameraController != null) {
            BBSModClient.getCameraController().add(this.cameraController);
        }
    }

    @Override
    public void disappear() {
        super.disappear();
        this.keyDude.removeFromParent();
        this.dashboard.orbitKeysUI.setEnabled(null);
        if (this.cameraController != null) {
            BBSModClient.getCameraController().remove(this.cameraController);
        }
    }

    public ModelBlockEntity getModelBlock() {
        return this.modelBlock;
    }

    private void addCameraController(UIFormPalette palette) {
        if (this.cameraController == null) {
            this.cameraController = new ImmersiveModelBlockCameraController(palette.editor.renderer, this.modelBlock);
            BBSModClient.getCameraController().add(this.cameraController);
            Transform transform = this.modelBlock.getProperties().getTransform().copy();
            transform.translate.set(0.0f, 0.0f, 0.0f);
            palette.editor.renderer.setTransform(new Matrix4f((Matrix4fc)transform.createMatrix()));
        }
    }

    private void removeCameraController() {
        if (this.cameraController != null) {
            BBSModClient.getCameraController().remove(this.cameraController);
            this.cameraController = null;
        }
    }

    @Override
    public boolean needsBackground() {
        return false;
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public void open() {
        super.open();
        this.updateList();
        if (this.modelBlock != null && this.modelBlock.method_11015()) {
            this.fill(null, true);
        }
    }

    @Override
    public void close() {
        super.close();
        this.removeCameraController();
        for (ModelBlockEntity entity : this.toSave) {
            this.save(entity);
        }
        this.toSave.clear();
    }

    private void updateList() {
        this.modelBlocks.clear();
        for (ModelBlockEntity modelBlock : BBSRendering.capturedModelBlocks) {
            this.modelBlocks.add(modelBlock);
        }
        this.fill(this.modelBlock, true);
    }

    public void fill(ModelBlockEntity modelBlock, boolean select) {
        if (modelBlock != null) {
            this.toSave.add(modelBlock);
        }
        this.modelBlock = modelBlock;
        if (modelBlock != null) {
            this.fillData();
        }
        this.pickEdit.setVisible(modelBlock != null);
        this.enabled.setVisible(modelBlock != null);
        this.shadow.setVisible(modelBlock != null);
        this.global.setVisible(modelBlock != null);
        this.transform.setVisible(modelBlock != null);
        if (select) {
            this.modelBlocks.setCurrentScroll(modelBlock);
        }
    }

    private void fillData() {
        ModelProperties properties = this.modelBlock.getProperties();
        this.pickEdit.setForm(properties.getForm());
        this.transform.setTransform(properties.getTransform());
        this.enabled.setValue(properties.isEnabled());
        this.shadow.setValue(properties.isShadow());
        this.global.setValue(properties.isGlobal());
    }

    private void save(ModelBlockEntity modelBlock) {
        if (modelBlock != null) {
            ClientNetwork.sendModelBlockForm(modelBlock.method_11016(), modelBlock);
        }
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        if (super.subMouseClicked(context)) {
            return true;
        }
        if (this.hovered != null && context.mouseButton == 0 && ((Boolean)BBSSettings.clickModelBlocks.get()).booleanValue()) {
            this.fill(this.hovered, true);
        }
        return false;
    }

    @Override
    protected boolean subKeyPressed(UIContext context) {
        return super.subKeyPressed(context);
    }

    @Override
    public void render(UIContext context) {
        String label = UIKeys.FILM_CONTROLLER_SPEED.format(this.dashboard.orbit.speed.getValue()).get();
        FontRenderer font = context.batcher.getFont();
        int w = font.getWidth(label);
        int x = this.area.w - w - 5;
        int y = this.area.ey() - font.getHeight() - 5;
        context.batcher.textCard(label, x, y, -1, -2013265920);
        super.render(context);
    }

    @Override
    public void renderInWorld(WorldRenderContext context) {
        super.renderInWorld(context);
        class_4184 camera = context.camera();
        class_243 pos = camera.method_19326();
        class_310 mc = class_310.method_1551();
        double x = mc.field_1729.method_1603();
        double y = mc.field_1729.method_1604();
        this.mouseDirection.set((Vector3fc)CameraUtils.getMouseDirection(RenderSystem.getProjectionMatrix(), context.matrixStack().method_23760().method_23761(), (int)x, (int)y, 0, 0, mc.method_22683().method_4480(), mc.method_22683().method_4507()));
        this.hovered = this.getClosestObject(new Vector3d(pos.field_1352, pos.field_1351, pos.field_1350), this.mouseDirection);
        RenderSystem.enableDepthTest();
        for (ModelBlockEntity entity : this.modelBlocks.getList()) {
            class_2338 blockPos = entity.method_11016();
            if (this.isEditing(entity)) continue;
            context.matrixStack().method_22903();
            context.matrixStack().method_22904((double)blockPos.method_10263() - pos.field_1352, (double)blockPos.method_10264() - pos.field_1351, (double)blockPos.method_10260() - pos.field_1350);
            if (this.hovered == entity || entity == this.modelBlock) {
                Draw.renderBox(context.matrixStack(), 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0f, 0.5f, 1.0f);
            } else {
                Draw.renderBox(context.matrixStack(), 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            context.matrixStack().method_22909();
        }
        RenderSystem.disableDepthTest();
    }

    private ModelBlockEntity getClosestObject(Vector3d finalPosition, Vector3f mouseDirection) {
        ModelBlockEntity closest = null;
        for (ModelBlockEntity object : this.modelBlocks.getList()) {
            AABB aabb = this.getHitbox(object);
            if (!aabb.intersectsRay(finalPosition, mouseDirection)) continue;
            if (closest == null) {
                closest = object;
                continue;
            }
            AABB aabb2 = this.getHitbox(closest);
            if (!(finalPosition.distanceSquared(aabb.x, aabb.y, aabb.z) < finalPosition.distanceSquared(aabb2.x, aabb2.y, aabb2.z))) continue;
            closest = object;
        }
        return closest;
    }

    private AABB getHitbox(ModelBlockEntity closest) {
        class_2338 pos = closest.method_11016();
        return new AABB(pos.method_10263(), pos.method_10264(), pos.method_10260(), 1.0, 1.0, 1.0);
    }

    public boolean isEditing(ModelBlockEntity entity) {
        List<UIFormPalette> children;
        if (this.modelBlock == entity && !(children = this.getChildren(UIFormPalette.class)).isEmpty()) {
            return children.get((int)0).editor.isEditing();
        }
        return false;
    }
}

