/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.morphing;

import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.morphing.IMorphProvider;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.forms.UIFormPalette;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.morphing.camera.ImmersiveMorphingCameraController;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Direction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5498;

@Environment(value=EnvType.CLIENT)
public class UIMorphingPanel
extends UIDashboardPanel {
    public UIFormPalette palette = new UIFormPalette(this::setForm);
    public UIIcon demorph;
    public UIIcon fromMob;
    private ImmersiveMorphingCameraController controller;

    public UIMorphingPanel(UIDashboard dashboard) {
        super(dashboard);
        this.palette.updatable().cantExit();
        this.palette.immersive();
        this.palette.full(this);
        this.palette.editor.renderer.full(dashboard.getRoot());
        this.palette.noBackground();
        this.palette.canModify();
        this.demorph = new UIIcon(Icons.POSE, b -> {
            this.palette.setSelected(null);
            this.setForm(null);
        });
        this.demorph.tooltip(UIKeys.MORPHING_DEMORPH, Direction.TOP);
        this.fromMob = new UIIcon(Icons.MORPH, b -> {
            Form form = Morph.getMobForm((class_1657)class_310.method_1551().field_1724);
            if (form != null) {
                this.palette.setSelected(form);
                this.setForm(form);
            }
        });
        this.fromMob.tooltip(UIKeys.MORPHING_FROM_MOB, Direction.TOP);
        this.palette.list.bar.add(this.fromMob, this.demorph);
        this.add((IUIElement)this.palette);
        this.controller = new ImmersiveMorphingCameraController(() -> this.palette.editor.isEditing() ? this.palette.editor.renderer : null);
    }

    private void setForm(Form form) {
        ClientNetwork.sendPlayerForm(form);
    }

    @Override
    public boolean needsBackground() {
        return !this.palette.editor.isEditing();
    }

    @Override
    public void appear() {
        super.appear();
        Morph morph = ((IMorphProvider)class_310.method_1551().field_1724).getMorph();
        this.palette.list.setupForms(BBSModClient.getFormCategories());
        this.palette.setSelected(morph.getForm());
        BBSModClient.getCameraController().add(this.controller);
        class_310.method_1551().field_1690.method_31043(class_5498.field_26665);
    }

    @Override
    public void disappear() {
        super.disappear();
        BBSModClient.getCameraController().remove(this.controller);
        class_310.method_1551().field_1690.method_31043(class_5498.field_26664);
    }

    @Override
    public void close() {
        super.close();
        BBSModClient.getCameraController().remove(this.controller);
    }
}

