/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.renderers.ParticleFormRenderer;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.particles.ParticleScheme;
import mchorse.bbs_mod.particles.emitter.ParticleEmitter;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.ContentType;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UIDataDashboardPanel;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextEditor;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.framework.elements.utils.UIRenderable;
import mchorse.bbs_mod.ui.particles.UIParticleSchemeRenderer;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeAppearanceSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeCollisionSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeCurvesSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeExpirationSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeGeneralSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeInitializationSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeLifetimeSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeLightingSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeMotionSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeRateSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeShapeSection;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeSpaceSection;
import mchorse.bbs_mod.ui.particles.utils.MolangSyntaxHighlighter;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Direction;
import mchorse.bbs_mod.utils.IOUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIParticleSchemePanel
extends UIDataDashboardPanel<ParticleScheme> {
    public static final Link PARTICLE_PLACEHOLDER = Link.assets("particles/default_placeholder.json");
    public UITextEditor textEditor;
    public UIParticleSchemeRenderer renderer;
    public UIScrollView sectionsView;
    public List<UIParticleSchemeSection> sections = new ArrayList<UIParticleSchemeSection>();
    private String molangId;

    public UIParticleSchemePanel(UIDashboard dashboard) {
        super(dashboard);
        this.renderer = new UIParticleSchemeRenderer();
        this.renderer.relative(this).wTo(this.iconBar.getFlex()).h(1.0f);
        this.textEditor = new UITextEditor(null).highlighter(new MolangSyntaxHighlighter());
        this.textEditor.background().relative(this.editor).y(1.0f, -60).w(1.0f).h(60);
        this.sectionsView = UI.scrollView(20, 10, new UIElement[0]);
        this.sectionsView.scroll.cancelScrolling().opposite().scrollSpeed *= 3;
        this.sectionsView.relative(this.editor).w(200).hTo(this.textEditor.area);
        this.prepend(new UIRenderable(this::drawOverlay));
        this.prepend(this.renderer);
        this.editor.add(this.textEditor, this.sectionsView);
        UIIcon close = new UIIcon(Icons.CLOSE, b -> this.editMoLang(null, null, null));
        close.relative(this.textEditor).x(1.0f, -20);
        this.textEditor.add((IUIElement)close);
        this.overlay.namesList.setFileIcon(Icons.PARTICLE);
        UIIcon restart = new UIIcon(Icons.REFRESH, b -> this.renderer.setScheme((ParticleScheme)this.data));
        restart.tooltip(UIKeys.SNOWSTORM_RESTART_EMITTER, Direction.LEFT);
        this.iconBar.add((IUIElement)restart);
        this.addSection(new UIParticleSchemeGeneralSection(this));
        this.addSection(new UIParticleSchemeCurvesSection(this));
        this.addSection(new UIParticleSchemeSpaceSection(this));
        this.addSection(new UIParticleSchemeInitializationSection(this));
        this.addSection(new UIParticleSchemeRateSection(this));
        this.addSection(new UIParticleSchemeLifetimeSection(this));
        this.addSection(new UIParticleSchemeShapeSection(this));
        this.addSection(new UIParticleSchemeMotionSection(this));
        this.addSection(new UIParticleSchemeExpirationSection(this));
        this.addSection(new UIParticleSchemeAppearanceSection(this));
        this.addSection(new UIParticleSchemeLightingSection(this));
        this.addSection(new UIParticleSchemeCollisionSection(this));
        this.fill(null);
    }

    public void editMoLang(String id, Consumer<String> callback, MolangExpression expression) {
        this.molangId = id;
        this.textEditor.callback = callback;
        this.textEditor.setText(expression == null ? "" : expression.toString());
        this.textEditor.setVisible(callback != null);
        if (callback != null) {
            this.sectionsView.hTo(this.textEditor.area);
        } else {
            this.sectionsView.h(1.0f);
        }
        this.sectionsView.resize();
    }

    @Override
    protected IKey getTitle() {
        return UIKeys.SNOWSTORM_TITLE;
    }

    @Override
    public ContentType getType() {
        return ContentType.PARTICLES;
    }

    public void dirty() {
        this.renderer.emitter.setupVariables();
    }

    private void addSection(UIParticleSchemeSection section) {
        this.sections.add(section);
        this.sectionsView.add((IUIElement)section);
    }

    @Override
    protected void fillData(ParticleScheme data) {
        this.editMoLang(null, null, null);
        if (this.data != null) {
            this.renderer.setScheme((ParticleScheme)this.data);
            for (UIParticleSchemeSection section : this.sections) {
                section.setScheme((ParticleScheme)this.data);
            }
            this.sectionsView.resize();
        }
    }

    @Override
    public void forceSave() {
        super.forceSave();
        ParticleFormRenderer.lastUpdate = System.currentTimeMillis();
    }

    @Override
    public void fillDefaultData(ParticleScheme data) {
        super.fillDefaultData(data);
        try (InputStream asset = BBSMod.getProvider().getAsset(PARTICLE_PLACEHOLDER);){
            MapType map = DataToString.mapFromString(IOUtils.readText(asset));
            ParticleScheme.PARSER.fromData(data, map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void appear() {
        super.appear();
        this.textEditor.updateHighlighter();
    }

    @Override
    public void close() {
        if (this.renderer.emitter != null) {
            this.renderer.emitter.particles.clear();
        }
    }

    @Override
    public void resize() {
        super.resize();
        this.renderer.resize();
    }

    private void drawOverlay(UIContext context) {
        if (this.editor.isVisible()) {
            ParticleEmitter emitter = this.renderer.emitter;
            String label = emitter.particles.size() + "P - " + emitter.age + "A";
            int y = (this.textEditor.isVisible() ? this.textEditor.area.y : this.area.ey()) - 12;
            context.batcher.textShadow(label, this.editor.area.ex() - 4 - context.batcher.getFont().getWidth(label), y);
        }
    }

    @Override
    public void render(UIContext context) {
        super.render(context);
        if (this.molangId != null) {
            FontRenderer font = context.batcher.getFont();
            int w = font.getWidth(this.molangId);
            context.batcher.textCard(this.molangId, this.textEditor.area.ex() - 6 - w, this.textEditor.area.ey() - 6 - font.getHeight());
        }
    }
}

