/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.sections;

import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.molang.MolangParser;
import mchorse.bbs_mod.particles.ParticleScheme;
import mchorse.bbs_mod.particles.components.motion.ParticleComponentMotionCollision;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.particles.UIParticleSchemePanel;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeComponentSection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIParticleSchemeCollisionSection
extends UIParticleSchemeComponentSection<ParticleComponentMotionCollision> {
    public UIToggle enabled = new UIToggle(UIKeys.SNOWSTORM_COLLISION_ENABLED, b -> this.editor.dirty());
    public UITrackpad drag = new UITrackpad(value -> {
        ((ParticleComponentMotionCollision)this.component).collisionDrag = value.floatValue();
        this.editor.dirty();
    });
    public UITrackpad bounciness;
    public UITrackpad radius;
    public UIToggle expire;
    private boolean wasPresent;

    public UIParticleSchemeCollisionSection(UIParticleSchemePanel parent) {
        super(parent);
        this.drag.tooltip(UIKeys.SNOWSTORM_COLLISION_DRAG);
        this.bounciness = new UITrackpad(value -> {
            ((ParticleComponentMotionCollision)this.component).bounciness = value.floatValue();
            this.editor.dirty();
        });
        this.bounciness.tooltip(UIKeys.SNOWSTORM_COLLISION_BOUNCINESS);
        this.radius = new UITrackpad(value -> {
            ((ParticleComponentMotionCollision)this.component).radius = value.floatValue();
            this.editor.dirty();
        });
        this.radius.tooltip(UIKeys.SNOWSTORM_COLLISION_RADIUS);
        this.expire = new UIToggle(UIKeys.SNOWSTORM_COLLISION_EXPIRE, b -> {
            ((ParticleComponentMotionCollision)this.component).expireOnImpact = b.getValue();
            this.editor.dirty();
        });
        this.fields.add(this.enabled, this.drag, this.bounciness, this.radius, this.expire);
    }

    @Override
    public IKey getTitle() {
        return UIKeys.SNOWSTORM_COLLISION_TITLE;
    }

    @Override
    public void beforeSave(ParticleScheme scheme) {
        ((ParticleComponentMotionCollision)this.component).enabled = this.enabled.getValue() ? MolangParser.ONE : MolangParser.ZERO;
    }

    @Override
    protected ParticleComponentMotionCollision getComponent(ParticleScheme scheme) {
        this.wasPresent = this.scheme.get(ParticleComponentMotionCollision.class) != null;
        return scheme.getOrCreate(ParticleComponentMotionCollision.class);
    }

    @Override
    protected void fillData() {
        this.enabled.setValue(this.wasPresent);
        this.drag.setValue(((ParticleComponentMotionCollision)this.component).collisionDrag);
        this.bounciness.setValue(((ParticleComponentMotionCollision)this.component).bounciness);
        this.radius.setValue(((ParticleComponentMotionCollision)this.component).radius);
        this.expire.setValue(((ParticleComponentMotionCollision)this.component).expireOnImpact);
    }
}

