/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.supporters;

import java.util.function.Supplier;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.supporters.Supporter;
import mchorse.bbs_mod.ui.supporters.Supporters;
import mchorse.bbs_mod.ui.supporters.UISupporterBanner;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Direction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UISupportersPanel
extends UIDashboardPanel {
    public UIElement ccSupporters;
    public UIElement superSupporters;
    public UIElement bbsEarlyAccessSupporters;
    private Supporters supporters = new Supporters();

    public UISupportersPanel(UIDashboard dashboard) {
        super(dashboard);
        this.supporters.setup();
        this.ccSupporters = new UIElement();
        this.ccSupporters.grid(5).items(3);
        this.superSupporters = new UIElement();
        this.superSupporters.grid(5).items(3);
        this.bbsEarlyAccessSupporters = new UIElement();
        this.bbsEarlyAccessSupporters.grid(5).items(3);
        UIScrollView scrollView = UI.scrollView(0, 0, new UIElement[0]);
        UIElement column = UI.column(5, 10, new UIElement[0]);
        scrollView.full(this);
        Supplier<Integer> color = () -> BBSSettings.primaryColor(-2013265920);
        column.add((IUIElement)UI.label(UIKeys.SUPPORTERS_GRATITUDE));
        column.add((IUIElement)UI.label(UIKeys.SUPPORTERS_CC).background(color).marginTop(6).marginBottom(6));
        column.add((IUIElement)this.ccSupporters);
        column.add((IUIElement)UI.label(UIKeys.SUPPORTERS_SUPER_SUPPORTERS).background(color).marginTop(12).marginBottom(6));
        column.add((IUIElement)this.superSupporters);
        column.add((IUIElement)UI.label(UIKeys.SUPPORTERS_EARLY_ACCESS).background(color).marginTop(12).marginBottom(6));
        column.add((IUIElement)this.bbsEarlyAccessSupporters.marginBottom(12));
        column.w(500);
        UIElement row = UI.row(0, 0, new UIElement(), column, new UIElement());
        for (Supporter supporter : this.supporters.getCCSupporters()) {
            this.ccSupporters.add((IUIElement)this.createSupporter(supporter));
        }
        for (Supporter supporter : this.supporters.getSuperSupporters()) {
            this.superSupporters.add((IUIElement)this.createSupporter(supporter));
        }
        for (Supporter supporter : this.supporters.getBBSEarlyAccessSupporters()) {
            this.bbsEarlyAccessSupporters.add((IUIElement)this.createSupporter(supporter));
        }
        scrollView.add((IUIElement)row);
        UIIcon tutorials = new UIIcon(Icons.HELP, b -> UIUtils.openWebLink(UIKeys.SUPPORTERS_TUTORIALS_LINK.get()));
        UIIcon community = new UIIcon(Icons.USER, b -> UIUtils.openWebLink(UIKeys.SUPPORTERS_COMMUNITY_LINK.get()));
        UIIcon wiki = new UIIcon(Icons.FILE, b -> UIUtils.openWebLink(UIKeys.SUPPORTERS_WIKI_LINK.get()));
        UIIcon donate = new UIIcon(Icons.HEART_ALT, b -> UIUtils.openWebLink(UIKeys.SUPPORTERS_DONATE_LINK.get()));
        UIElement icons = UI.column(0, tutorials, community, wiki, donate);
        tutorials.tooltip(UIKeys.SUPPORTERS_TUTORIALS, Direction.RIGHT);
        community.tooltip(UIKeys.SUPPORTERS_COMMUNITY, Direction.RIGHT);
        wiki.tooltip(UIKeys.SUPPORTERS_WIKI, Direction.RIGHT);
        donate.tooltip(UIKeys.SUPPORTERS_DONATE, Direction.RIGHT);
        icons.relative(this).w(20).column(0).vertical().stretch();
        this.add(scrollView, icons);
    }

    public UIElement createSupporter(Supporter supporter) {
        if (supporter.hasOnlyName()) {
            return UI.label(IKey.constant(supporter.name), Batcher2D.getDefaultTextRenderer().getHeight() + 4).labelAnchor(0.0f, 0.5f);
        }
        if (supporter.hasNoBanner()) {
            return UISupporterBanner.createLinkEntry(supporter);
        }
        return new UISupporterBanner(supporter);
    }
}

