/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.lwjgl.system.MemoryUtil;

public class IOUtils {
    public static String readText(File file) throws FileNotFoundException {
        return IOUtils.readText(new FileInputStream(file));
    }

    public static String readText(String path) {
        try {
            InputStream in = IOUtils.class.getResourceAsStream(path);
            return IOUtils.readText(in);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read file: " + path);
        }
    }

    public static String readText(InputStream in) {
        Scanner scanner = new Scanner(new InputStreamReader(in, StandardCharsets.UTF_8));
        String result = scanner.useDelimiter("\\A").next();
        scanner.close();
        return result;
    }

    public static void writeText(File file, String string) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        writer.write(string);
        writer.close();
    }

    public static List<String> readLines(String fileName) throws Exception {
        return IOUtils.readLines(IOUtils.class.getClass().getResourceAsStream(fileName));
    }

    public static List<String> readLines(InputStream stream) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    public static ByteBuffer readByteBuffer(InputStream stream, int bufferSize) throws IOException {
        byte[] bytes = IOUtils.readBytes(stream, bufferSize);
        ByteBuffer buffer = MemoryUtil.memAlloc((int)bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    public static byte[] readBytes(InputStream stream) throws IOException {
        return IOUtils.readBytes(stream, 4096);
    }

    public static byte[] readBytes(InputStream stream, int bufferSize) throws IOException {
        int bytesRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[bufferSize];
        while ((bytesRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, bytesRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static void deleteFolder(File folder) {
        if (!folder.isDirectory()) {
            return;
        }
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                IOUtils.deleteFolder(file);
                continue;
            }
            file.delete();
        }
        folder.delete();
    }

    public static File findNonExistingFile(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        String baseName = index == -1 ? name : name.substring(0, index);
        String extension = index == -1 ? "" : name.substring(index);
        int i = 1;
        while (file.exists()) {
            file = new File(file.getParentFile().getAbsolutePath(), baseName + "_" + i + extension);
            ++i;
        }
        return file;
    }
}

