/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MatrixUtils {
    public static Matrix3f getRotationFromTransformation(Matrix4f transformation) {
        Matrix3f rotation = new Matrix3f();
        Vector3f rx = new Vector3f(transformation.m00(), transformation.m10(), transformation.m20());
        Vector3f ry = new Vector3f(transformation.m01(), transformation.m11(), transformation.m21());
        Vector3f rz = new Vector3f(transformation.m02(), transformation.m12(), transformation.m22());
        rx.normalize();
        ry.normalize();
        rz.normalize();
        rotation.setRow(0, (Vector3fc)rx);
        rotation.setRow(1, (Vector3fc)ry);
        rotation.setRow(2, (Vector3fc)rz);
        return rotation;
    }

    public static Vector3f cast3dTo3f(Vector3d vec) {
        return new Vector3f((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static enum RotationOrder {
        XYZ,
        XZY,
        YXZ,
        YZX,
        ZXY,
        ZYX;

        public final Axis rotAxis0;
        public final Axis rotAxis1;
        public final Axis rotAxis2;

        private RotationOrder() {
            String order = this.name().toUpperCase();
            this.rotAxis0 = Axis.axisOfVectorIndex(order.charAt(0) - 88);
            this.rotAxis1 = Axis.axisOfVectorIndex(order.charAt(1) - 88);
            this.rotAxis2 = Axis.axisOfVectorIndex(order.charAt(2) - 88);
        }

        public Matrix3d getRotationMatrixFromXYZ(double x, double y, double z) {
            Vector3d angles = new Vector3d(x, y, z);
            return this.rotAxis0.getRotationMatrix(angles.get(this.rotAxis0.index)).mul((Matrix3dc)this.rotAxis1.getRotationMatrix(angles.get(this.rotAxis1.index))).mul((Matrix3dc)this.rotAxis2.getRotationMatrix(angles.get(this.rotAxis2.index)));
        }

        public Matrix3d getRotationMatrix(double angle0, double angle1, double angle2) {
            return this.rotAxis0.getRotationMatrix(angle0).mul((Matrix3dc)this.rotAxis1.getRotationMatrix(angle1)).mul((Matrix3dc)this.rotAxis2.getRotationMatrix(angle2));
        }

        public Vector3d orderAnglesToXYZ(double angle0, double angle1, double angle2) {
            Vector3d angles = new Vector3d();
            angles.setComponent(this.rotAxis0.index, angle0);
            angles.setComponent(this.rotAxis1.index, angle1);
            angles.setComponent(this.rotAxis2.index, angle2);
            return angles;
        }

        public Axis getForwardForRotationAxis(Axis axis) {
            return axis == Axis.Z ? Axis.Y : Axis.Z;
        }

        public Vector3d getEulerAngles(Matrix3d transform) {
            transform = new Matrix3d((Matrix3dc)transform);
            double angle0 = this.extractAngleAroundAxis(this.rotAxis0, transform);
            double angle1 = this.extractAngleAroundAxis(this.rotAxis1, transform);
            double angle2 = this.extractAngleAroundAxis(this.rotAxis2, transform);
            return this.orderAnglesToXYZ(angle0, angle1, angle2);
        }

        private double extractAngleAroundAxis(Axis axis, Matrix3d transform) {
            Matrix3d removeAxisRot = new Matrix3d().identity();
            double angle = axis.getAngleAround(this.getForwardForRotationAxis(axis), transform);
            axis.getRotationMatrix(removeAxisRot, -angle);
            transform.mulLocal((Matrix3dc)removeAxisRot);
            return angle;
        }
    }

    public static enum Axis {
        X,
        Y,
        Z;

        public final int index = this.name().toUpperCase().charAt(0) - 88;

        @Nullable
        public static Axis axisOfVectorIndex(int vecIndex) {
            return switch (vecIndex) {
                case 0 -> X;
                case 1 -> Y;
                case 2 -> Z;
                default -> null;
            };
        }

        public Matrix3d getRotationMatrix(double radians) {
            return this.getRotationMatrix(new Matrix3d(), radians);
        }

        public Matrix3d getRotationMatrix(Matrix3d mat, double radians) {
            mat.identity();
            switch (this) {
                case X: {
                    return mat.rotateX(radians);
                }
                case Y: {
                    return mat.rotateY(radians);
                }
                case Z: {
                    return mat.rotateZ(radians);
                }
            }
            return mat;
        }

        public Vector3d getAxisVector() {
            return new Vector3d(0.0, 0.0, 0.0).setComponent(this.index, 1.0);
        }

        public Vector3d projectOntoAxisPlane(Vector3d v) {
            return v.setComponent(this.index, 0.0);
        }

        public double getAngleAround(Axis forwardAxis, Matrix3d rotation) {
            return this.getAngleAround(forwardAxis, 1, rotation);
        }

        public double getAngleAround(Axis forwardAxis, int sign, Matrix3d rotation) {
            if (forwardAxis == this) {
                return 0.0;
            }
            sign = sign == 0 ? 1 : (int)Math.signum(sign);
            Vector3d forward = forwardAxis.getAxisVector().mul((double)sign);
            Vector3d flipTest = this.getAxisVector().cross((Vector3dc)forward);
            Vector3d rotatedForward = rotation.transform(new Vector3d((Vector3dc)forward));
            if ((rotatedForward = this.projectOntoAxisPlane(rotatedForward)).lengthSquared() < 1.0E-7) {
                return 0.0;
            }
            double angleUnsigned = rotatedForward.angle((Vector3dc)forward);
            return rotatedForward.dot((Vector3dc)flipTest) < 0.0 ? -angleUnsigned : angleUnsigned;
        }
    }
}

