/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.iris;

import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.iris.IrisTextureWrapper;
import mchorse.bbs_mod.utils.resources.FilteredLink;
import mchorse.bbs_mod.utils.resources.MultiLink;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.targets.backed.NativeImageBackedSingleColorTexture;
import net.irisshaders.iris.texture.pbr.PBRType;
import net.irisshaders.iris.texture.pbr.loader.PBRTextureLoader;
import net.minecraft.class_1044;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class IrisTextureWrapperLoader
implements PBRTextureLoader {
    public NativeImageBackedSingleColorTexture defaultNormalTexture;
    public NativeImageBackedSingleColorTexture defaultSpecularTexture;

    public void load(class_1044 abstractTexture, class_3300 resourceManager, PBRTextureLoader.PBRTextureConsumer pbrTextureConsumer) {
        if (this.defaultSpecularTexture == null) {
            this.defaultNormalTexture = new NativeImageBackedSingleColorTexture(PBRType.NORMAL.getDefaultValue());
            this.defaultSpecularTexture = new NativeImageBackedSingleColorTexture(PBRType.SPECULAR.getDefaultValue());
        }
        if (abstractTexture instanceof IrisTextureWrapper) {
            IrisTextureWrapper wrapper = (IrisTextureWrapper)abstractTexture;
            Link key = wrapper.texture;
            Link normalKey = this.createPrefixedCopy(key, "_n.png");
            Link specularKey = this.createPrefixedCopy(key, "_s.png");
            pbrTextureConsumer.acceptNormalTexture((class_1044)new IrisTextureWrapper(normalKey, (class_1044)this.defaultNormalTexture, wrapper.index));
            pbrTextureConsumer.acceptSpecularTexture((class_1044)new IrisTextureWrapper(specularKey, (class_1044)this.defaultSpecularTexture, wrapper.index));
        }
    }

    private Link createPrefixedCopy(Link link, String suffix) {
        if (link instanceof MultiLink) {
            MultiLink multiLink = (MultiLink)link;
            MultiLink newMultiLink = (MultiLink)multiLink.copy();
            for (FilteredLink child : newMultiLink.children) {
                if (child.path == null) continue;
                child.path = this.createPrefixedCopy(child.path, suffix);
            }
            return newMultiLink;
        }
        return new Link(link.source, StringUtils.removeExtension(link.path) + suffix);
    }
}

