/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes.factories;

import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.IntType;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.keyframes.BezierUtils;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;

public class IntegerKeyframeFactory
implements IKeyframeFactory<Integer> {
    @Override
    public Integer fromData(BaseType data) {
        return data.isNumeric() ? data.asNumeric().intValue() : 0;
    }

    @Override
    public BaseType toData(Integer value) {
        return new IntType(value);
    }

    @Override
    public Integer createEmpty() {
        return 0;
    }

    @Override
    public Integer copy(Integer value) {
        return value;
    }

    @Override
    public Integer interpolate(Keyframe<Integer> preA, Keyframe<Integer> a, Keyframe<Integer> b, Keyframe<Integer> postB, IInterp interpolation, float x) {
        if (interpolation.has(Interpolations.BEZIER)) {
            return (int)BezierUtils.get(a.getValue().intValue(), b.getValue().intValue(), a.getTick(), b.getTick(), a.rx, a.ry, a.lx, a.ly, x);
        }
        return (Integer)((Object)IKeyframeFactory.super.interpolate(preA, a, b, postB, interpolation, x));
    }

    @Override
    public Integer interpolate(Integer preA, Integer a, Integer b, Integer postB, IInterp interpolation, float x) {
        return (int)interpolation.interpolate(IInterp.context.set(preA.intValue(), a.intValue(), b.intValue(), postB.intValue(), x));
    }

    @Override
    public double getY(Integer value) {
        return value.intValue();
    }

    @Override
    public Object yToValue(double y) {
        return (int)y;
    }
}

