/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.manager;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.utils.manager.IManager;

public abstract class FolderManager<T extends ValueGroup>
implements IManager<T> {
    protected Supplier<File> folder;

    public FolderManager(Supplier<File> folder) {
        this.folder = folder;
    }

    public File getFolder() {
        File file = this.folder.get();
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    @Override
    public boolean exists(String name) {
        return this.getFile(name).exists();
    }

    @Override
    public boolean rename(String from, String to) {
        File file = this.getFile(from);
        return file != null && file.exists() && file.renameTo(this.getFile(to));
    }

    @Override
    public boolean delete(String name) {
        File file = this.getFile(name);
        return file != null && file.delete();
    }

    public boolean addFolder(String path) {
        File folder = this.getFolder(this.normalizePath(path));
        if (folder.exists()) {
            return false;
        }
        return folder.mkdirs();
    }

    public boolean renameFolder(String from, String to) {
        from = this.normalizePath(from);
        to = this.normalizePath(to);
        File folder = this.getFolder(from);
        return folder.isDirectory() && folder.renameTo(this.getFolder(to));
    }

    public boolean deleteFolder(String path) {
        File folder = this.getFolder(this.normalizePath(path));
        return folder.isDirectory() && folder.delete();
    }

    private String normalizePath(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    @Override
    public Collection<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        if (this.folder == null) {
            return set;
        }
        this.recursiveFind(set, this.getFolder(), "");
        return set;
    }

    private void recursiveFind(Set<String> set, File folder, String prefix) {
        for (File file : folder.listFiles()) {
            String name = file.getName();
            if (file.isFile() && this.isData(file)) {
                set.add(prefix + name.substring(0, name.lastIndexOf(".")));
                continue;
            }
            if (!file.isDirectory()) continue;
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                set.add(prefix + name + "/");
                continue;
            }
            this.recursiveFind(set, file, prefix + name + "/");
        }
    }

    protected boolean isData(File file) {
        return file.getName().endsWith(this.getExtension());
    }

    public File getFile(String name) {
        if (this.folder == null) {
            return null;
        }
        return new File(this.getFolder(), name + this.getExtension());
    }

    public File getFolder(String path) {
        if (this.folder == null) {
            return null;
        }
        return new File(this.getFolder(), path);
    }

    protected String getExtension() {
        return ".json";
    }
}

