/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.pose;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.bbs_mod.data.IMapSerializable;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.pose.PoseTransform;
import mchorse.bbs_mod.utils.pose.Transform;

public class Pose
implements IMapSerializable {
    private static Set<String> keys = new HashSet<String>();
    private static List<Pair<Pattern, String>> patterns = new ArrayList<Pair<Pattern, String>>();
    public boolean staticPose;
    public final Map<String, PoseTransform> transforms = new HashMap<String, PoseTransform>();

    public void flip(Map<String, String> flippedParts) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        if (flippedParts == null || flippedParts.isEmpty()) {
            for (String string : this.transforms.keySet()) {
                for (Pair<Pattern, String> pair : patterns) {
                    Matcher matcher = ((Pattern)pair.a).matcher(string);
                    if (!matcher.matches()) continue;
                    Pair<String, String> e = new Pair<String, String>(matcher.replaceAll((String)pair.b), string);
                    if (list.contains(new Pair<String, String>((String)e.b, (String)e.a))) continue;
                    list.add(e);
                }
            }
        } else {
            for (Map.Entry entry : flippedParts.entrySet()) {
                if (this.transforms.containsKey(entry.getKey())) {
                    list.add(new Pair<String, String>((String)entry.getValue(), (String)entry.getKey()));
                    continue;
                }
                if (!this.transforms.containsKey(entry.getValue())) continue;
                list.add(new Pair<String, String>((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        HashSet<String> bones = new HashSet<String>(this.transforms.keySet());
        for (Pair pair : list) {
            PoseTransform l = this.transforms.get(pair.a);
            PoseTransform r = this.transforms.get(pair.b);
            if (r == null) continue;
            if (l == null) {
                l = new PoseTransform();
                this.transforms.put((String)pair.a, l);
            }
            this.transforms.remove(pair.a);
            this.transforms.remove(pair.b);
            this.transforms.put((String)pair.a, r);
            this.transforms.put((String)pair.b, l);
            r.translate.mul(-1.0f, 1.0f, 1.0f);
            r.rotate.mul(1.0f, -1.0f, -1.0f);
            r.rotate2.mul(1.0f, -1.0f, -1.0f);
            l.translate.mul(-1.0f, 1.0f, 1.0f);
            l.rotate.mul(1.0f, -1.0f, -1.0f);
            l.rotate2.mul(1.0f, -1.0f, -1.0f);
            bones.remove(pair.a);
            bones.remove(pair.b);
        }
        for (String string : bones) {
            PoseTransform poseTransform = this.transforms.get(string);
            poseTransform.translate.mul(-1.0f, 1.0f, 1.0f);
            poseTransform.rotate.mul(1.0f, -1.0f, -1.0f);
            poseTransform.rotate2.mul(1.0f, -1.0f, -1.0f);
        }
    }

    public PoseTransform get(String name) {
        PoseTransform transform = this.transforms.get(name);
        if (transform == null) {
            transform = new PoseTransform();
            this.transforms.put(name, transform);
        }
        return transform;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Pose) {
            Pose pose = (Pose)obj;
            keys.clear();
            keys.addAll(this.transforms.keySet());
            keys.addAll(pose.transforms.keySet());
            for (String key : keys) {
                Transform a = this.transforms.get(key);
                Transform b = pose.transforms.get(key);
                if (a != null && b != null && !a.equals(b)) {
                    return false;
                }
                if (a == null && !b.isDefault()) {
                    return false;
                }
                if (b != null || a.isDefault()) continue;
                return false;
            }
            return this.staticPose == pose.staticPose;
        }
        return false;
    }

    public Pose copy() {
        Pose pose = new Pose();
        pose.copy(this);
        return pose;
    }

    public void copy(Pose pose) {
        this.staticPose = pose.staticPose;
        this.transforms.clear();
        if (pose.transforms.isEmpty()) {
            return;
        }
        for (Map.Entry<String, PoseTransform> entry : pose.transforms.entrySet()) {
            if (entry.getValue().isDefault()) continue;
            this.transforms.put(entry.getKey(), (PoseTransform)entry.getValue().copy());
        }
    }

    @Override
    public void toData(MapType data) {
        data.putBool("static", this.staticPose);
        if (this.transforms.isEmpty()) {
            return;
        }
        MapType pose = new MapType();
        for (Map.Entry<String, PoseTransform> entry : this.transforms.entrySet()) {
            if (entry.getValue().isDefault()) continue;
            pose.put(entry.getKey(), entry.getValue().toData());
        }
        data.put("pose", pose);
    }

    @Override
    public void fromData(MapType data) {
        this.staticPose = data.getBool("static");
        this.transforms.clear();
        MapType pose = data.getMap("pose");
        for (String key : pose.keys()) {
            PoseTransform transform = new PoseTransform();
            transform.fromData(pose.getMap(key));
            if (transform.isDefault()) continue;
            this.transforms.put(key, transform);
        }
    }

    public boolean isEmpty() {
        return this.transforms.isEmpty();
    }

    static {
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^right([_.].+)$"), "left$1"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])right$"), "$1left"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])right([_.].+)$"), "$1left$2"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^r([_.].+)$"), "l$1"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])r$"), "$1l"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])r([_.].+)$"), "$1l$2"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^left([_.].+)$"), "right$1"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])left$"), "$1right"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])left([_.].+)$"), "$1right$2"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^l([_.].+)$"), "r$1"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])l$"), "$1r"));
        patterns.add(new Pair<Pattern, String>(Pattern.compile("^(.+[_.])l([_.].+)$"), "$1r$2"));
    }
}

