/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.vox;

import mchorse.bbs_mod.cubic.data.model.ModelMesh;
import mchorse.bbs_mod.vox.data.Vox;
import org.joml.Matrix3f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VoxBuilder {
    public Vector3f translation;
    public Matrix3f transform;
    public Vector3f vector = new Vector3f();
    private Vector3f right;
    private Vector3f left;
    private Vector3f front;
    private Vector3f back;
    private Vector3f bottom;
    private Vector3f top;

    public VoxBuilder(Vector3f translation, Matrix3f transform) {
        this.translation = translation;
        this.transform = transform;
        this.right = this.processNormal(new Vector3f(-1.0f, 0.0f, 0.0f));
        this.left = this.processNormal(new Vector3f(1.0f, 0.0f, 0.0f));
        this.front = this.processNormal(new Vector3f(0.0f, 0.0f, 1.0f));
        this.back = this.processNormal(new Vector3f(0.0f, 0.0f, -1.0f));
        this.bottom = this.processNormal(new Vector3f(0.0f, -1.0f, 0.0f));
        this.top = this.processNormal(new Vector3f(0.0f, 1.0f, 0.0f));
    }

    private Vector3f processNormal(Vector3f normal) {
        normal.set(normal.x, normal.z, normal.y);
        this.transform.transform(normal);
        normal.set(normal.x, normal.z, normal.y);
        normal.normalize();
        return normal;
    }

    public ModelMesh build(Vox vox) {
        ModelMesh mesh = new ModelMesh();
        for (int x = 0; x < vox.w; ++x) {
            for (int y = 0; y < vox.h; ++y) {
                for (int z = 0; z < vox.d; ++z) {
                    int voxel = vox.voxels[vox.toIndex(x, y, z)];
                    if (voxel == 0) continue;
                    this.buildVertex(mesh, x, y, z, voxel, vox);
                }
            }
        }
        return mesh;
    }

    private void buildVertex(ModelMesh mesh, int x, int y, int z, int voxel, Vox vox) {
        Vector3f normal;
        boolean top = vox.has(x, y + 1, z);
        boolean bottom = vox.has(x, y - 1, z);
        boolean left = vox.has(x + 1, y, z);
        boolean right = vox.has(x - 1, y, z);
        boolean front = vox.has(x, y, z + 1);
        boolean back = vox.has(x, y, z - 1);
        if (!top) {
            normal = this.top;
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
        }
        if (!bottom) {
            normal = this.bottom;
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
        }
        if (!left) {
            normal = this.left;
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, -0.5f, normal);
        }
        if (!right) {
            normal = this.right;
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, 0.5f, -0.5f, normal);
        }
        if (!front) {
            normal = this.front;
            this.add(mesh, vox, x + 1, y, z + 1, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y, z + 1, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y, z + 1, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z + 1, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x, y + 1, z + 1, voxel, -0.5f, 0.5f, normal);
        }
        if (!back) {
            normal = this.back;
            this.add(mesh, vox, x, y + 1, z, voxel, -0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y, z, voxel, -0.5f, -0.5f, normal);
            this.add(mesh, vox, x + 1, y + 1, z, voxel, 0.5f, 0.5f, normal);
            this.add(mesh, vox, x + 1, y, z, voxel, 0.5f, -0.5f, normal);
            this.add(mesh, vox, x, y + 1, z, voxel, -0.5f, 0.5f, normal);
        }
    }

    private void add(ModelMesh mesh, Vox vox, int x, int y, int z, int voxel, float offsetU, float offsetV, Vector3f normal) {
        float u = (float)voxel + 0.5f + offsetU;
        float v = 0.5f + offsetV;
        Vector3f vertex = this.process(x, y, z, vox);
        mesh.baseData.vertices.add(new Vector3f((Vector3fc)vertex));
        mesh.baseData.normals.add(normal);
        mesh.baseData.uvs.add(new Vector2f(u, v));
    }

    private Vector3f process(int x, int y, int z, Vox vox) {
        int w = (int)((float)vox.w / 2.0f);
        int h = (int)((float)vox.h / 2.0f);
        int d = (int)((float)vox.d / 2.0f);
        this.vector.set((float)(x - w), (float)(z - h), (float)(y - d));
        this.transform.transform(this.vector);
        this.vector.set(this.vector.x, this.vector.z, this.vector.y);
        this.vector.add(this.translation.x, this.translation.z, this.translation.y);
        return this.vector;
    }
}

