/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.vox.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.vox.VoxReader;
import mchorse.bbs_mod.vox.data.VoxBaseNode;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VoxTransform
extends VoxBaseNode {
    public int childId;
    public int unusedId;
    public int layerId;
    public List<Matrix4f> transforms;

    public VoxTransform(InputStream stream, VoxReader reader) throws Exception {
        this.id = reader.readInt(stream);
        this.attrs = reader.readDictionary(stream);
        this.childId = reader.readInt(stream);
        this.unusedId = reader.readInt(stream);
        this.layerId = reader.readInt(stream);
        this.num = reader.readInt(stream);
        this.transforms = new ArrayList<Matrix4f>();
        for (int i = 0; i < this.num; ++i) {
            String[] splits;
            Map<String, String> dict = reader.readDictionary(stream);
            Matrix3f rotation = new Matrix3f();
            Vector3f translate = new Vector3f(0.0f, 0.0f, 0.0f);
            if (dict.containsKey("_r")) {
                rotation = reader.readRotation(Integer.parseInt(dict.get("_r")));
            }
            if (dict.containsKey("_t") && (splits = dict.get("_t").split(" ")).length == 3) {
                translate.set((float)(-Integer.parseInt(splits[0])), (float)Integer.parseInt(splits[1]), (float)Integer.parseInt(splits[2]));
            }
            Matrix4f transform = new Matrix4f();
            transform.set((Matrix3fc)rotation);
            transform.setTranslation((Vector3fc)translate);
            this.transforms.add(transform);
        }
    }
}

