/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio.ogg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import mchorse.bbs_mod.audio.Wave;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.IOUtils;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class VorbisReader {
    public static Wave read(Link link, InputStream stream) throws IOException {
        try (STBVorbisInfo info = STBVorbisInfo.malloc();){
            Wave wave;
            block15: {
                MemoryStack stack = MemoryStack.stackPush();
                try {
                    ByteBuffer buffer = IOUtils.readByteBuffer(stream, 8192);
                    IntBuffer error = stack.mallocInt(1);
                    long decoder = STBVorbis.stb_vorbis_open_memory((ByteBuffer)buffer, (IntBuffer)error, null);
                    if (decoder == 0L) {
                        throw new RuntimeException("Failed to read " + link.toString() + " Vorbis audio... Error code: " + error.get());
                    }
                    STBVorbis.stb_vorbis_get_info((long)decoder, (STBVorbisInfo)info);
                    int channels = info.channels();
                    int size = STBVorbis.stb_vorbis_stream_length_in_samples((long)decoder) * channels;
                    ShortBuffer samples = MemoryUtil.memAllocShort((int)size);
                    STBVorbis.stb_vorbis_get_samples_short_interleaved((long)decoder, (int)channels, (ShortBuffer)samples);
                    STBVorbis.stb_vorbis_close((long)decoder);
                    ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(size * 2));
                    int c = samples.limit();
                    for (int i = 0; i < c; ++i) {
                        byteBuffer.putShort(samples.get());
                    }
                    byteBuffer.flip();
                    byte[] finalBytes = new byte[byteBuffer.limit()];
                    int c2 = byteBuffer.limit();
                    for (int i = 0; i < c2; ++i) {
                        finalBytes[i] = byteBuffer.get();
                    }
                    Wave wave2 = new Wave(1, channels, info.sample_rate(), 16, finalBytes);
                    MemoryUtil.memFree((Buffer)buffer);
                    MemoryUtil.memFree((Buffer)samples);
                    MemoryUtil.memFree((Buffer)byteBuffer);
                    wave = wave2;
                    if (stack == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stack != null) {
                        try {
                            stack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stack.close();
            }
            return wave;
        }
    }
}

