/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.audio.wav;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import mchorse.bbs_mod.audio.Wave;

public class WaveWriter {
    public static void write(File file, Wave wave) throws IOException {
        WaveWriter.write(new FileOutputStream(file), wave);
    }

    public static void write(OutputStream stream, Wave wave) throws IOException {
        WaveWriter.writeString(stream, "RIFF");
        WaveWriter.writeInt(stream, 4);
        WaveWriter.writeString(stream, "WAVE");
        WaveWriter.writeString(stream, "fmt ");
        WaveWriter.writeInt(stream, 16);
        WaveWriter.writeShort(stream, wave.audioFormat);
        WaveWriter.writeShort(stream, wave.numChannels);
        WaveWriter.writeInt(stream, wave.sampleRate);
        WaveWriter.writeInt(stream, wave.byteRate);
        WaveWriter.writeShort(stream, wave.blockAlign);
        WaveWriter.writeShort(stream, wave.bitsPerSample);
        WaveWriter.writeString(stream, "data");
        WaveWriter.writeInt(stream, wave.data.length);
        stream.write(wave.data);
        stream.close();
    }

    private static void writeString(OutputStream stream, String string) throws IOException {
        byte[] bytes = new byte[string.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        stream.write(bytes);
    }

    private static void writeInt(OutputStream stream, int integer) throws IOException {
        byte[] bytes = new byte[]{(byte)(integer & 0xFF), (byte)(integer >> 8 & 0xFF), (byte)(integer >> 16 & 0xFF), (byte)(integer >> 24 & 0xFF)};
        stream.write(bytes);
    }

    private static void writeShort(OutputStream stream, int integer) throws IOException {
        byte[] bytes = new byte[]{(byte)(integer & 0xFF), (byte)(integer >> 8 & 0xFF)};
        stream.write(bytes);
    }
}

