/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.animation;

import mchorse.bbs_mod.cubic.IModel;
import mchorse.bbs_mod.cubic.animation.ActionConfig;
import mchorse.bbs_mod.cubic.data.animation.Animation;
import mchorse.bbs_mod.forms.entities.IEntity;

public class ActionPlayback {
    public Animation action;
    public ActionConfig config;
    private int fade;
    private float ticks;
    private int duration;
    private double speed = 1.0;
    private boolean looping;
    private Fade fading = Fade.FINISHED;
    public boolean playing = true;
    public int priority;

    public ActionPlayback(Animation action, ActionConfig config, boolean looping) {
        this.action = action;
        this.config = config;
        this.duration = action.getLengthInTicks();
        this.looping = looping;
        this.setSpeed(1.0);
    }

    public ActionPlayback(Animation action, ActionConfig config, boolean looping, int priority) {
        this(action, config, looping);
        this.priority = priority;
    }

    public void rewind() {
        if (this.config.loop) {
            this.ticks = Math.copySign(1.0, this.speed) < 0.0 ? (float)this.duration : 0.0f;
        }
        this.stopFade();
    }

    public boolean finishedFading() {
        return this.fading != Fade.FINISHED && this.fade <= 0;
    }

    public boolean isFadingModeOut() {
        return this.fading == Fade.OUT;
    }

    public boolean isFadingModeIn() {
        return this.fading == Fade.IN;
    }

    public boolean isFading() {
        return this.fading != Fade.FINISHED && this.fade > 0;
    }

    public void fadeOut() {
        this.fade = (int)this.config.fade;
        this.fading = Fade.OUT;
    }

    public void fadeIn() {
        this.fade = (int)this.config.fade;
        this.fading = Fade.IN;
    }

    public void stopFade() {
        this.fade = 0;
        this.fading = Fade.FINISHED;
    }

    public void resetFade() {
        this.fade = 0;
        this.fading = Fade.FINISHED;
    }

    public int getFade() {
        return this.fade;
    }

    public float getFadeFactor(float transition) {
        float factor = ((float)this.fade - transition) / this.config.fade;
        return this.fading == Fade.OUT ? factor : 1.0f - factor;
    }

    public void setSpeed(double speed) {
        this.speed = speed * (double)this.config.speed;
    }

    public void update() {
        if (this.fading != Fade.FINISHED && this.fade > 0) {
            --this.fade;
        }
        if (!this.playing) {
            return;
        }
        this.ticks = (float)((double)this.ticks + this.speed);
        boolean looping = this.looping;
        if (!this.config.loop) {
            looping = false;
        }
        if (!looping && this.fading != Fade.OUT && this.ticks >= (float)this.duration) {
            this.fadeOut();
        }
        if (looping) {
            if (this.ticks >= (float)this.duration && this.speed > 0.0) {
                this.ticks -= (float)this.duration;
                this.ticks += (float)this.config.tick;
            } else if (this.ticks < 0.0f && this.speed < 0.0) {
                this.ticks = (float)this.duration + this.ticks;
                this.ticks -= (float)this.config.tick;
            }
        }
    }

    public float getTick(float transition) {
        boolean looping = this.looping;
        if (!this.config.loop) {
            looping = false;
        }
        float ticks = this.ticks + (float)((double)transition * this.speed);
        if (looping) {
            if (ticks >= (float)this.duration && this.speed > 0.0) {
                ticks -= (float)this.duration;
            } else if (this.ticks < 0.0f && this.speed < 0.0) {
                ticks = (float)this.duration + ticks;
            }
        }
        return ticks;
    }

    public void apply(IEntity target, IModel armature, float transition, float blend, boolean skipInitial) {
        float tick = this.getTick(transition);
        armature.apply(target, this.action, tick, blend, transition, skipInitial);
    }

    public static enum Fade {
        OUT,
        FINISHED,
        IN;

    }
}

