/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.animation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mchorse.bbs_mod.cubic.IModelInstance;
import mchorse.bbs_mod.cubic.animation.ActionConfig;
import mchorse.bbs_mod.cubic.animation.ActionPlayback;
import mchorse.bbs_mod.cubic.animation.ActionsConfig;
import mchorse.bbs_mod.cubic.animation.IAnimator;
import mchorse.bbs_mod.cubic.data.animation.Animation;
import mchorse.bbs_mod.cubic.data.animation.Animations;
import mchorse.bbs_mod.forms.entities.IEntity;
import net.minecraft.class_243;

public class Animator
implements IAnimator {
    public ActionPlayback idle;
    public ActionPlayback running;
    public ActionPlayback sprinting;
    public ActionPlayback crouching;
    public ActionPlayback crouchingIdle;
    public ActionPlayback dying;
    public ActionPlayback falling;
    public ActionPlayback jump1;
    public ActionPlayback jump2;
    public ActionPlayback swipe;
    public ActionPlayback hurt;
    public ActionPlayback land;
    public ActionPlayback shoot;
    public ActionPlayback consume;
    public ActionPlayback basePre;
    public ActionPlayback basePost;
    public ActionPlayback active;
    public ActionPlayback lastActive;
    public List<ActionPlayback> actions = new ArrayList<ActionPlayback>();
    public double prevX = 3.4028234663852886E38;
    public double prevZ = 3.4028234663852886E38;
    public double prevMY;
    public float prevHandSwing;
    public boolean wasOnGround = true;
    public int jumpingCounter;
    private IModelInstance model;

    @Override
    public List<String> getActions() {
        return Arrays.asList("idle", "running", "sprinting", "crouching", "crouching_idle", "dying", "falling", "swipe", "jump", "hurt", "land", "shoot", "consume", "base_pre", "base_post");
    }

    @Override
    public void setup(IModelInstance model, ActionsConfig actions, boolean fade) {
        this.model = model;
        this.idle = this.createAction(this.idle, actions.getConfig("idle"), true);
        this.running = this.createAction(this.running, actions.getConfig("running"), true);
        this.sprinting = this.createAction(this.sprinting, actions.getConfig("sprinting"), true);
        this.crouching = this.createAction(this.crouching, actions.getConfig("crouching"), true);
        this.crouchingIdle = this.createAction(this.crouchingIdle, actions.getConfig("crouching_idle"), true);
        this.dying = this.createAction(this.dying, actions.getConfig("dying"), false);
        this.falling = this.createAction(this.falling, actions.getConfig("falling"), true);
        this.swipe = this.createAction(this.swipe, actions.getConfig("swipe"), false);
        this.jump1 = this.createAction(this.jump1, actions.getConfig("jump"), false, 2);
        this.jump2 = this.createAction(this.jump2, actions.getConfig("jump_alt"), false, 2);
        this.hurt = this.createAction(this.hurt, actions.getConfig("hurt"), false, 3);
        this.land = this.createAction(this.land, actions.getConfig("land"), false);
        this.shoot = this.createAction(this.shoot, actions.getConfig("shoot"), true);
        this.consume = this.createAction(this.consume, actions.getConfig("consume"), true);
        this.basePre = this.createAction(this.basePre, actions.getConfig("base_pre"), true);
        this.basePost = this.createAction(this.basePost, actions.getConfig("base_post"), true);
        if (!fade) {
            this.setActiveAction(this.idle);
            if (this.idle != null) {
                this.idle.resetFade();
            }
        }
    }

    public ActionPlayback createAction(ActionPlayback old, ActionConfig config, boolean looping) {
        return this.createAction(old, config, looping, 1);
    }

    public ActionPlayback createAction(ActionPlayback old, ActionConfig config, boolean looping, int priority) {
        Animations animations;
        Animations animations2 = animations = this.model == null ? null : this.model.getAnimations();
        if (animations == null) {
            return null;
        }
        Animation action = animations.get(config.name);
        if (action == null) {
            return null;
        }
        if (old != null && old.action == action) {
            old.config = config;
            old.setSpeed(1.0);
            return old;
        }
        return new ActionPlayback(action, config, looping, priority);
    }

    @Override
    public void update(IEntity target) {
        if (this.prevX == 3.4028234663852886E38) {
            this.prevX = target.getX();
            this.prevZ = target.getZ();
        }
        this.controlActions(target);
        if (this.basePre != null) {
            this.basePre.update();
        }
        if (this.basePost != null) {
            this.basePost.update();
        }
        if (this.active != null) {
            this.active.update();
        }
        if (this.lastActive != null) {
            this.lastActive.update();
        }
        Iterator<ActionPlayback> it = this.actions.iterator();
        while (it.hasNext()) {
            ActionPlayback action = it.next();
            action.update();
            if (!action.finishedFading() || !action.isFadingModeOut()) continue;
            action.stopFade();
            it.remove();
        }
    }

    protected void controlActions(IEntity target) {
        float handSwingProgress;
        boolean moves;
        class_243 velocity = target.getVelocity();
        double dx = target.getX() - this.prevX;
        double dz = target.getZ() - this.prevZ;
        float threshold = 0.01f;
        boolean bl = moves = Math.abs(dx) > (double)0.01f || Math.abs(dz) > (double)0.01f;
        if (target.isSneaking()) {
            this.setActiveAction(!moves ? this.crouchingIdle : this.crouching);
        } else if (!target.isOnGround() && velocity.field_1351 < 0.0 && (double)target.getFallDistance() > 1.25) {
            this.setActiveAction(this.falling);
        } else if (target.isSprinting() && this.sprinting != null) {
            this.setActiveAction(this.sprinting);
        } else {
            this.setActiveAction(!moves ? this.idle : this.running);
        }
        if (target.isOnGround() && !this.wasOnGround && this.prevMY < -0.5) {
            this.addAction(this.land);
        }
        if (!target.isOnGround() && this.wasOnGround && Math.abs(velocity.field_1351) > (double)0.2f) {
            ActionPlayback jump = this.jump1;
            if (this.jumpingCounter % 2 == 0 && this.jump2 != null) {
                jump = this.jump2;
            }
            this.addAction(jump);
            this.wasOnGround = false;
            ++this.jumpingCounter;
        }
        if ((handSwingProgress = target.getHandSwingProgress(0.0f)) < this.prevHandSwing) {
            this.prevHandSwing = 0.0f;
        }
        if (handSwingProgress > 0.0f && this.prevHandSwing == 0.0f) {
            this.addAction(this.swipe);
        }
        this.prevX = target.getX();
        this.prevZ = target.getZ();
        this.prevMY = velocity.field_1351;
        this.prevHandSwing = handSwingProgress;
        this.wasOnGround = target.isOnGround();
    }

    public void setActiveAction(ActionPlayback action) {
        if (this.active == action || action == null) {
            return;
        }
        if (this.active != null && action.priority < this.active.priority) {
            return;
        }
        if (this.active != null) {
            this.lastActive = this.active;
        }
        this.active = action;
        this.active.rewind();
        this.active.fadeIn();
    }

    public void addAction(ActionPlayback action) {
        this.addAction(action, true);
    }

    public void addAction(ActionPlayback action, boolean rewind) {
        if (action == null) {
            return;
        }
        if (this.actions.contains(action)) {
            if (rewind) {
                action.rewind();
            }
            return;
        }
        action.rewind();
        action.fadeIn();
        this.actions.add(action);
    }

    @Override
    public void applyActions(IEntity target, IModelInstance armature, float transition) {
        if (this.basePre != null) {
            this.basePre.apply(target, armature.getModel(), transition, 1.0f, false);
        }
        if (this.lastActive != null && this.active.isFading()) {
            this.lastActive.apply(target, armature.getModel(), transition, 1.0f, false);
        }
        if (this.active != null) {
            float fade = this.active.isFading() ? this.active.getFadeFactor(transition) : 1.0f;
            this.active.apply(target, armature.getModel(), transition, fade, false);
        }
        if (this.basePost != null) {
            this.basePost.apply(target, armature.getModel(), transition, 1.0f, false);
        }
        for (ActionPlayback action : this.actions) {
            if (action.isFading()) {
                action.apply(target, armature.getModel(), transition, action.getFadeFactor(transition), true);
                continue;
            }
            action.apply(target, armature.getModel(), transition, 1.0f, true);
        }
    }

    @Override
    public void playAnimation(String name) {
        Animation animation = this.model.getAnimations().get(name);
        this.addAction(new ActionPlayback(animation, new ActionConfig(), false, -1));
    }
}

