/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.animation;

import java.util.Arrays;
import java.util.List;
import mchorse.bbs_mod.bobj.BOBJBone;
import mchorse.bbs_mod.cubic.IModel;
import mchorse.bbs_mod.cubic.IModelInstance;
import mchorse.bbs_mod.cubic.animation.ActionConfig;
import mchorse.bbs_mod.cubic.animation.ActionPlayback;
import mchorse.bbs_mod.cubic.animation.ActionsConfig;
import mchorse.bbs_mod.cubic.animation.IAnimator;
import mchorse.bbs_mod.cubic.data.animation.Animation;
import mchorse.bbs_mod.cubic.data.animation.Animations;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4050;

public class ProceduralAnimator
implements IAnimator {
    public ActionPlayback basePre;
    public ActionPlayback basePost;
    private IModelInstance model;

    @Override
    public List<String> getActions() {
        return Arrays.asList("base_pre", "base_post");
    }

    @Override
    public void setup(IModelInstance model, ActionsConfig actions, boolean fade) {
        this.model = model;
        this.basePre = this.createAction(this.basePre, actions.getConfig("base_pre"), true);
        this.basePost = this.createAction(this.basePost, actions.getConfig("base_post"), true);
    }

    public ActionPlayback createAction(ActionPlayback old, ActionConfig config, boolean looping) {
        return this.createAction(old, config, looping, 1);
    }

    public ActionPlayback createAction(ActionPlayback old, ActionConfig config, boolean looping, int priority) {
        Animations animations;
        Animations animations2 = animations = this.model == null ? null : this.model.getAnimations();
        if (animations == null) {
            return null;
        }
        Animation action = animations.get(config.name);
        if (action == null) {
            return null;
        }
        if (old != null && old.action == action) {
            old.config = config;
            old.setSpeed(1.0);
            return old;
        }
        return new ActionPlayback(action, config, looping, priority);
    }

    @Override
    public void update(IEntity entity) {
        if (this.basePre != null) {
            this.basePre.update();
        }
        if (this.basePost != null) {
            this.basePost.update();
        }
    }

    @Override
    public void applyActions(IEntity target, IModelInstance armature, float transition) {
        if (target == null) {
            return;
        }
        if (this.basePre != null) {
            this.basePre.apply(target, armature.getModel(), transition, 1.0f, false);
        }
        IModel model = armature.getModel();
        class_1799 main = target.getEquipmentStack(class_1304.field_6173);
        class_1799 offhand = target.getEquipmentStack(class_1304.field_6171);
        boolean isRolling = target.getRoll() > 4;
        boolean isInSwimmingPose = target.getEntityPose() == class_4050.field_18079;
        float handSwingProgress = target.getHandSwingProgress(transition);
        float age = (float)target.getAge() + transition;
        float bodyYaw = Lerps.lerp(target.getPrevBodyYaw(), target.getBodyYaw(), transition);
        float headYaw = Lerps.lerp(target.getPrevHeadYaw(), target.getHeadYaw(), transition);
        float yaw = headYaw - bodyYaw;
        float pitch = Lerps.lerp(target.getPrevPitch(), target.getPitch(), transition);
        float limbSpeed = target.getLimbSpeed(transition);
        float limbPhase = target.getLimbPos(transition);
        float leaningPitch = target.getLeaningPitch(transition);
        float coefficient = 1.0f;
        if (isRolling) {
            coefficient = (float)(target.getVelocity().method_1027() / 2.0);
            coefficient = Math.min(1.0f, coefficient * coefficient * coefficient);
        }
        model.resetPose();
        if (target.isSneaking()) {
            model.applyPose(armature.getSneakingPose());
        }
        if (model instanceof Model) {
            ModelGroup leftArm = null;
            ModelGroup rightArm = null;
            ModelGroup torso = null;
            for (ModelGroup group : model.getAllGroups()) {
                if (group.id.equals("anchor")) {
                    if (target.isUsingRiptide()) {
                        group.current.rotate.x = -90.0f - pitch;
                        group.current.rotate2.y = age * -75.0f;
                    }
                    if (target.isFallFlying()) {
                        float roll = (float)target.getRoll() + transition;
                        float riptide = class_3532.method_15363((float)(roll * roll / 100.0f), (float)0.0f, (float)1.0f);
                        if (!target.isUsingRiptide()) {
                            group.current.rotate.x = riptide * (-90.0f - pitch);
                        }
                        class_243 look = target.getRotationVec(transition);
                        class_243 velocity = target.lerpVelocity(transition);
                        double vl = velocity.method_37268();
                        double ll = look.method_37268();
                        if (!(vl > 0.0) || !(ll > 0.0)) continue;
                        double m = (velocity.field_1352 * look.field_1352 + velocity.field_1350 * look.field_1350) / Math.sqrt(vl * ll);
                        double n = velocity.field_1352 * look.field_1350 - velocity.field_1350 * look.field_1352;
                        group.current.rotate.y = MathUtils.toDeg((float)(Math.signum(n) * Math.acos(m)));
                        continue;
                    }
                    if (!(leaningPitch > 0.0f)) continue;
                    float newPitch = target.isTouchingWater() ? -90.0f - pitch : -90.0f;
                    group.current.rotate.x = class_3532.method_16439((float)leaningPitch, (float)0.0f, (float)newPitch);
                    if (target.getEntityPose() != class_4050.field_18079) continue;
                    group.current.translate.y -= 8.0f;
                    group.current.translate.z += 4.8f;
                    continue;
                }
                if (group.id.equals("head")) {
                    group.current.rotate.y = -yaw;
                    if (isRolling) {
                        group.current.rotate.x = 45.0f;
                        continue;
                    }
                    if (leaningPitch > 0.0f) {
                        group.current.rotate.x = this.lerpAngle(leaningPitch, group.current.rotate.x, isInSwimmingPose ? 45.0f : -pitch);
                        continue;
                    }
                    group.current.rotate.x = -pitch;
                    continue;
                }
                if (group.id.equals("right_arm")) {
                    group.current.rotate.x += MathUtils.toDeg(class_3532.method_15362((float)(limbPhase * 0.6662f)) * 2.0f * limbSpeed * 0.5f / coefficient);
                    group.current.rotate.z += MathUtils.toDeg(1.0f * (class_3532.method_15362((float)(-age * 0.09f)) * 0.05f + 0.05f));
                    group.current.rotate.x += MathUtils.toDeg(1.0f * class_3532.method_15374((float)(-age * 0.067f)) * 0.05f);
                    if (!main.method_7960()) {
                        group.current.rotate.x = group.current.rotate.x * 0.5f + 18.0f;
                    }
                    rightArm = group;
                    continue;
                }
                if (group.id.equals("left_arm")) {
                    group.current.rotate.x += MathUtils.toDeg(class_3532.method_15362((float)(limbPhase * 0.6662f + (float)Math.PI)) * 2.0f * limbSpeed * 0.5f / coefficient);
                    group.current.rotate.z += MathUtils.toDeg(-1.0f * (class_3532.method_15362((float)(-age * 0.09f)) * 0.05f + 0.05f));
                    group.current.rotate.x += MathUtils.toDeg(-1.0f * class_3532.method_15374((float)(-age * 0.067f)) * 0.05f);
                    if (!offhand.method_7960()) {
                        group.current.rotate.x = group.current.rotate.x * 0.5f + 18.0f;
                    }
                    leftArm = group;
                    continue;
                }
                if (group.id.equals("torso")) {
                    torso = group;
                    continue;
                }
                if (group.id.equals("right_leg")) {
                    group.current.rotate.x = MathUtils.toDeg(class_3532.method_15362((float)(limbPhase * 0.6662f + (float)Math.PI)) * 1.4f * limbSpeed / coefficient);
                    continue;
                }
                if (!group.id.equals("left_leg")) continue;
                group.current.rotate.x = MathUtils.toDeg(class_3532.method_15362((float)(limbPhase * 0.6662f)) * 1.4f * limbSpeed / coefficient);
            }
            if (handSwingProgress > 0.0f && torso != null && leftArm != null && rightArm != null) {
                float swingFactor = handSwingProgress;
                torso.current.rotate.y = -MathUtils.toDeg(class_3532.method_15374((float)(class_3532.method_15355((float)swingFactor) * (float)Math.PI * 2.0f)) * 0.2f);
                leftArm.current.translate.z += (float)Math.sin(MathUtils.toRad(torso.current.rotate.y)) * 5.0f;
                leftArm.current.translate.x += (float)Math.cos(MathUtils.toRad(torso.current.rotate.y)) * 5.0f - 5.0f;
                rightArm.current.translate.z -= (float)Math.sin(MathUtils.toRad(torso.current.rotate.y)) * 5.0f;
                rightArm.current.translate.x -= (float)Math.cos(MathUtils.toRad(torso.current.rotate.y)) * 5.0f - 5.0f;
                ModelGroup group = rightArm;
                group.current.rotate.y += torso.current.rotate.y;
                group = leftArm;
                group.current.rotate.y += torso.current.rotate.y;
                group = leftArm;
                group.current.rotate.x += torso.current.rotate.y;
                swingFactor = 1.0f - handSwingProgress;
                swingFactor *= swingFactor;
                swingFactor *= swingFactor;
                swingFactor = 1.0f - swingFactor;
                float headPitch = 0.0f;
                float swing1 = class_3532.method_15374((float)(swingFactor * (float)Math.PI));
                float swign2 = class_3532.method_15374((float)(handSwingProgress * (float)Math.PI)) * -(headPitch - 0.7f) * 0.75f;
                rightArm.current.rotate.x = group.current.rotate.x + MathUtils.toDeg(swing1 * 1.2f + swign2);
                rightArm.current.rotate.y += torso.current.rotate.y * 2.0f;
                rightArm.current.rotate.z += MathUtils.toDeg(class_3532.method_15374((float)(handSwingProgress * (float)Math.PI)) * -0.4f);
            }
        } else {
            BOBJBone bobjLeftArm = null;
            BOBJBone bobjRightArm = null;
            for (BOBJBone bone : model.getAllBOBJBones()) {
                if (bone.name.equals("anchor")) {
                    if (target.isUsingRiptide()) {
                        bone.transform.rotate.x = MathUtils.toRad(-90.0f - pitch);
                        bone.transform.rotate2.y = MathUtils.toRad(age * -75.0f);
                    }
                    if (target.isFallFlying()) {
                        float roll = (float)target.getRoll() + transition;
                        float riptide = class_3532.method_15363((float)(roll * roll / 100.0f), (float)0.0f, (float)1.0f);
                        if (!target.isUsingRiptide()) {
                            bone.transform.rotate.x = MathUtils.toRad(riptide * (-90.0f - pitch));
                        }
                        class_243 look = target.getRotationVec(transition);
                        class_243 velocity = target.lerpVelocity(transition);
                        double vl = velocity.method_37268();
                        double ll = look.method_37268();
                        if (!(vl > 0.0) || !(ll > 0.0)) continue;
                        double m = (velocity.field_1352 * look.field_1352 + velocity.field_1350 * look.field_1350) / Math.sqrt(vl * ll);
                        double n = velocity.field_1352 * look.field_1350 - velocity.field_1350 * look.field_1352;
                        bone.transform.rotate.y = (float)(Math.signum(n) * Math.acos(m));
                        continue;
                    }
                    if (!(leaningPitch > 0.0f)) continue;
                    float newPitch = target.isTouchingWater() ? -90.0f - pitch : -90.0f;
                    bone.transform.rotate.x = MathUtils.toRad(class_3532.method_16439((float)leaningPitch, (float)0.0f, (float)newPitch));
                    if (target.getEntityPose() != class_4050.field_18079) continue;
                    bone.transform.translate.y -= MathUtils.toRad(8.0f);
                    bone.transform.translate.z += MathUtils.toRad(4.8f);
                    continue;
                }
                if (bone.name.equals("head")) {
                    bone.transform.rotate.y = MathUtils.toRad(-yaw);
                    if (isRolling) {
                        bone.transform.rotate.x = -MathUtils.toRad(45.0f);
                        continue;
                    }
                    if (leaningPitch > 0.0f) {
                        bone.transform.rotate.x = -MathUtils.toRad(this.lerpAngle(leaningPitch, bone.transform.rotate.x, isInSwimmingPose ? 45.0f : -pitch));
                        continue;
                    }
                    bone.transform.rotate.x = -MathUtils.toRad(-pitch);
                    continue;
                }
                if (bone.name.equals("right_arm")) {
                    bone.transform.rotate.x += class_3532.method_15362((float)(limbPhase * 0.6662f)) * 2.0f * limbSpeed * 0.5f / coefficient;
                    bone.transform.rotate.z -= 1.0f * (class_3532.method_15362((float)(-age * 0.09f)) * 0.05f + 0.05f);
                    bone.transform.rotate.x += 1.0f * class_3532.method_15374((float)(-age * 0.067f)) * 0.05f;
                    if (!main.method_7960()) {
                        bone.transform.rotate.x = bone.transform.rotate.x * 0.5f + MathUtils.toRad(18.0f);
                    }
                    bobjRightArm = bone;
                    continue;
                }
                if (bone.name.equals("left_arm")) {
                    bone.transform.rotate.x += class_3532.method_15362((float)(limbPhase * 0.6662f + (float)Math.PI)) * 2.0f * limbSpeed * 0.5f / coefficient;
                    bone.transform.rotate.z -= -1.0f * (class_3532.method_15362((float)(-age * 0.09f)) * 0.05f + 0.05f);
                    bone.transform.rotate.x += -1.0f * class_3532.method_15374((float)(-age * 0.067f)) * 0.05f;
                    if (!offhand.method_7960()) {
                        bone.transform.rotate.x = bone.transform.rotate.x * 0.5f + MathUtils.toRad(18.0f);
                    }
                    bobjLeftArm = bone;
                    continue;
                }
                if (bone.name.equals("right_leg")) {
                    bone.transform.rotate.x = class_3532.method_15362((float)(limbPhase * 0.6662f + (float)Math.PI)) * 1.4f * limbSpeed / coefficient;
                    continue;
                }
                if (!bone.name.equals("left_leg")) continue;
                bone.transform.rotate.x = class_3532.method_15362((float)(limbPhase * 0.6662f)) * 1.4f * limbSpeed / coefficient;
            }
            if (handSwingProgress > 0.0f && bobjLeftArm != null && bobjRightArm != null) {
                float swingFactor = handSwingProgress;
                float rotate = -MathUtils.toDeg(class_3532.method_15374((float)(class_3532.method_15355((float)swingFactor) * (float)Math.PI * 2.0f)) * 0.2f);
                bobjLeftArm.transform.translate.z -= (float)Math.sin(MathUtils.toRad(rotate)) * 5.0f / 16.0f;
                bobjLeftArm.transform.translate.x -= ((float)Math.cos(MathUtils.toRad(rotate)) * 5.0f - 5.0f) / 16.0f;
                bobjRightArm.transform.translate.z += (float)Math.sin(MathUtils.toRad(rotate)) * 5.0f / 16.0f;
                bobjRightArm.transform.translate.x += ((float)Math.cos(MathUtils.toRad(rotate)) * 5.0f - 5.0f) / 16.0f;
                BOBJBone group = bobjRightArm;
                group.transform.rotate.y -= MathUtils.toRad(rotate);
                group = bobjLeftArm;
                group.transform.rotate.y -= MathUtils.toRad(rotate);
                group = bobjLeftArm;
                group.transform.rotate.x += MathUtils.toRad(rotate);
                swingFactor = 1.0f - handSwingProgress;
                swingFactor *= swingFactor;
                swingFactor *= swingFactor;
                swingFactor = 1.0f - swingFactor;
                float headPitch = 0.0f;
                float swing1 = class_3532.method_15374((float)(swingFactor * (float)Math.PI));
                float swign2 = class_3532.method_15374((float)(handSwingProgress * (float)Math.PI)) * -(headPitch - 0.7f) * 0.75f;
                bobjRightArm.transform.rotate.x = MathUtils.toRad(group.transform.rotate.x + MathUtils.toDeg(swing1 * 1.2f + swign2));
                bobjRightArm.transform.rotate.y -= MathUtils.toRad(rotate * 2.0f);
                bobjRightArm.transform.rotate.z -= class_3532.method_15374((float)(handSwingProgress * (float)Math.PI)) * -0.4f;
            }
        }
        if (this.basePost != null) {
            this.basePost.apply(target, armature.getModel(), transition, 1.0f, false);
        }
    }

    @Override
    public void playAnimation(String name) {
    }

    protected float lerpAngle(float a, float b, float magnitude) {
        float factor = (magnitude - b) % 360.0f;
        if (factor < -180.0f) {
            factor += 360.0f;
        }
        if (factor >= 180.0f) {
            factor -= 360.0f;
        }
        return b + a * factor;
    }
}

