/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.data;

import java.io.File;
import java.io.IOException;
import mchorse.bbs_mod.data.DataParser;
import mchorse.bbs_mod.data.DataStringifier;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.utils.IOUtils;
import mchorse.bbs_mod.utils.StringUtils;

public class DataToString {
    public static String unescape(String string) {
        StringBuilder builder = new StringBuilder();
        int c = string.length();
        for (int i = 0; i < c; ++i) {
            char character = string.charAt(i);
            if (character == '\\' && i + 1 < c) {
                char next = string.charAt(i + 1);
                if (next == '\\') {
                    ++i;
                } else {
                    if (next == '\"') {
                        builder.append('\"');
                        ++i;
                        continue;
                    }
                    if (next == 'n') {
                        builder.append('\n');
                        ++i;
                        continue;
                    }
                    if (next == 'u' && i + 5 < c) {
                        char[] chars = new char[]{string.charAt(i + 2), string.charAt(i + 3), string.charAt(i + 4), string.charAt(i + 5)};
                        builder.append((char)StringUtils.parseHex(chars));
                        i += 5;
                        continue;
                    }
                }
            }
            builder.append(character);
        }
        return builder.toString();
    }

    public static String escape(String string) {
        StringBuilder builder = new StringBuilder();
        int c = string.length();
        for (int i = 0; i < c; ++i) {
            char character = string.charAt(i);
            if (character == '\"') {
                builder.append('\\');
            } else {
                if (character == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (character == '\\') {
                    builder.append('\\');
                }
            }
            builder.append(character);
        }
        return builder.toString();
    }

    public static String escapeQuoted(String string) {
        return "\"" + DataToString.escape(string) + "\"";
    }

    public static String toString(BaseType base) {
        return DataToString.toString(base, false);
    }

    public static String toString(BaseType base, boolean jsonLike) {
        DataStringifier stringifier = new DataStringifier();
        if (jsonLike) {
            stringifier.jsonLike();
        }
        return stringifier.toString(base);
    }

    public static MapType mapFromString(String string) {
        BaseType data = DataToString.fromString(string);
        return data instanceof MapType ? (MapType)data : null;
    }

    public static ListType listFromString(String string) {
        BaseType data = DataToString.fromString(string);
        return data instanceof ListType ? (ListType)data : null;
    }

    public static BaseType fromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return DataParser.parse(string);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void write(File file, BaseType type) throws IOException {
        DataToString.write(file, type, false);
    }

    public static void write(File file, BaseType type, boolean jsonLike) throws IOException {
        IOUtils.writeText(file, DataToString.toString(type, jsonLike));
    }

    public static boolean writeSilently(File file, BaseType type) {
        return DataToString.writeSilently(file, type, false);
    }

    public static boolean writeSilently(File file, BaseType type, boolean jsonLike) {
        try {
            IOUtils.writeText(file, DataToString.toString(type, jsonLike));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BaseType read(File file) throws IOException {
        return DataToString.fromString(IOUtils.readText(file));
    }
}

