/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.network;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.actions.ActionManager;
import mchorse.bbs_mod.actions.ActionPlayer;
import mchorse.bbs_mod.actions.ActionRecorder;
import mchorse.bbs_mod.actions.ActionState;
import mchorse.bbs_mod.actions.PlayerType;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ByteType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.entity.GunProjectileEntity;
import mchorse.bbs_mod.entity.IEntityFormProvider;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.FilmManager;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.items.GunProperties;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ServerPacketCrusher;
import mchorse.bbs_mod.utils.DataPath;
import mchorse.bbs_mod.utils.EnumUtils;
import mchorse.bbs_mod.utils.PermissionUtils;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.repos.RepositoryOperation;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerNetwork {
    public static final int STATE_TRIGGER_MORPH = 0;
    public static final int STATE_TRIGGER_MAIN_HAND_ITEM = 1;
    public static final int STATE_TRIGGER_OFF_HAND_ITEM = 2;
    public static final class_2960 CLIENT_CLICKED_MODEL_BLOCK_PACKET = new class_2960("bbs", "c1");
    public static final class_2960 CLIENT_PLAYER_FORM_PACKET = new class_2960("bbs", "c2");
    public static final class_2960 CLIENT_PLAY_FILM_PACKET = new class_2960("bbs", "c3");
    public static final class_2960 CLIENT_MANAGER_DATA_PACKET = new class_2960("bbs", "c4");
    public static final class_2960 CLIENT_STOP_FILM_PACKET = new class_2960("bbs", "c5");
    public static final class_2960 CLIENT_HANDSHAKE = new class_2960("bbs", "c6");
    public static final class_2960 CLIENT_RECORDED_ACTIONS = new class_2960("bbs", "c7");
    public static final class_2960 CLIENT_ANIMATION_STATE_TRIGGER = new class_2960("bbs", "c8");
    public static final class_2960 CLIENT_CHEATS_PERMISSION = new class_2960("bbs", "c9");
    public static final class_2960 CLIENT_SHARED_FORM = new class_2960("bbs", "c10");
    public static final class_2960 CLIENT_ENTITY_FORM = new class_2960("bbs", "c11");
    public static final class_2960 CLIENT_ACTORS = new class_2960("bbs", "c12");
    public static final class_2960 CLIENT_GUN_PROPERTIES = new class_2960("bbs", "c13");
    public static final class_2960 CLIENT_PAUSE_FILM = new class_2960("bbs", "c14");
    public static final class_2960 CLIENT_SELECTED_SLOT = new class_2960("bbs", "c15");
    public static final class_2960 CLIENT_ANIMATION_STATE_MODEL_BLOCK_TRIGGER = new class_2960("bbs", "c16");
    public static final class_2960 CLIENT_REFRESH_MODEL_BLOCKS = new class_2960("bbs", "c17");
    public static final class_2960 SERVER_MODEL_BLOCK_FORM_PACKET = new class_2960("bbs", "s1");
    public static final class_2960 SERVER_MODEL_BLOCK_TRANSFORMS_PACKET = new class_2960("bbs", "s2");
    public static final class_2960 SERVER_PLAYER_FORM_PACKET = new class_2960("bbs", "s3");
    public static final class_2960 SERVER_MANAGER_DATA_PACKET = new class_2960("bbs", "s4");
    public static final class_2960 SERVER_ACTION_RECORDING = new class_2960("bbs", "s5");
    public static final class_2960 SERVER_TOGGLE_FILM = new class_2960("bbs", "s6");
    public static final class_2960 SERVER_ACTION_CONTROL = new class_2960("bbs", "s7");
    public static final class_2960 SERVER_FILM_DATA_SYNC = new class_2960("bbs", "s8");
    public static final class_2960 SERVER_PLAYER_TP = new class_2960("bbs", "s9");
    public static final class_2960 SERVER_ANIMATION_STATE_TRIGGER = new class_2960("bbs", "s10");
    public static final class_2960 SERVER_SHARED_FORM = new class_2960("bbs", "s11");
    public static final class_2960 SERVER_ZOOM = new class_2960("bbs", "s12");
    public static final class_2960 SERVER_PAUSE_FILM = new class_2960("bbs", "s13");
    private static ServerPacketCrusher crusher = new ServerPacketCrusher();

    public static void reset() {
        crusher.reset();
    }

    public static void setup() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_MODEL_BLOCK_FORM_PACKET, (server, player, handler, buf, responder) -> ServerNetwork.handleModelBlockFormPacket(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_MODEL_BLOCK_TRANSFORMS_PACKET, (server, player, handler, buf, responder) -> ServerNetwork.handleModelBlockTransformsPacket(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_PLAYER_FORM_PACKET, (server, player, handler, buf, responder) -> ServerNetwork.handlePlayerFormPacket(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_MANAGER_DATA_PACKET, (server, player, handler, buf, responder) -> ServerNetwork.handleManagerDataPacket(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_ACTION_RECORDING, (server, player, handler, buf, responder) -> ServerNetwork.handleActionRecording(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_TOGGLE_FILM, (server, player, handler, buf, responder) -> ServerNetwork.handleToggleFilm(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_ACTION_CONTROL, (server, player, handler, buf, responder) -> ServerNetwork.handleActionControl(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_FILM_DATA_SYNC, (server, player, handler, buf, responder) -> ServerNetwork.handleSyncData(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_PLAYER_TP, (server, player, handler, buf, responder) -> ServerNetwork.handleTeleportPlayer(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_ANIMATION_STATE_TRIGGER, (server, player, handler, buf, responder) -> ServerNetwork.handleAnimationStateTriggerPacket(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_SHARED_FORM, (server, player, handler, buf, responder) -> ServerNetwork.handleSharedFormPacket(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_ZOOM, (server, player, handler, buf, responder) -> ServerNetwork.handleZoomPacket(server, player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SERVER_PAUSE_FILM, (server, player, handler, buf, responder) -> ServerNetwork.handlePauseFilmPacket(server, player, buf));
    }

    private static void handleModelBlockFormPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            class_2338 pos = buf.method_10811();
            try {
                MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
                server.execute(() -> {
                    class_1937 world = player.method_37908();
                    class_2586 be = world.method_8321(pos);
                    if (be instanceof ModelBlockEntity) {
                        ModelBlockEntity modelBlock = (ModelBlockEntity)be;
                        modelBlock.updateForm(data, world);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void handleModelBlockTransformsPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            try {
                MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
                server.execute(() -> {
                    class_1799 stack = player.method_6118(class_1304.field_6173).method_7972();
                    if (stack.method_7909() == BBSMod.MODEL_BLOCK_ITEM) {
                        stack.method_7969().method_10562("BlockEntityTag").method_10566("Properties", DataStorageUtils.toNbt(data));
                    } else if (stack.method_7909() == BBSMod.GUN_ITEM) {
                        stack.method_7948().method_10566("GunData", DataStorageUtils.toNbt(data));
                    }
                    player.method_5673(class_1304.field_6173, stack);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void handlePlayerFormPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            Form form = null;
            try {
                BaseType patt10071$temp = DataStorageUtils.readFromBytes(bytes);
                if (patt10071$temp instanceof MapType) {
                    MapType data = (MapType)patt10071$temp;
                    form = (Form)BBSMod.getForms().fromData(data);
                }
            }
            catch (Exception data) {
                // empty catch block
            }
            Form finalForm = form;
            server.execute(() -> {
                Morph.getMorph((class_1297)player).setForm(FormUtils.copy(finalForm));
                ServerNetwork.sendMorphToTracked(player, finalForm);
            });
        });
    }

    private static void handleManagerDataPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
            int callbackId = packetByteBuf.readInt();
            RepositoryOperation op = RepositoryOperation.values()[packetByteBuf.readInt()];
            FilmManager films = BBSMod.getFilms();
            if (op == RepositoryOperation.LOAD) {
                String id = data.getString("id");
                Film film = (Film)films.load(id);
                ServerNetwork.sendManagerData(player, callbackId, op, film.toData());
            } else if (op == RepositoryOperation.SAVE) {
                films.save(data.getString("id"), data.getMap("data"));
            } else if (op == RepositoryOperation.RENAME) {
                films.rename(data.getString("from"), data.getString("to"));
            } else if (op == RepositoryOperation.DELETE) {
                films.delete(data.getString("id"));
            } else if (op == RepositoryOperation.KEYS) {
                ListType list = DataStorageUtils.stringListToData(films.getKeys());
                ServerNetwork.sendManagerData(player, callbackId, op, list);
            } else if (op == RepositoryOperation.ADD_FOLDER) {
                ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.addFolder(data.getString("folder"))));
            } else if (op == RepositoryOperation.RENAME_FOLDER) {
                ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.renameFolder(data.getString("from"), data.getString("to"))));
            } else if (op == RepositoryOperation.DELETE_FOLDER) {
                ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.deleteFolder(data.getString("folder"))));
            }
        });
    }

    private static void handleActionRecording(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        String filmId = buf.method_19772();
        int replayId = buf.readInt();
        int tick = buf.readInt();
        int countdown = buf.readInt();
        boolean recording = buf.readBoolean();
        server.execute(() -> {
            if (recording) {
                Film film = (Film)BBSMod.getFilms().load(filmId);
                if (film != null) {
                    BBSMod.getActions().startRecording(film, player, 0, countdown, replayId);
                }
            } else {
                ActionRecorder recorder = BBSMod.getActions().stopRecording(player);
                Clips clips = recorder.composeClips();
                ServerNetwork.sendRecordedActions(player, filmId, replayId, tick, clips);
            }
        });
    }

    private static void handleToggleFilm(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        String filmId = buf.method_19772();
        boolean withCamera = buf.readBoolean();
        server.execute(() -> {
            ActionPlayer actionPlayer = BBSMod.getActions().getPlayer(filmId);
            if (actionPlayer != null) {
                BBSMod.getActions().stop(filmId);
                for (class_3222 otherPlayer : server.method_3760().method_14571()) {
                    ServerNetwork.sendStopFilm(otherPlayer, filmId);
                }
            } else {
                ServerNetwork.sendPlayFilm(player, player.method_51469(), filmId, withCamera);
            }
        });
    }

    private static void handleActionControl(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        ActionManager actions = BBSMod.getActions();
        String filmId = buf.method_19772();
        ActionState state = EnumUtils.getValue(buf.readByte(), ActionState.values(), ActionState.STOP);
        int tick = buf.readInt();
        server.execute(() -> {
            if (state == ActionState.SEEK) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                }
            } else if (state == ActionState.PLAY) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                    actionPlayer.playing = true;
                }
            } else if (state == ActionState.PAUSE) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                    actionPlayer.playing = false;
                }
            } else if (state == ActionState.RESTART) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer == null) {
                    Film film = (Film)BBSMod.getFilms().load(filmId);
                    if (film != null) {
                        actionPlayer = actions.play(player, player.method_51469(), film, tick, PlayerType.FILM_EDITOR);
                    }
                } else {
                    actions.stop(filmId);
                    actionPlayer = actions.play(player, player.method_51469(), actionPlayer.film, tick, PlayerType.FILM_EDITOR);
                }
                if (actionPlayer != null) {
                    actionPlayer.syncing = true;
                    actionPlayer.playing = false;
                    if (tick != 0) {
                        actionPlayer.goTo(0, tick);
                    }
                }
                ServerNetwork.sendStopFilm(player, filmId);
            } else if (state == ActionState.STOP) {
                actions.stop(filmId);
            }
        });
    }

    private static void handleSyncData(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            String filmId = packetByteBuf.method_19772();
            ArrayList<String> path = new ArrayList<String>();
            int c = buf.readInt();
            for (int i = 0; i < c; ++i) {
                path.add(buf.method_19772());
            }
            BaseType data = DataStorageUtils.readFromBytes(bytes);
            server.execute(() -> BBSMod.getActions().syncData(filmId, new DataPath(path), data));
        });
    }

    private static void handleTeleportPlayer(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float yaw = buf.readFloat();
        float bodyYaw = buf.readFloat();
        float pitch = buf.readFloat();
        server.execute(() -> {
            player.method_5859(x, y, z);
            player.method_36456(yaw);
            player.method_5847(yaw);
            player.method_5636(bodyYaw);
            player.method_36457(pitch);
        });
    }

    private static void handleAnimationStateTriggerPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        String string = buf.method_19772();
        int type = buf.readInt();
        class_2540 newBuf = PacketByteBufs.create();
        newBuf.writeInt(player.method_5628());
        newBuf.method_10814(string);
        newBuf.writeInt(type);
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_2960)CLIENT_ANIMATION_STATE_TRIGGER, (class_2540)newBuf);
        }
        server.execute(() -> {});
    }

    private static void handleSharedFormPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            UUID playerUuid = packetByteBuf.method_10790();
            MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
            server.execute(() -> {
                class_3222 otherPlayer = server.method_3760().method_14602(playerUuid);
                if (otherPlayer != null) {
                    ServerNetwork.sendSharedForm(otherPlayer, data);
                }
            });
        });
    }

    private static void handleZoomPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        boolean zoom = buf.readBoolean();
        class_1799 main = player.method_6047();
        if (main.method_7909() == BBSMod.GUN_ITEM) {
            String command;
            GunProperties properties = GunProperties.get(main);
            String string = command = zoom ? properties.cmdZoomOn : properties.cmdZoomOff;
            if (!command.isEmpty()) {
                server.method_3734().method_44252(player.method_5671(), command);
            }
        }
    }

    private static void handlePauseFilmPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        String filmId = buf.method_19772();
        ActionPlayer actionPlayer = BBSMod.getActions().getPlayer(filmId);
        if (actionPlayer != null) {
            actionPlayer.toggle();
        }
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            ServerNetwork.sendPauseFilm(playerEntity, filmId);
        }
    }

    public static void sendMorph(class_3222 player, int playerId, Form form) {
        crusher.send((class_1657)player, CLIENT_PLAYER_FORM_PACKET, (BaseType)FormUtils.toData(form), packetByteBuf -> packetByteBuf.writeInt(playerId));
    }

    public static void sendMorphToTracked(class_3222 player, Form form) {
        ServerNetwork.sendMorph(player, player.method_5628(), form);
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            ServerNetwork.sendMorph(otherPlayer, player.method_5628(), form);
        }
    }

    public static void sendClickedModelBlock(class_3222 player, class_2338 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_CLICKED_MODEL_BLOCK_PACKET, (class_2540)buf);
    }

    public static void sendPlayFilm(class_3222 player, class_3218 world, String filmId, boolean withCamera) {
        try {
            Film film = (Film)BBSMod.getFilms().load(filmId);
            if (film != null) {
                BBSMod.getActions().play(player, world, film, 0);
                BaseType data = film.toData();
                crusher.send(world.method_18456().stream().map(p -> p).toList(), CLIENT_PLAY_FILM_PACKET, data, packetByteBuf -> {
                    packetByteBuf.method_10814(filmId);
                    packetByteBuf.writeBoolean(withCamera);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendPlayFilm(class_3222 player, String filmId, boolean withCamera) {
        try {
            Film film = (Film)BBSMod.getFilms().load(filmId);
            if (film != null) {
                BBSMod.getActions().play(player, player.method_51469(), film, 0);
                crusher.send((class_1657)player, CLIENT_PLAY_FILM_PACKET, film.toData(), packetByteBuf -> {
                    packetByteBuf.method_10814(filmId);
                    packetByteBuf.writeBoolean(withCamera);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendStopFilm(class_3222 player, String filmId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(filmId);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_STOP_FILM_PACKET, (class_2540)buf);
    }

    public static void sendManagerData(class_3222 player, int callbackId, RepositoryOperation op, BaseType data) {
        crusher.send((class_1657)player, CLIENT_MANAGER_DATA_PACKET, data, packetByteBuf -> {
            packetByteBuf.writeInt(callbackId);
            packetByteBuf.writeInt(op.ordinal());
        });
    }

    public static void sendRecordedActions(class_3222 player, String filmId, int replayId, int tick, Clips clips) {
        crusher.send((class_1657)player, CLIENT_RECORDED_ACTIONS, clips.toData(), packetByteBuf -> {
            packetByteBuf.method_10814(filmId);
            packetByteBuf.writeInt(replayId);
            packetByteBuf.writeInt(tick);
        });
    }

    public static void sendHandshake(MinecraftServer server, PacketSender packetSender) {
        packetSender.sendPacket(CLIENT_HANDSHAKE, ServerNetwork.createHandshakeBuf(server));
    }

    public static void sendHandshake(MinecraftServer server, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_HANDSHAKE, (class_2540)ServerNetwork.createHandshakeBuf(server));
    }

    private static class_2540 createHandshakeBuf(MinecraftServer server) {
        class_2540 buf = PacketByteBufs.create();
        String id = "";
        if (server.method_3724()) {
            id = "";
        }
        buf.method_10814(id);
        return buf;
    }

    public static void sendCheatsPermission(class_3222 player, boolean cheats) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(cheats);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_CHEATS_PERMISSION, (class_2540)buf);
    }

    public static void sendSharedForm(class_3222 player, MapType data) {
        crusher.send((class_1657)player, CLIENT_SHARED_FORM, (BaseType)data, packetByteBuf -> {});
    }

    public static void sendEntityForm(class_3222 player, IEntityFormProvider actor) {
        crusher.send((class_1657)player, CLIENT_ENTITY_FORM, (BaseType)FormUtils.toData(actor.getForm()), packetByteBuf -> packetByteBuf.writeInt(actor.getEntityId()));
    }

    public static void sendActors(class_3222 player, String filmId, Map<String, class_1309> actors) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(filmId);
        buf.writeInt(actors.size());
        for (Map.Entry<String, class_1309> entry : actors.entrySet()) {
            buf.method_10814(entry.getKey());
            buf.writeInt(entry.getValue().method_5628());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_ACTORS, (class_2540)buf);
    }

    public static void sendGunProperties(class_3222 player, GunProjectileEntity projectile) {
        class_2540 buf = PacketByteBufs.create();
        GunProperties properties = projectile.getProperties();
        buf.writeInt(projectile.getEntityId());
        properties.toNetwork(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_GUN_PROPERTIES, (class_2540)buf);
    }

    public static void sendPauseFilm(class_3222 player, String filmId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(filmId);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_PAUSE_FILM, (class_2540)buf);
    }

    public static void sendSelectedSlot(class_3222 player, int slot) {
        player.method_31548().field_7545 = slot;
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(slot);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_SELECTED_SLOT, (class_2540)buf);
    }

    public static void sendModelBlockState(class_3222 player, class_2338 pos, String trigger) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.method_10814(trigger);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_ANIMATION_STATE_MODEL_BLOCK_TRIGGER, (class_2540)buf);
    }

    public static void sendReloadModelBlocks(class_3222 player, int tickRandom) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(tickRandom);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CLIENT_REFRESH_MODEL_BLOCKS, (class_2540)buf);
    }
}

