/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.ui.film.utils.undo.ValueChangeUndo;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.utils.Timer;
import mchorse.bbs_mod.utils.undo.CompoundUndo;
import mchorse.bbs_mod.utils.undo.IUndo;
import mchorse.bbs_mod.utils.undo.UndoManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIFormUndoHandler {
    protected UndoManager<ValueGroup> undoManager;
    protected Map<BaseValue, BaseType> cachedValues = new HashMap<BaseValue, BaseType>();
    protected boolean cacheMarkLastUndoNoMerging;
    protected MapType uiData;
    protected Timer undoTimer = new Timer(1000L);
    protected UIElement uiElement;

    public static void reduceUndoRedundancy(Map<BaseValue, BaseType> cachedValues) {
        Iterator<BaseValue> it = cachedValues.keySet().iterator();
        while (it.hasNext()) {
            boolean remove = false;
            for (BaseValue value = it.next().getParent(); value != null; value = value.getParent()) {
                if (!cachedValues.containsKey(value)) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
    }

    public UIFormUndoHandler(UIElement uiElement) {
        this.uiElement = uiElement;
        this.reset();
    }

    public UndoManager<ValueGroup> getUndoManager() {
        return this.undoManager;
    }

    public void reset() {
        this.undoManager = new UndoManager(100);
        this.undoManager.setCallback(this::handleUndos);
    }

    private void handleUndos(IUndo<ValueGroup> undo, boolean redo) {
        IUndo<ValueGroup> anotherUndo = undo;
        if (anotherUndo instanceof CompoundUndo) {
            anotherUndo = ((CompoundUndo)anotherUndo).getFirst(ValueChangeUndo.class);
        }
        if (anotherUndo instanceof ValueChangeUndo) {
            ValueChangeUndo change = (ValueChangeUndo)anotherUndo;
            this.uiElement.getRoot().applyAllUndoData(change.getUIData(redo));
        }
    }

    public void handlePreValues(BaseValue baseValue, int flag) {
        if (this.uiData == null) {
            this.uiData = this.uiElement.getRoot().collectAllUndoData();
        }
        if (!this.cachedValues.containsKey(baseValue)) {
            this.cachedValues.put(baseValue, (BaseType)baseValue.toData());
        }
        if ((flag & 1) != 0) {
            this.cacheMarkLastUndoNoMerging = true;
        }
    }

    public void submitUndo() {
        this.handleTimers();
        if (this.cachedValues.isEmpty()) {
            return;
        }
        UIFormUndoHandler.reduceUndoRedundancy(this.cachedValues);
        ArrayList<ValueChangeUndo> changeUndos = new ArrayList<ValueChangeUndo>();
        for (Map.Entry<BaseValue, BaseType> entry : this.cachedValues.entrySet()) {
            BaseValue value = entry.getKey();
            ValueChangeUndo undo = new ValueChangeUndo(value.getPath(), entry.getValue(), (BaseType)value.toData());
            undo.cacheAfter(this.uiElement);
            undo.cacheBefore(this.uiData);
            changeUndos.add(undo);
            this.handleValue(value);
        }
        if (changeUndos.size() == 1) {
            this.undoManager.pushUndo((IUndo)changeUndos.get(0));
        } else if (!changeUndos.isEmpty()) {
            this.undoManager.pushUndo(new CompoundUndo(changeUndos.toArray(new IUndo[0])));
        }
        this.cachedValues.clear();
        this.uiData = null;
        this.undoTimer.mark();
        if (this.cacheMarkLastUndoNoMerging) {
            this.cacheMarkLastUndoNoMerging = false;
            this.undoManager.markLastUndoNoMerging();
        }
    }

    protected void handleValue(BaseValue value) {
    }

    protected void handleTimers() {
        if (this.undoTimer.checkReset()) {
            this.undoManager.markLastUndoNoMerging();
        }
    }
}

