/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.states.keyframes;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.forms.states.AnimationState;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.replays.UIReplaysEditor;
import mchorse.bbs_mod.ui.film.replays.UIReplaysEditorUtils;
import mchorse.bbs_mod.ui.film.replays.overlays.UIAnimationToPoseOverlayPanel;
import mchorse.bbs_mod.ui.film.replays.overlays.UIKeyframeSheetFilterOverlayPanel;
import mchorse.bbs_mod.ui.forms.editors.UIFormEditor;
import mchorse.bbs_mod.ui.forms.editors.states.keyframes.UIAnimationStateKeyframes;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeEditor;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs.UIKeyframeDopeSheet;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.utils.UIDraggable;
import mchorse.bbs_mod.ui.utils.StencilFormFramebuffer;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.resizers.IResizer;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.joml.Matrices;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class UIAnimationStateEditor
extends UIElement {
    public UIKeyframeEditor keyframeEditor;
    public UIFormEditor editor;
    public UIElement editArea;
    private AnimationState state;
    private Set<String> keys = new LinkedHashSet<String>();

    public UIAnimationStateEditor(UIFormEditor editor) {
        this.editor = editor;
        this.editArea = new UIElement();
        this.editArea.relative(this).x(BBSSettings.editorLayoutSettings.getStateEditorSizeH()).wTo((IResizer)this.area, 1.0f).h(1.0f);
        UIDraggable draggable = new UIDraggable(context -> {
            float fx = (float)(context.mouseX - this.area.x) / (float)this.area.w;
            float fy = (float)(-(context.mouseY - this.getParent().area.ey())) / (float)this.getParent().area.h;
            BBSSettings.editorLayoutSettings.setStateEditorSizeV(fy);
            BBSSettings.editorLayoutSettings.setStateEditorSizeH(fx);
            this.h(BBSSettings.editorLayoutSettings.getStateEditorSizeV());
            this.editArea.x(BBSSettings.editorLayoutSettings.getStateEditorSizeH());
            this.getParent().resize();
        });
        draggable.rendering(context -> {
            int size = 5;
            int x = this.editArea.area.x + 3;
            int y = this.editArea.area.y + 3;
            context.batcher.box(x, y, x + 1, y + size, -1);
            context.batcher.box(x, y - 1, x + size, y, -1);
            x = this.editArea.area.x - 3;
            y = this.editArea.area.y + 3;
            context.batcher.box(x - 1, y, x, y + size, -1);
            context.batcher.box(x - size, y - 1, x, y, -1);
        });
        draggable.hoverOnly().relative(this.editArea).w(40).h(6).anchorX(0.5f);
        this.add(this.editArea, draggable);
    }

    public AnimationState getState() {
        return this.state;
    }

    public void setState(AnimationState state) {
        UIKeyframes lastEditor = null;
        if (this.keyframeEditor != null) {
            lastEditor = this.keyframeEditor.view;
            this.keyframeEditor.removeFromParent();
            this.keyframeEditor = null;
        }
        this.state = state;
        if (this.state == null) {
            return;
        }
        ArrayList<UIKeyframeSheet> sheets = new ArrayList<UIKeyframeSheet>();
        for (String key : FormUtils.collectPropertyPaths(this.editor.form)) {
            KeyframeChannel property = this.state.properties.getOrCreate(this.editor.form, key);
            if (property == null) continue;
            BaseValueBasic formProperty = FormUtils.getProperty(this.editor.form, key);
            UIKeyframeSheet sheet = new UIKeyframeSheet(UIReplaysEditor.getColor(key), false, property, formProperty);
            sheets.add(sheet.icon(UIReplaysEditor.getIcon(key)));
        }
        this.keys.clear();
        for (UIKeyframeSheet sheet : sheets) {
            this.keys.add(StringUtils.fileName(sheet.id));
        }
        sheets.removeIf(v -> {
            if (v.id.equals("anchor")) {
                return true;
            }
            for (String s : (Set)BBSSettings.disabledSheets.get()) {
                if (!v.id.equals(s) && !v.id.endsWith("/" + s)) continue;
                return true;
            }
            return false;
        });
        Form lastForm = null;
        for (UIKeyframeSheet sheet : sheets) {
            Form form;
            Form form2 = form = sheet.property == null ? null : FormUtils.getForm(sheet.property);
            if (!Objects.equals(lastForm, form)) {
                sheet.separator = true;
            }
            lastForm = form;
        }
        if (!sheets.isEmpty()) {
            this.keyframeEditor = new UIKeyframeEditor(consumer -> new UIAnimationStateKeyframes(this.editor, (Consumer<Keyframe>)consumer)).target(this.editArea);
            this.keyframeEditor.relative(this).h(1.0f).wTo(this.editArea.area);
            this.keyframeEditor.setUndoId("form_animation_state_keyframe_editor");
            if (lastEditor != null) {
                this.keyframeEditor.view.copyViewport(lastEditor);
            }
            this.keyframeEditor.view.duration(() -> (Integer)this.state.duration.get());
            this.keyframeEditor.view.context((ContextMenuManager menu) -> {
                Form patt6788$temp = this.editor.form;
                if (patt6788$temp instanceof ModelForm) {
                    ModelForm modelForm = (ModelForm)patt6788$temp;
                    int mouseY = this.getContext().mouseY;
                    UIKeyframeSheet sheet = this.keyframeEditor.view.getGraph().getSheet(mouseY);
                    if (sheet != null && sheet.channel.getFactory() == KeyframeFactories.POSE && sheet.id.equals("pose")) {
                        menu.action(Icons.POSE, UIKeys.FILM_REPLAY_CONTEXT_ANIMATION_TO_KEYFRAMES, () -> {
                            ModelInstance model = ModelFormRenderer.getModel(modelForm);
                            if (model != null) {
                                UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)new UIAnimationToPoseOverlayPanel((animationKey, onlyKeyframes, length, step) -> {
                                    int current = this.editor.getCursor();
                                    IEntity entity = this.editor.renderer.getTargetEntity();
                                    UIReplaysEditorUtils.animationToPoseKeyframes(this.keyframeEditor, sheet, modelForm, entity, current, animationKey, onlyKeyframes, length, step);
                                }, modelForm, sheet), 200, 197);
                            }
                        });
                    }
                }
                if (this.keyframeEditor.view.getGraph() instanceof UIKeyframeDopeSheet) {
                    menu.action(Icons.FILTER, UIKeys.FILM_REPLAY_FILTER_SHEETS, () -> {
                        UIKeyframeSheetFilterOverlayPanel panel = new UIKeyframeSheetFilterOverlayPanel((Set)BBSSettings.disabledSheets.get(), this.keys);
                        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 240, 0.9f);
                        panel.onClose(e -> {
                            this.setState(this.state);
                            BBSSettings.disabledSheets.set((Set)BBSSettings.disabledSheets.get());
                        });
                    });
                }
            });
            for (UIKeyframeSheet sheet : sheets) {
                this.keyframeEditor.view.addSheet(sheet);
            }
            this.addAfter(this.editArea, this.keyframeEditor);
        }
        this.resize();
        if (this.keyframeEditor != null && lastEditor == null) {
            this.keyframeEditor.view.resetView();
        }
    }

    public boolean clickViewport(UIContext context, StencilFormFramebuffer stencil) {
        Pair<Form, String> pair;
        if (stencil.hasPicked() && this.state != null && (pair = stencil.getPicked()) != null && context.mouseButton < 2) {
            if (context.mouseButton == 0) {
                if (Window.isCtrlPressed()) {
                    UIReplaysEditorUtils.offerAdjacent(this.getContext(), (Form)pair.a, (String)pair.b, bone -> this.pickForm((Form)pair.a, (String)bone));
                } else if (Window.isShiftPressed()) {
                    UIReplaysEditorUtils.offerHierarchy(this.getContext(), (Form)pair.a, (String)pair.b, bone -> this.pickForm((Form)pair.a, (String)bone));
                } else {
                    this.pickForm((Form)pair.a, (String)pair.b);
                }
                return true;
            }
            if (context.mouseButton == 1) {
                this.pickFormProperty((Form)pair.a, (String)pair.b);
                return true;
            }
        }
        return false;
    }

    public void pickForm(Form form, String bone) {
        UIReplaysEditorUtils.pickForm(this.keyframeEditor, this.editor, form, bone);
    }

    public void pickFormProperty(Form form, String bone) {
        UIReplaysEditorUtils.pickFormProperty(this.getContext(), this.keyframeEditor, this.editor, form, bone);
    }

    public Matrix4f getOrigin(float transition) {
        if (this.keyframeEditor == null) {
            return Matrices.EMPTY_4F;
        }
        Pair<String, Boolean> bone = this.keyframeEditor.getBone();
        if (bone == null) {
            return Matrices.EMPTY_4F;
        }
        Form root = FormUtils.getRoot(this.editor.form);
        Map<String, Matrix4f> map = FormUtilsClient.getRenderer(root).collectMatrices(this.editor.renderer.getTargetEntity(), (Boolean)bone.b != false ? null : (String)bone.a, transition);
        Matrix4f matrix = map.get(bone.a);
        return matrix == null ? Matrices.EMPTY_4F : matrix;
    }

    @Override
    public void render(UIContext context) {
        if (this.keyframeEditor != null) {
            this.editArea.area.render(context.batcher, -1157627904);
        }
        super.render(context);
    }
}

