/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.keys.Keybind;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIKeybinds
extends UIScrollView {
    public Map<String, KeybindCategory> keybinds = new HashMap<String, KeybindCategory>();

    public UIKeybinds() {
        this.markContainer();
        this.scroll.opposite = true;
        this.scroll.cancelScrolling();
    }

    public void addKeybind(Keybind keybind) {
        IKey categoryKey = keybind.getCategory();
        KeybindCategory category = this.keybinds.get(categoryKey.get());
        if (category == null) {
            category = new KeybindCategory(categoryKey);
            this.keybinds.put(categoryKey.get(), category);
        }
        category.add(keybind);
    }

    @Override
    public void render(UIContext context) {
        int cx = 40;
        context.batcher.box(this.area.x, this.area.y, cx, this.area.ey(), -1157627904);
        context.batcher.gradientHBox(cx, this.area.y, this.area.ex(), this.area.ey(), -1157627904, 0);
        super.render(context);
    }

    @Override
    protected void preRender(UIContext context) {
        super.preRender(context);
        int x = this.area.x + 10;
        int y = this.area.y + 10;
        int i = 0;
        KeybindCategory general = this.keybinds.get("");
        i = general == null ? i : general.render(context, x, y, i) + 10;
        for (KeybindCategory category : this.keybinds.values()) {
            if (category == general) continue;
            i = category.render(context, x, y, i) + 10;
        }
        this.keybinds.clear();
        this.scroll.scrollSize = i + 3;
        this.scroll.clamp();
    }

    @Environment(value=EnvType.CLIENT)
    public static class KeybindCategory {
        public IKey title;
        public List<Keybind> keybinds = new ArrayList<Keybind>();
        public boolean shouldClean;

        public KeybindCategory(IKey title) {
            this.title = title;
        }

        public void add(Keybind keybind) {
            if (this.shouldClean) {
                this.keybinds.clear();
                this.shouldClean = false;
            }
            this.keybinds.add(keybind);
        }

        public int render(UIContext context, int x, int y, int i) {
            int color = 0xFF000000 | (Integer)BBSSettings.primaryColor.get();
            String title = this.title.get();
            FontRenderer font = context.batcher.getFont();
            if (!title.isEmpty()) {
                context.batcher.box(x - 10, y + i - 2, x + font.getWidth(title) + 2, y + i + font.getHeight() + 2, color);
                context.batcher.text(title, x, y + i);
                i += 14;
            }
            for (Keybind keybind : this.keybinds) {
                String combo = keybind.getKeyCombo();
                int w = font.getWidth(combo);
                context.batcher.box(x - 2, y + i - 2, x + w + 2, y + i + font.getHeight() + 2, color);
                context.batcher.text(combo, x, y + i);
                context.batcher.textShadow(keybind.getLabel().get(), x + w + 5, y + i);
                i += 14;
            }
            return i;
        }
    }
}

