/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.pose;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.bbs_mod.cubic.IModel;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIStringList;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.presets.UIDataContextMenu;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.pose.Pose;
import mchorse.bbs_mod.utils.pose.PoseManager;
import mchorse.bbs_mod.utils.pose.PoseTransform;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIPoseEditor
extends UIElement {
    private static String lastLimb = "";
    public UIStringList groups = new UIStringList(l -> this.pickBone((String)l.get(0)));
    public UITrackpad fix;
    public UIColor color;
    public UIToggle lighting;
    public UIPropTransform transform;
    private String group = "";
    private Pose pose;
    protected IModel model;
    protected Map<String, String> flippedParts;

    public UIPoseEditor() {
        this.groups.background().h(120);
        this.groups.scroll.cancelScrolling();
        this.groups.context(() -> {
            UIDataContextMenu menu = new UIDataContextMenu(PoseManager.INSTANCE, this.group, () -> this.pose.toData(), this::pastePose);
            UIIcon flip = new UIIcon(Icons.CONVERT, b -> this.flipPose());
            flip.tooltip(UIKeys.POSE_CONTEXT_FLIP_POSE);
            menu.row.addBefore(menu.save, flip);
            return menu;
        });
        this.fix = new UITrackpad(v -> {
            Transform patt2258$temp = this.transform.getTransform();
            if (patt2258$temp instanceof PoseTransform) {
                PoseTransform poseTransform = (PoseTransform)patt2258$temp;
                this.setFix(poseTransform, v.floatValue());
            }
        });
        this.fix.limit(0.0, 1.0).increment(1.0).values(0.1, 0.05, 0.2);
        this.fix.tooltip(UIKeys.POSE_CONTEXT_FIX_TOOLTIP);
        this.fix.context((ContextMenuManager menu) -> menu.action(Icons.DOWNLOAD, UIKeys.POSE_CONTEXT_APPLY, () -> this.applyChildren(p -> this.setFix((PoseTransform)p, (float)this.fix.getValue()))));
        this.color = new UIColor(c -> {
            Transform patt2888$temp = this.transform.getTransform();
            if (patt2888$temp instanceof PoseTransform) {
                PoseTransform poseTransform = (PoseTransform)patt2888$temp;
                this.setColor(poseTransform, (int)c);
            }
        });
        this.color.withAlpha();
        this.color.context((ContextMenuManager menu) -> menu.action(Icons.DOWNLOAD, UIKeys.POSE_CONTEXT_APPLY, () -> this.applyChildren(p -> this.setColor((PoseTransform)p, this.color.picker.color.getARGBColor()))));
        this.lighting = new UIToggle(UIKeys.FORMS_EDITORS_GENERAL_LIGHTING, b -> {
            Transform patt3466$temp = this.transform.getTransform();
            if (patt3466$temp instanceof PoseTransform) {
                PoseTransform poseTransform = (PoseTransform)patt3466$temp;
                this.setLighting(poseTransform, b.getValue());
            }
        });
        this.lighting.h(20);
        this.lighting.context((ContextMenuManager menu) -> menu.action(Icons.DOWNLOAD, UIKeys.POSE_CONTEXT_APPLY, () -> this.applyChildren(p -> this.setLighting((PoseTransform)p, this.lighting.getValue()))));
        this.transform = this.createTransformEditor();
        this.transform.setModel();
        this.column().vertical().stretch();
        this.add(this.groups, UI.label(UIKeys.POSE_CONTEXT_FIX), this.fix, UI.row(this.color, this.lighting), this.transform);
    }

    private void applyChildren(Consumer<PoseTransform> consumer) {
        if (this.model == null) {
            return;
        }
        PoseTransform t = (PoseTransform)this.transform.getTransform();
        Collection<String> keys = this.model.getAllChildrenKeys(CollectionUtils.getKey(this.pose.transforms, t));
        for (String key : keys) {
            consumer.accept(this.pose.get(key));
        }
    }

    public Pose getPose() {
        return this.pose;
    }

    public String getGroup() {
        return (String)this.groups.getCurrentFirst();
    }

    protected void pastePose(MapType data) {
        String current = (String)this.groups.getCurrentFirst();
        this.pose.fromData(data);
        this.pickBone(current);
    }

    protected void flipPose() {
        String current = (String)this.groups.getCurrentFirst();
        this.pose.flip(this.flippedParts);
        this.pickBone(current);
    }

    public void setPose(Pose pose, String group) {
        this.pose = pose;
        this.group = group;
    }

    public void fillGroups(Collection<String> groups, boolean reset) {
        this.model = null;
        this.flippedParts = null;
        this.fillInGroups(groups, reset);
    }

    public void fillGroups(IModel model, Map<String, String> flippedParts, boolean reset) {
        this.model = model;
        this.flippedParts = flippedParts;
        this.fillInGroups(model == null ? Collections.emptyList() : model.getAllGroupKeys(), reset);
    }

    private void fillInGroups(Collection<String> groups, boolean reset) {
        this.groups.clear();
        this.groups.add(groups);
        this.groups.sort();
        this.fix.setVisible(!groups.isEmpty());
        this.color.setVisible(!groups.isEmpty());
        this.transform.setVisible(!groups.isEmpty());
        List list = this.groups.getList();
        int i = reset ? 0 : list.indexOf(lastLimb);
        this.groups.setCurrentScroll((String)CollectionUtils.getSafe(list, i));
        this.pickBone((String)this.groups.getCurrentFirst());
    }

    public void selectBone(String bone) {
        lastLimb = bone;
        this.groups.setCurrentScroll(bone);
        this.pickBone(bone);
    }

    protected UIPropTransform createTransformEditor() {
        return new UIPropTransform().enableHotkeys();
    }

    protected void pickBone(String bone) {
        lastLimb = bone;
        PoseTransform poseTransform = this.pose.get(bone);
        if (poseTransform != null) {
            this.fix.setValue(poseTransform.fix);
            this.color.setColor(poseTransform.color.getARGBColor());
            this.lighting.setValue(poseTransform.lighting == 0.0f);
            this.transform.setTransform(poseTransform);
        } else {
            this.fix.setValue(0.0);
            this.color.setColor(-1);
            this.lighting.setValue(false);
            this.transform.setTransform(null);
        }
    }

    protected void setFix(PoseTransform transform, float value) {
        transform.fix = value;
    }

    protected void setColor(PoseTransform transform, int value) {
        transform.color.set(value);
    }

    protected void setLighting(PoseTransform poseTransform, boolean value) {
        poseTransform.lighting = value ? 0.0f : 1.0f;
    }
}

